package ISSearch;

import java.io.*;
import java.net.*;
import java.util.*;
import java.lang.*;

/**
 * The Crawler class of the Web search engine.
 * This class is used to start and stop the Crawler,
 * to reset the engine and to control crawling parameters.
 */
public class ISDBCrawler implements ISDBCrawlerInterface
{
    /**
    * The Built-In database Interface of the crawler
    */
   private ISDBinterface dbinterface;
   
   ISCrawler c = new ISCrawler();
   MainGUI m = new MainGUI();
   ISDB isdb = new ISDB();
   
   /** Creates a new instance of ISCrawler */
   public ISDBCrawler()
   {
   }
   
    /**
    * Stores the crawled document and its URL into the database
    * @param link the URL of the crawled document
    * @param doc extracted terms and links from the document
    * @return true, if the storage was successful; false otherwise.
    */
   public boolean store(URL link, ISDocumentInterface doc)
   {
       return isdb.store(link, doc);
   }
   
   /** Initializes the internal database interface and opens its database connection
    * @return true, if the connection to the database was successful, false otherwise.
    */
   public boolean openDB()
   {
       return isdb.openConnection(m.getUsername(), m.getPassword(), m.getHostname(), m.getPort(), m.getServicename());
   }
   
   /**
    * Closes the database connection of the built-in database interface.
    */
   public void closeDB()
   {
       isdb.closeConnection();
   }
   
   /** Returns the built-in database interface of the crawler
    * @return the database interface of the crawler
    */
   public ISDBinterface getDBInterface()
   {
     return dbinterface;
   }
   
//==================================================================
   
   /**
    * Adds a new link to the URL queue, if the link is not yet visited.
    * @param link The URL link representation of the new target
    */
   public void addLink(java.net.URL link)
   {
       c.addLink(link);
   }
   
   /** Returns the best candidate to be visited next.
    *  The result must have the highest priority
    * (in the sense of the selected ordering strategy) under
    * all available links.
    * @return The best target to be visited by the Crawler next, <code>null</code> if the queue is empty.
    */
   public java.net.URL getBest()
   {
      return c.getBest();
   }
   
   /** Returns the current maximum allowed crawling depth.
    * @return The current allowed craling depth.
    */
   public int getCrawlingDepth()
   {
      return c.getCrawlingDepth();
   }
   
   /**
    * Returns the last document visited by the Crawler.
    * @return The last visited document as object that implements ISDocumentInterface (and contains all
    * extracted links, words and their stems); null if no documents were crawled yet.
    */
   public ISDocumentInterface getCurrentDocument()
   {
      return c.getCurrentDocument();
   }
   
   public void setCurrentDocument(ISDocumentInterface isd)
   {
       c.setCurrentDocument(isd);
   }
   
   /**
    * Returns the last URL visited by the Crawler.
    * @return The last visited URL; null if no links were crawled yet.
    */
   public java.net.URL getCurrentURL()
   {
      return c.getCurrentURL();
   }
   
   /** Returns the maximum allowed size of the URL Queue
    * @return The max allowed Queue size
    */
   public int getMaxQueueSize()
   {
      return c.getMaxQueueSize();
   }
   
   /** Returns the current size of the URL queue
    * @return The current size of the URL queue.
    */
   public int getQueueSize()
   {
      return c.getQueueSize();
   }
   
   /**
    * Returns the current state of the crawler.
    * Possible states are <code>RUNNING</code> and <code>STOPPED</code>.
    * @return The current state of the crawler, <code>RUNNING</code> oder <code>STOPPED</code>
    */
   public int getState()
   {
      return c.getState();
   }
   
   public void setState(int state_code)
   {
       c.setState(state_code);
   }
   
   public int getTimeout()
   {
       return c.getTimeout();
   }
   
   public void setTimeout(int t)
   {
       c.setTimeout(t);
   }
   
   /**
    * Checks if the URL of the given document is already visited by the crawler.
    * @return <code>true</code> if the engine was able to recognize
    * the given URL as already visited, <code>false</code>.
    */
   public boolean isVisited(java.net.URL doc)
   {
      return c.isVisited(doc);
   }
   
   /** Sets the maximum allowed crawling depth.
    * @param depth The maximum allowed craling depth.
    */
   public void setCrawlingDepth(int depth)
   {
       c.setCrawlingDepth(depth);
   }
   
   /** Set the maximum allowed size of the URL queue
    * @param m The maximum allowed Queue size
    */
   public void setQueueMaxSize(int m)
   {
       c.setQueueMaxSize(m);
   }
   
   /**
    * Starts the thread of the crawler and changes the engine state to <code>RUNNING</code>
    */
   public void start()
   {
       Thread crawldb = new Thread(this);
       
       c.setState(RUNNING);
       crawldb.start();
   }
   
   /**
    * Stops the crawler.
    * This method stops crawling and sets the engine status to <code>STOPPED</code>.
    */
   public void stop()
   {
       c.setState(STOPPED);
   }
   
   /**
    * Resets the crawler.
    * This method stops the crawling,
    * resets the URL queue, and the list of visited links.
    * Finally, it sets the crawler status to <code>STOPPED</code>,
    */
   public void reset()
   {
       c.vectorSearched.removeAllElements();
       c.vectorToSearch.removeAllElements();
       c.setState(STOPPED);
   }
   
   /* This method is prescribed by the <code>Runnable</code> Interface.
    * The call <code>new Thread(..).start()</code> starts this method
    * in a new thread.
    */
   public void run()
   {
       c.run();
   }
   
   public java.net.URL getNextURL()
   {
       return c.getNextURL();
   }
   
   public boolean isDataStructureEmpty()
   {
       return c.isDataStructureEmpty();
   }
   
   public ISDocumentInterface runParser(Reader r)
   {
       return c.runParser(r);
   }
   
   public String getContentType(URLConnection urlConnection)
   {
       return c.getContentType(urlConnection);
   }
   
   public boolean robotSafe(java.net.URL url)
   {
       return c.robotSafe(url);
   }
}