package ISSearch;

import java.io.*;

/**
 * This <B>mandatory</B> class must implement all functions prescribed by <code>ISTermInterface</code>
 * 
 */
public class ISTerm implements ISTermInterface
{
    private String word;
    private int location;
    
   /** Creates a new instance of ISTerm */
    public ISTerm()
    {
    }
    
  /**
  * This function returns the original extracted word
  * @return The word that was initially extracted from the document
  */   
    public String getWord()
    {
        return word;
    }
    
  /**
  * This function sets the original extracted word
  * @param The word (String s) that was initially extracted from the document
  */   
    public void setWord(String s)
    {
        word = s;
    }
    
  /**
  * This function returns the word stem
  * @return The stem that was created using String.toLowerCase() and Porter stemming
  */   
    public String getStem()
    {
        ISParser p = new ISParser();
        return p.stem(word);
    }
    
  /**
  * This function returns the position of the word in the source document
  * @return The position of this word in the source document
  */   
    public int getPos()
    {
        return location;
    }
    
  /**
  * This function sets the position of the word in the source document
  * @param The position (int i) of this word in the source document
  */   
    public void setPos(int i)
    {
        location = i;
    }
}