package ISSearch;

/**
 * This interface is used to represent particular terms of the document. 
 * The objects that implement this interface are used 
 * to store particular words and word stems.
 * @see String
 */
public interface ISTermInterface
{
 
  /**
  * This function returns the original extracted word
  * @return The word that was initially extracted from the document
  */   
 public String getWord();
 
   /**
  * This function returns the word stem
  * @return The stem that was created using String.toLowerCase() and Porter stemming
  */   
 public String getStem();
 
  /**
  * This function returns the position of the word in the source document
  * @return The position of this word in the source document
  */   
 public int getPos();
}
