package ISSearch;

import java.net.URL;
import java.lang.String;

/**
 * Interface des Query-Prozessors. Der Query Processor soll einfache Suchanfragen bearbeiten und die 
 * Rangliste der besten Treffer - sortiert nach Relevanz - zurckgeben. 
 */
public interface ISQueryProcessorInterface
{
   /**
    * Diese Methode soll die Anfrage analysieren und die Top-10 der Trefferliste - sortiert nach Relevanz - zurckgeben. 
    * Einzelne Schritte bei der Verarbeitung der Anfrage sind:
    * <UL>
    * <LI> die Anfrage analysieren (z.B. Sonderzeichen entfernen, String.toLowerCase() anwenden, etc.) und einzelne Suchbegriffe extrahieren; 
    * <LI> Stoppwrter aus der Query entfernen; 
    * <LI> die restlichen Keywords in Wortstmme mit Hilfe des Stemmers umwandeln; 
    * <LI> Datenbankverbindung herstellen
    * <LI> Die Anfrage auf eine SQL-Query abbilden und diese auf der Datenbank ausfhren; 
    * <LI> Datenbankverbindung schliessen
    * <LI> Top-10 URLs der Trefferliste (ggf. weniger) als Ergebnis zurueckgeben.
    * </UL>
    * @param anfrage Die Query, die der Prozessor verarbeiten soll. Sie besteht aus positiven und auszuschliessenden Suchbegriffen, getrennt 
    * durch Leerzeichen (d.h ein Treffer soll passende Features zu 
    * <B>allen</B> positiven Wrtern enthalten und darf <B>keine</B> Negativ-Features enthalten). Man kann davon ausgehen, 
    * dass jede Query mindestens einen 'positiven' Suchbegriff enthalten soll.
    * <P>
    * Format der Suchanfrage:
    * <PRE>        
    * [-]key_1 [-]key_2 ... [-]key_n
    * </PRE>  
    * mit:
    * <PRE>       
    *   key   - Treffer soll den Wortstamm des Suchbegriffs enthalten.
    *  -key   - Treffer darf den Wortstamm des Suchbegriffs nicht enthalten.
    * </PRE>
    * @return Die Top-10 der Trefferliste (URLs der gefundenen Dokumente), sortiert absteigend nach Relevanz (d.h. result[0] 
    * hat den besten Score, result[1] den zweitbesten, usw.).
    * Als Relevanzma verwenden wir den 
    * Skalarprodukt zwischen dem Query-Vektor und dem Featurevektor des Dokuments. Die Query wird in unserem 
    * Modell durch den Vektor ihrer Positivterme (jeweils mit Gewicht 1.0) dargestellt, fr die Gewichtung der 
    * Features in den Dokumenten soll <code>tf*idf</code> Ma benutzt werden. Die Negativterme der Query werden bei der 
    * Berechnung der Relevanz nicht bercksichtigt. Wurden keine Treffer gefunden, gibt die Funktion <code>null</code> zurueck.
    * Sind bei der Verarbeitung der Anfrage Fehler aufgetreten, soll ebenfalls <code>null</code> zurueckgegeben werden.
    */
   public URL[] executeQuery(String anfrage);
}
