package ISSearch;
 
import java.rmi.*;

/**
 * RMI Remote Interface for the Server part of the distributed IS Search application
 */
public interface ISPeerServerInterface extends Remote 
{
  /**
   * The port of the RMI service that is used by clients to submit queries to the server.
   * The RMI service runs by default on port 1099.
   */  
  static int port = 1099; 
  
  /**
   * The name of the peer search engine that is used by clients to execute 
   * queries via RMI.
   */
  static String serviceName = "PeerSearch";
  
  /**
   * Remotely invocable search method. This method is called by peers to execute queries.
   * @param query The query that is submitted by the client. The query syntax is prescribed by Assignment 4 (Query Processor).
   * @param numResults The max number of best matches that can be returned as search results for the query.
   * @return The array of search results that contains up to <code>numResults</code> matches, sorted 
   * in DESCENDING ORDER of relevance.
   * The relevance is defined as the similarity 
   * between the document and the query (we use the scalar product 
   * between two feature vectors that represent the query and the document 
   * as the similarity metric).

   * @exception RemoteException if the remote invocation of the search fails.
   */
  public ISPeerResultInterface[] search(String query, int numResults) throws RemoteException;
}
