package ISSearch;
 
import java.rmi.*;
import java.rmi.server.*;

/**
 * Sample Server Class for the distributed ISSearch search engine.
 * This Server returns one and the same match (www.yahoo.de) for any given query.
 */
public class ISPeerServer extends UnicastRemoteObject implements ISPeerServerInterface
{

   /** 
    * The constructor of the ISPeerServer class. According to the RMI requirements, 
    * the default constructor 
    * is required to catch the <code>RemoteException</code>. To this end, 
    * it must be present 
    * in the class even if the construction of a new instance requires no special action.
    */
   public ISPeerServer() throws RemoteException
   {
   }
   
   /** 
    * Sample search function for the RMI server of the ISSearch search engine.
    */
   public ISPeerResultInterface[] search(String query, int numResults) throws RemoteException
   {
      ISPeerResultInterface[] results = new ISPeerResultInterface[1];
      ISPeerResult result = new ISPeerResult();
      
      result.setURL ("http://www.yahoo.de");
      result.setScore (1.0);
      
      ISFeature feature = new ISFeature();
      feature.setTerm ("yahoo");
      feature.setTF (2.0);
      feature.setRTF (0.04);
      ISFeatureInterface[] features = new ISFeatureInterface[1];
      features[0] = feature;
      
      result.setFeatures(features);
      
      results[0] = result;
      
      return results;
   }
   
   /**
    * Starts the RMI Server program for the IS search engine.
    * @param argv The command line arguments which are ignored.
    */
   public static void main(String[] argv)
   {
      try
      {
         System.setSecurityManager (new SecurityManager());

        
         Naming.rebind("PeerSearch", new ISPeerServer());
         System.out.println("ISSearch RMI server is ready.");
      }
      catch (Exception e)
      {
         e.printStackTrace();
      }
   }
}
