package ISSearch;
 

import java.io.*;

/**
 * This interface prescribes the general structure of search results
 * returned by the ISSearch search engine.
 */
public interface ISPeerResultInterface extends Serializable
{
  /**
   * Returns the relevance (rank) of the document in the context of given query. 
   * The relevance is used in our application scenario for ranked retrieval 
   * of query results; the best of them (e.g. top 10) are returned to 
   * the user. The document relevance is defined as the similarity 
   * between the document and the query (we use the scalar product 
   * between two feature vectors that represent the query and the document 
   * as the similarity metric).
   * @return The relevance of the document in the context of given query.
   */ 
  public double getScore();
  
  /**
   * Returns the array of document features that correspond to query terms.
   * The collection of features is query-specific; it is NOT required 
   * to include ALL available terms of the document into this set.
   * The features are 
   * pairs (term,weight) that are represented in our framework by objects that implement 
   * the interface <code>ISFeatureInterface</code>.
   * @see ISFeatureInterface
   * @see ISFeature
   * @return The array of document-specific features.
   */
  public ISFeatureInterface[] getFeatures();

  /**
   * Returns the absolute URL of the documents as a String.
   * @return The absolute URL of the document as string object.
   */
  public String getURL();
}
