package ISSearch;
 
/**
 * Sample class that implements the interface ISPeerResultInterface. 
 * This class represents the search result returned by the ISSearch search engine.
 */
public class ISPeerResult implements ISPeerResultInterface, Comparable
{
   /**
    * The ID of this search result. Internally used by the compareTo method to allow 
    * disamibiguation of equal-scored search results (e.g. when accessing them within 
    * Java Collections or Sets).
    */ 
   public int id;

   /**
    * The max existing ID of search results. Internally used by the compareTo method to allow 
    * disamibiguation of equal-scored search results (e.g. when accessing them within 
    * Java Collections or Sets).
    */    
   private static int maxID;
   
   public ISPeerResult()
   {
     synchronized (this.getClass())
     {
       if (maxID == Integer.MAX_VALUE)
          maxID = 0;
       this.id = ++maxID;
     }
   }
   
  /**
   * Returns the array of document features that correspond to query terms.
   * The collection of features is query-specific; it is NOT required 
   * to include ALL available terms of the document into this set.
   * The features are 
   * pairs (term,weight) that are represented in our framework by objects that implement 
   * the interface <code>ISFeatureInterface</code>.
   * @see ISFeatureInterface
   * @see ISFeature
   */
   private ISFeatureInterface[] features;
   
   /**
   * The absolute URL of the documents as a String.
   */
   private String URL;
   
  /**
   * The relevance (rank) of the document in the context of given query. 
   * The relevance is used in our application scenario for ranked retrieval 
   * of query results; the best of them (e.g. top 10) are returned to 
   * the user. The document relevance is defined as the similarity 
   * between the document and the query (we use the scalar product 
   * between two feature vectors that represent the query and the document 
   * as the similarity metric).
   */
   private double score;
   
  /**
   * Returns the score (rank) of the document in the context of given query. 
   * @return The score of the document in the context of given query.
   */   
   public ISFeatureInterface[] getFeatures()
   {
      return this.features;
   }
   
  /**
   * Returns the relevance of the document.
   * @return The relevance of the document in the context of given query. 
   */  
   public double getScore()
   {
      return this.score;
   }

  /**
   * Returns the absolute URL of the documents as a String.
   * @return The absolute URL of the document as string object.
   */
   public String getURL()
   {
      return this.URL;
   }
   
   /**
    * Sets the array of document features.
    * @param f The new array of document features.
    */
   public void setFeatures(ISFeatureInterface[] f)
   {
      this.features = f;
   }
   
   /**
    * Sets the absolute URL of the document.
    * @param u The absolute URL of the document as a String.
    */
   public void setURL(String u)
   {
      this.URL = u;
   }
   
   /**
    * Sets the score (rank) of the document.
    * @param s The new score of the document as double value.
    */
   public void setScore (double s)
   {
      this.score = s;
   }
   
   /**
    * This function is required for the interface Comparable that is implemented by this object.
    * The objects that implement the interface Comparable can be automatically sorted 
    * using built-in Java functions. Note that Java sorts object in ascending order (lower values first).
    * To obtain items sorted in descending order (higher values first), we need to invert the outcome of the
    * compareto function as shown in this sample class. 
    */ 
   public int compareTo(Object o)
   {
      ISPeerResult other = (ISPeerResult)o;
      if (this.score < other.score)
         return +1;
      if (this.score > other.score)
         return -1;
      if (this.id < other.id)
         return -1;
      if (this.id > other.id)
         return +1;
      return 0;
   }
}
