package ISSearch;
 
import java.rmi.*;
import java.rmi.server.*;
import java.net.*;

/**
 * The sample search client for the distributed ISSearch search engine.
 */
public class ISPeerClient
{
   /**
    * Sends the test query to the RMI server that is expected to be running on the same machine.
    * @param argv The command line arguments which are ignored.
    */ 
   public static void main(String[] argv)
   {
      // The port of the connection to the RMI Server; 1099 is the default RMI port.
      int port = 1099;
      
      // The ISSearch search class is registered on the RMI server under this name.
      String serviceName = "PeerSearch";
      
      // Our test query.
      String query = "yahoo";
      
      // We expect to obtain up to top 10 results from the peer
      int numResults = 10;
      
      try
      {
         // Obtain the String representation of the local IP address
         String host = ISPeerTools.IP2String(ISPeerTools.getLocalIP());
         
         // Open the connection to the RMI service
         ISPeerServerInterface server = ISPeerTools.getServer(host,port, serviceName); 
         
         // Execute search remotely; obtain top results from the peer
         ISPeerResultInterface[] results = ISPeerTools.search(server, query, numResults);
         
         // Some output
         System.out.println ();
         System.out.println ("RMI Server: " + host);
         System.out.println ("RMI Port: " + port);
         System.out.println ("RMI Service: " + serviceName);
         System.out.println ();
         System.out.println ("Query: " + query);
         System.out.println ("Treffer:");
         for (int i=0; i<results.length;i++)
            System.out.println("   " + (i+1) + ". " + results[i].getURL() + " -> " + results[i].getScore());
      }
      catch (Exception e)
      {
         e.printStackTrace();
      }
   }
}