package ISSearch;

import java.io.*;
import java.util.*;
import javax.swing.text.html.*;
 
/**
 * Parser-Interface of the Web search engine.
 * The parser reads any given text or HTML input (represented by the <code>Reader</code>) and extracts
 * all words and links from that source.
 * The result must be returned as Object that implements the <I>ISDocumentInterface</I>
 * @see String
 * @see HTMLEditorKit
 * @see StringTokenizer 
 */ 
public interface ISParserInterface
{

  /** Performs the input analysis. Returns the container object that implements the <I>ISDocumentInterface</I> and contains extracted 
   * words, word stems, and links.
   * @param input the input of the parser (e.g., text file or HTTP connection), represented by the <code>Reader</code>
   * @return Container object with terms and links or <I>null</I> if any internal error occurs.
   */
  public ISDocumentInterface parse(Reader input);

  /** Decides whether the given token is claimed as stopword or not. This function must apply 
   * the FreeWAIS stopword list. This function must be implementen case-insensitive (e.g., 
   * both tokens 'the' and 'ThE' should be properly recognized as stopwords)
   * @param who The String to be checked.
   * @return true if the given string is a stopword, false otherwise.
   */
  public boolean isStopword (String who);
  
  /** Applies the Porter stemming algorithm and returns the resulting word stem. 
   * The output must be normalized (using String.toLowerCase() and String.trim())
   * @param who The word to be stemmed.
   * @return word stem, trimmed and lowercase.
   */
  public String stem (String who);
}  
