package ISSearch;

import java.io.*;

/**
 * This <B>mandatory</B> class must implement all functions prescribed by <code>ISParserInterface</code>
 * 
 */
public class ISParser implements ISParserInterface
{
   
   /** Creates a new instance of ISParser */
   public ISParser()
   {
   }
   
  /** Decides whether the given token is claimed as stopword or not. This function must apply 
   * the FreeWAIS stopword list. This function must be implementen case-insensitive (e.g., 
   * both tokens 'the' and 'ThE' should be properly recognized as stopwords)
   * @param who The String to be checked.
   * @return true if the given string is a stopword, false otherwise.
   */
   public boolean isStopword(String who)
   {
      return false;
   }
   
    /** Performs the input analysis. Returns the container object that implements the <I>ISDocumentInterface</I> and contains extracted 
   * words, word stems, and links.
   * @param input the input of the parser (e.g., text file or HTTP connection), represented by the <code>Reader</code>
   * @return Container object with terms and links or <I>null</I> if any internal error occurs.
   */
   public ISDocumentInterface parse(Reader input)
   {
      return null;
   }
   
    /** Applies the Porter stemming algorithm and returns the resulting word stem. 
   * The output must be normalized (using String.toLowerCase() and String.trim())
   * @param who The word to be stemmed.
   * @return word stem, trimmed and lowercase.
   */
   public String stem(String who)
   {
      return null;
   }
}
