package ISSearch;
 

import java.io.*;

/**
 * This interface prescribes the general structure of document features for the ISSearch search engine.
 */
public interface ISFeatureInterface extends Serializable
{
   /**
    * Returns the term that is represented by this feature in the bag-of-words model. 
    * For compatibility reasons, we assume that 
    * all features are word stems generated by the Porter stemming algorithm 
    * from original words of the document after stopword removal.
    * We also assume that all terms are converted to lowercase and trimmed 
    * usind String.toLowerCase() and String.trim() functions.
    * @return The term that is represented by this feature.
    */
   public String getTerm();
   
   /**
    * Returns the absolute Term Frequency (TF) weight of the feature in the document. 
    * TF is defined as the total number of term occurences in the current document.
    * @return The document-specific TF weight of the feature.
    */
   public double getTF();

   /**
    * Returns the Relative Term Frequency (RTF) weight of the feature in the document.
    * RTF is defined as RTF / N, where N is the total number of terms in the current document.
    * @return The document-specific RTF weight of the feature.
    */
   public double getRTF();   
}
