package ISSearch;
 

/**
 * Sample class that implements the ISFeatureInterface and represents one feature
 * in the ISSearch search engine.
 */
public class ISFeature implements ISFeatureInterface
{
   /**
    * The term that is represented by this feature in the bag-of-words model. 
    * For compatibility reasons, we assume that 
    * all features are word stems generated by the Porter stemming algorithm 
    * from original words of the document after stopword removal.
    * We also assume that all terms are converted to lowercase and trimmed 
    * usind String.toLowerCase() and String.trim() functions.
    */
   private String term;
   
   /**
    * The absolute Term Frequency (TF) weight of the feature in the document. 
    * TF is defined as the total number of term occurences in the current document.
    */   
   private double tf;
   
  /**
    * The Relative Term Frequency (RTF) weight of the feature in the document.
    * RTF is defined as RTF / N, where N is the total number of terms in the current document.
    */
   private double rtf;

   /**
    * Returns the Relative Term Frequency (RTF) weight of the feature in the document.
    * @return The document-specific RTF weight of the feature.
    */   
   public double getRTF()
   {
      return this.rtf;
   }
   
   /**
    * Returns the absolute Term Frequency (TF) weight of the feature in the document. 
    * @return The document-specific TF weight of the feature.
    */   
   public double getTF()
   {
      return this.tf;
   }
   
   /**
    * Returns the term that is represented by this feature in the bag-of-words model. 
    * @return The term that is represented by this feature.
    */
   public String getTerm()
   {
      return this.term;
   }
   
   /**
    * Sets the RTF (Relative Term Frequency) weight of the feature.
    * @param r The RTF weight of the feature.
    */
   public void setRTF(double r)
   {
      this.rtf = r;
   }
   
   /**
    * Sets the TF (term frequency) weight of the feature.
    * @param t The TF weight of the feature.
    */
   public void setTF(double t)
   {
      this.tf = t;
   }
   
   /**
    * Sets the term of the feature.
    * @param t The term (word stem) of the feature.
    */
   public void setTerm(String t)
   {
     this.term = t;
   }
}
