package ISSearch;

import java.util.*;
import java.io.*;
import java.net.*;

/**
 * This interface is used to represent the parsed document. 
 * The objects that implement this interface are used 
 * to store extracted words and links. 
 * The solution <B>must</B> contain the class 
 * that implements all functions prescribed by this interface.
 * @see URL
*/
public interface ISDocumentInterface
{

  /**
  * Returns the set of absolute Url's extracted from the current document.
  * @return URLs extracted from the document (as <code>Array</code> of <code>URL</code>), or <I>null</I> when no links were found
  */
  public URL[] getUrls();

  /**
  * Returns the bag of words extracted from the document. The result should contain no stopwords.
  * @return The <code>Array</code> of words extracted from the document (as <code>Array</code> of Objects that must implement <code>ISTermInterface</code>),  or <I>null</I> when no terms were found
  */
  public ISTermInterface[] getTerms();

  /**
  * Returns the absolute URL of the current document 
  * @return The absolute URL of the current document as <code>String</code>
  */
  public String getLink(); 
}
