/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.ui.views;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.update.configuration.IConfiguredSite;
import org.eclipse.update.internal.ui.UpdateUI;
import org.eclipse.update.operations.IToggleSiteOperation;
import org.eclipse.update.operations.OperationsManager;

public class SiteStateAction
extends Action {
    private IConfiguredSite site;

    public void setSite(IConfiguredSite site) {
        this.site = site;
        boolean state = site.isEnabled();
        this.setText(state ? UpdateUI.getString("SiteStateAction.disableLabel") : UpdateUI.getString("SiteStateAction.enableLabel"));
    }

    public void run() {
        try {
            if (this.site == null) {
                return;
            }
            IStatus status = OperationsManager.getValidator().validatePlatformConfigValid();
            if (status != null) {
                ErrorDialog.openError((Shell)UpdateUI.getActiveWorkbenchShell(), null, null, (IStatus)status);
                return;
            }
            boolean oldValue = this.site.isEnabled();
            if (!this.confirm(!oldValue)) {
                return;
            }
            IToggleSiteOperation toggleSiteOperation = OperationsManager.getOperationFactory().createToggleSiteOperation(this.site);
            boolean restartNeeded = toggleSiteOperation.execute(null, null);
            UpdateUI.requestRestart(restartNeeded);
        }
        catch (CoreException e) {
            ErrorDialog.openError((Shell)UpdateUI.getActiveWorkbenchShell(), null, null, (IStatus)e.getStatus());
        }
        catch (InvocationTargetException e) {
            UpdateUI.logException(e);
        }
    }

    private boolean confirm(boolean newState) {
        String name = this.site.getSite().getURL().toString();
        String enableMessage = UpdateUI.getFormattedMessage("SiteStateAction.enableMessage", name);
        String disableMessage = UpdateUI.getFormattedMessage("SiteStateAction.disableMessage", name);
        String message = newState ? enableMessage : disableMessage;
        return MessageDialog.openConfirm((Shell)UpdateUI.getActiveWorkbenchShell(), (String)UpdateUI.getString("SiteStateAction.dialogTitle"), (String)message);
    }
}

