/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import java.util.BitSet;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.ListenerList;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPart2;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.internal.PartPane;
import org.eclipse.ui.internal.PartSite;
import org.eclipse.ui.internal.ReferenceCounter;
import org.eclipse.ui.internal.WorkbenchImages;
import org.eclipse.ui.internal.util.Util;

public abstract class WorkbenchPartReference
implements IWorkbenchPartReference {
    protected IWorkbenchPart part;
    private String id;
    protected PartPane pane;
    private String title;
    private String tooltip;
    private Image image;
    private ImageDescriptor imageDescriptor;
    private ListenerList propChangeListeners = new ListenerList(2);
    private String partName;
    private String contentDescription;
    private BitSet queuedEvents = new BitSet();
    private boolean queueEvents = false;
    private IPropertyListener propertyChangeListener = new IPropertyListener(){

        public void propertyChanged(Object source, int propId) {
            WorkbenchPartReference.this.partPropertyChanged(source, propId);
        }
    };

    private void deferEvents(boolean shouldQueue) {
        this.queueEvents = shouldQueue;
        if (!this.queueEvents) {
            int eventIdx = this.queuedEvents.nextSetBit(0);
            while (eventIdx >= 0) {
                this.firePropertyChange(eventIdx);
                eventIdx = this.queuedEvents.nextSetBit(eventIdx + 1);
            }
            this.queuedEvents.clear();
        }
    }

    protected void setTitle(String newTitle) {
        if (Util.equals(this.title, newTitle)) {
            return;
        }
        this.title = newTitle;
        this.firePropertyChange(1);
    }

    protected void setPartName(String newPartName) {
        if (Util.equals(this.partName, newPartName)) {
            return;
        }
        this.partName = newPartName;
        this.firePropertyChange(260);
    }

    protected void setContentDescription(String newContentDescription) {
        if (Util.equals(this.contentDescription, newContentDescription)) {
            return;
        }
        this.contentDescription = newContentDescription;
        this.firePropertyChange(261);
    }

    protected void setToolTip(String newToolTip) {
        if (Util.equals(this.tooltip, newToolTip)) {
            return;
        }
        this.tooltip = newToolTip;
        this.firePropertyChange(1);
    }

    protected void partPropertyChanged(Object source, int propId) {
        if (propId == 261 || propId == 260 || propId == 1) {
            this.refreshFromPart();
        } else {
            this.firePropertyChange(propId);
        }
    }

    protected void refreshFromPart() {
        this.deferEvents(true);
        this.setPartName(this.computePartName());
        this.setTitle(this.computeTitle());
        this.setContentDescription(this.computeContentDescription());
        this.setToolTip(this.getRawToolTip());
        if (!Util.equals(this.image, this.part.getTitleImage())) {
            this.firePropertyChange(1);
        }
        this.deferEvents(false);
    }

    public void init(String id, String title, String tooltip, ImageDescriptor desc, String paneName, String contentDescription) {
        this.id = id;
        this.title = title;
        this.tooltip = tooltip;
        this.imageDescriptor = desc;
        this.partName = paneName;
        this.contentDescription = contentDescription;
    }

    public void releaseReferences() {
        this.id = null;
        if (this.image != null && this.imageDescriptor != null) {
            if (this.part != null) {
                this.part.getTitleImage();
            }
            ReferenceCounter imageCache = WorkbenchImages.getImageCache();
            this.image = (Image)imageCache.get(this.imageDescriptor);
            if (this.image != null) {
                imageCache.removeRef(this.imageDescriptor);
            }
            this.image = null;
            this.imageDescriptor = null;
        }
    }

    public void addPropertyListener(IPropertyListener listener) {
        this.propChangeListeners.add((Object)listener);
    }

    public void removePropertyListener(IPropertyListener listener) {
        this.propChangeListeners.remove((Object)listener);
    }

    public String getId() {
        IWorkbenchPartSite site;
        if (this.part != null && (site = this.part.getSite()) != null) {
            return site.getId();
        }
        return Util.safeString(this.id);
    }

    public String getTitleToolTip() {
        return Util.safeString(this.tooltip);
    }

    protected final String getRawToolTip() {
        return Util.safeString(this.part.getTitleToolTip());
    }

    public String getPartName() {
        return Util.safeString(this.partName);
    }

    protected final String getRawPartName() {
        String result = "";
        if (this.part instanceof IWorkbenchPart2) {
            IWorkbenchPart2 part2 = (IWorkbenchPart2)this.part;
            result = Util.safeString(part2.getPartName());
        }
        return result;
    }

    protected String computePartName() {
        return this.getRawPartName();
    }

    public String getContentDescription() {
        return Util.safeString(this.contentDescription);
    }

    protected String computeContentDescription() {
        return this.getRawContentDescription();
    }

    protected final String getRawContentDescription() {
        if (this.part instanceof IWorkbenchPart2) {
            IWorkbenchPart2 part2 = (IWorkbenchPart2)this.part;
            return part2.getContentDescription();
        }
        return "";
    }

    public boolean isDirty() {
        return false;
    }

    public String getTitle() {
        return Util.safeString(this.title);
    }

    protected String computeTitle() {
        return this.getRawTitle();
    }

    protected final String getRawTitle() {
        return Util.safeString(this.part.getTitle());
    }

    public Image getTitleImage() {
        if (this.part != null) {
            return this.part.getTitleImage();
        }
        if (this.image != null) {
            return this.image;
        }
        if (this.imageDescriptor == null) {
            return null;
        }
        ReferenceCounter imageCache = WorkbenchImages.getImageCache();
        this.image = (Image)imageCache.get(this.imageDescriptor);
        if (this.image != null) {
            imageCache.addRef(this.imageDescriptor);
            return this.image;
        }
        this.image = this.imageDescriptor.createImage();
        imageCache.put(this.imageDescriptor, this.image);
        return this.image;
    }

    private void firePropertyChange(int id) {
        if (this.queueEvents) {
            this.queuedEvents.set(id);
            return;
        }
        Object[] listeners = this.propChangeListeners.getListeners();
        int i = 0;
        while (i < listeners.length) {
            ((IPropertyListener)listeners[i]).propertyChanged(this.part, id);
            ++i;
        }
    }

    public void setPart(IWorkbenchPart part) {
        this.part = part;
        if (part == null) {
            return;
        }
        part.addPropertyListener(this.propertyChangeListener);
        PartSite site = (PartSite)part.getSite();
        if (site != null && this.pane != null) {
            site.setPane(this.pane);
            this.pane = null;
        }
    }

    public void setPane(PartPane pane) {
        PartSite site;
        if (pane == null) {
            return;
        }
        if (this.part != null && (site = (PartSite)this.part.getSite()) != null) {
            site.setPane(pane);
            return;
        }
        this.pane = pane;
    }

    public PartPane getPane() {
        PartSite partSite;
        PartPane result = null;
        if (this.part != null && (partSite = (PartSite)this.part.getSite()) != null) {
            result = partSite.getPane();
        }
        if (result == null) {
            result = this.pane;
        }
        return result;
    }

    public void dispose() {
        this.propChangeListeners.clear();
        if (this.image != null && this.imageDescriptor != null) {
            int count;
            ReferenceCounter imageCache = WorkbenchImages.getImageCache();
            if (this.image != null && (count = imageCache.removeRef(this.imageDescriptor)) <= 0) {
                this.image.dispose();
            }
            this.imageDescriptor = null;
            this.image = null;
        }
        if (this.part != null) {
            this.part.removePropertyListener(this.propertyChangeListener);
            this.part.dispose();
        }
        this.part = null;
    }
}

