/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.intro.impl.model.loader;

import java.io.IOException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.ui.internal.intro.impl.util.Log;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class IntroContentParser {
    private static String TAG_INTRO_CONTENT = "introContent";
    private Document document;

    public IntroContentParser(String content) {
        try {
            Element rootElement;
            this.document = this.parse(content);
            if (this.document != null && !(rootElement = this.document.getDocumentElement()).getTagName().equals(TAG_INTRO_CONTENT)) {
                this.document = null;
                String msg = "Intro content file has incorrect parent tag: " + content;
                Log.warning(msg);
            }
        }
        catch (Exception e) {
            Log.error("Could not load Intro content file: " + content, e);
        }
    }

    private Document parse(String fileURI) {
        Document document = null;
        try {
            DocumentBuilder parser = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            document = parser.parse(fileURI);
            return document;
        }
        catch (SAXParseException spe) {
            StringBuffer buffer = new StringBuffer("IntroParser error in line ");
            buffer.append(spe.getLineNumber());
            buffer.append(", uri ");
            buffer.append(spe.getSystemId());
            buffer.append("\n");
            buffer.append(spe.getMessage());
            Exception x = spe;
            if (spe.getException() != null) {
                x = spe.getException();
            }
            Log.error(buffer.toString(), x);
        }
        catch (SAXException sxe) {
            Exception x = sxe;
            if (sxe.getException() != null) {
                x = sxe.getException();
            }
            Log.error(((Throwable)x).getMessage(), x);
        }
        catch (ParserConfigurationException pce) {
            Log.error(pce.getMessage(), pce);
        }
        catch (IOException ioe) {
            Log.error(ioe.getMessage(), ioe);
        }
        return null;
    }

    public Document getDocument() {
        return this.document;
    }
}

