/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.actions;

import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.actions.CopyProjectAction;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.dialogs.ProjectLocationMoveDialog;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;
import org.eclipse.ui.internal.progress.ProgressMonitorJobsDialog;

public class MoveProjectAction
extends CopyProjectAction {
    private static String MOVE_TOOL_TIP = IDEWorkbenchMessages.getString("MoveProjectAction.toolTip");
    private static String MOVE_TITLE = IDEWorkbenchMessages.getString("MoveProjectAction.text");
    private static String PROBLEMS_TITLE = IDEWorkbenchMessages.getString("MoveProjectAction.dialogTitle");
    private static String MOVE_PROGRESS_TITLE = IDEWorkbenchMessages.getString("MoveProjectAction.progressMessage");
    public static final String ID = "org.eclipse.ui.MoveProjectAction";

    public MoveProjectAction(Shell shell) {
        super(shell, MOVE_TITLE);
        this.setToolTipText(MOVE_TOOL_TIP);
        this.setId(ID);
        WorkbenchHelp.setHelp((IAction)this, (String)"org.eclipse.ui.ide.move_project_action_context");
    }

    protected String getErrorsTitle() {
        return PROBLEMS_TITLE;
    }

    boolean performMove(final IProject project, final String projectName, final IPath newLocation) {
        WorkspaceModifyOperation op = new WorkspaceModifyOperation(){

            /*
             * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void execute(IProgressMonitor monitor) {
                monitor.beginTask(MOVE_PROGRESS_TITLE, 100);
                try {
                    try {
                        if (monitor.isCanceled()) {
                            throw new OperationCanceledException();
                        }
                        IProjectDescription newDescription = MoveProjectAction.this.createDescription(project, projectName, newLocation);
                        monitor.worked(50);
                        project.move(newDescription, 33, monitor);
                        monitor.worked(50);
                    }
                    catch (CoreException e) {
                        MoveProjectAction.this.recordError(e);
                    }
                }
                catch (Throwable throwable) {
                    Object var3_5 = null;
                    monitor.done();
                    throw throwable;
                }
                {
                    Object var3_6 = null;
                }
                monitor.done();
            }
        };
        try {
            new ProgressMonitorJobsDialog(this.shell).run(true, true, (IRunnableWithProgress)op);
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        catch (InvocationTargetException e) {
            IDEWorkbenchPlugin.log(MessageFormat.format("Exception in {0}.performMove(): {1}", ((Object)((Object)this)).getClass().getName(), e.getTargetException()));
            this.displayError(IDEWorkbenchMessages.format("MoveProjectAction.internalError", new Object[]{e.getTargetException().getMessage()}));
            return false;
        }
        return true;
    }

    protected Object[] queryDestinationParameters(IProject project) {
        ProjectLocationMoveDialog dialog = new ProjectLocationMoveDialog(this.shell, project);
        dialog.setTitle(IDEWorkbenchMessages.getString("MoveProjectAction.moveTitle"));
        dialog.open();
        return dialog.getResult();
    }

    public void run() {
        this.errorStatus = null;
        IProject project = (IProject)this.getSelectedResources().get(0);
        Object[] destinationPaths = this.queryDestinationParameters(project);
        if (destinationPaths == null) {
            return;
        }
        String projectName = (String)destinationPaths[0];
        Path newLocation = new Path((String)destinationPaths[1]);
        boolean completed = this.performMove(project, projectName, (IPath)newLocation);
        if (!completed) {
            return;
        }
        if (this.errorStatus != null) {
            ErrorDialog.openError((Shell)this.shell, (String)PROBLEMS_TITLE, null, (IStatus)this.errorStatus);
            this.errorStatus = null;
        }
    }
}

