/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui.actions;

import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.internal.ui.Utils;
import org.eclipse.team.internal.ui.actions.ITeamRunnableContext;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.progress.IProgressConstants;

public final class JobRunnableContext
implements ITeamRunnableContext {
    private IJobChangeListener listener;
    private IWorkbenchSite site;
    private String jobName;
    private ISchedulingRule schedulingRule;
    private boolean postponeBuild;
    private boolean isUser;
    private URL icon;
    private boolean keep;
    private IAction gotoAction;

    public JobRunnableContext(String jobName) {
        this(jobName, null, null, false, null, null);
    }

    public JobRunnableContext(String jobName, URL icon, IAction action, boolean keep, IJobChangeListener listener, IWorkbenchSite site) {
        this.jobName = jobName;
        this.listener = listener;
        this.site = site;
        this.isUser = true;
        this.gotoAction = action;
        this.icon = icon;
        this.keep = keep;
    }

    public void run(IRunnableWithProgress runnable) {
        Job job;
        if (this.schedulingRule == null && !this.postponeBuild) {
            job = this.getBasicJob(runnable);
        } else {
            job = this.getWorkspaceJob(runnable);
            if (this.schedulingRule != null) {
                job.setRule(this.schedulingRule);
            }
        }
        if (this.listener != null) {
            job.addJobChangeListener(this.listener);
        }
        job.setUser(this.isUser());
        this.configureJob(job);
        Utils.schedule(job, this.site);
    }

    private void configureJob(Job job) {
        if (this.keep) {
            job.setProperty(IProgressConstants.KEEP_PROPERTY, (Object)Boolean.TRUE);
        }
        if (this.gotoAction != null) {
            job.setProperty(IProgressConstants.ACTION_PROPERTY, (Object)this.gotoAction);
        }
        if (this.icon != null) {
            job.setProperty(IProgressConstants.ICON_PROPERTY, (Object)this.icon);
        }
    }

    public Shell getShell() {
        final Shell[] newShell = new Shell[1];
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                newShell[0] = Utils.getShell(JobRunnableContext.this.site);
            }
        });
        return newShell[0];
    }

    public boolean isPostponeBuild() {
        return this.postponeBuild;
    }

    public void setPostponeBuild(boolean postponeBuild) {
        this.postponeBuild = postponeBuild;
    }

    public ISchedulingRule getSchedulingRule() {
        return this.schedulingRule;
    }

    public boolean isUser() {
        return this.isUser;
    }

    public void setUser(boolean isUser) {
        this.isUser = isUser;
    }

    public void setSchedulingRule(ISchedulingRule schedulingRule) {
        this.schedulingRule = schedulingRule;
    }

    IStatus run(IRunnableWithProgress runnable, IProgressMonitor monitor) {
        try {
            runnable.run(monitor);
        }
        catch (InvocationTargetException e) {
            return TeamException.asTeamException((InvocationTargetException)e).getStatus();
        }
        catch (InterruptedException interruptedException) {
            return Status.OK_STATUS;
        }
        return Status.OK_STATUS;
    }

    private Job getBasicJob(final IRunnableWithProgress runnable) {
        return new Job(this.jobName){

            public IStatus run(IProgressMonitor monitor) {
                return JobRunnableContext.this.run(runnable, monitor);
            }
        };
    }

    private Job getWorkspaceJob(final IRunnableWithProgress runnable) {
        return new WorkspaceJob(this.jobName){

            public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                return JobRunnableContext.this.run(runnable, monitor);
            }
        };
    }
}

