/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.core.RepositoryProvider;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.CVSProviderPlugin;
import org.eclipse.team.internal.ccvs.core.CVSTeamProvider;
import org.eclipse.team.internal.ccvs.core.ICVSFile;
import org.eclipse.team.internal.ccvs.core.ICVSFileModificationValidator;
import org.eclipse.team.internal.ccvs.core.resources.CVSWorkspaceRoot;
import org.eclipse.team.internal.ccvs.ui.CVSUIPlugin;
import org.eclipse.team.internal.ccvs.ui.Policy;
import org.eclipse.team.internal.ccvs.ui.actions.EditorsAction;

public class FileModificationValidator
implements ICVSFileModificationValidator {
    public static final IStatus OK = new Status(0, "org.eclipse.team.cvs.ui", 0, Policy.bind("ok"), null);

    public IStatus validateEdit(IFile[] files, Object context) {
        IFile[] readOnlyFiles = this.getManagedReadOnlyFiles(files);
        if (readOnlyFiles.length == 0) {
            return OK;
        }
        return this.edit(readOnlyFiles, this.getShell(context));
    }

    public IStatus validateSave(IFile file) {
        if (!this.needsCheckout(file)) {
            return OK;
        }
        return this.edit(new IFile[]{file}, (Shell)null);
    }

    public IStatus validateMoveDelete(IFile[] files, IProgressMonitor monitor) {
        IFile[] readOnlyFiles = this.getManagedReadOnlyFiles(files);
        if (readOnlyFiles.length == 0) {
            return OK;
        }
        try {
            this.edit(readOnlyFiles, monitor);
            return OK;
        }
        catch (CVSException e) {
            return e.getStatus();
        }
    }

    private IFile[] getManagedReadOnlyFiles(IFile[] files) {
        ArrayList<IFile> readOnlys = new ArrayList<IFile>();
        int i = 0;
        while (i < files.length) {
            IFile iFile = files[i];
            if (this.needsCheckout(iFile)) {
                readOnlys.add(iFile);
            }
            ++i;
        }
        return readOnlys.toArray(new IFile[readOnlys.size()]);
    }

    private boolean needsCheckout(IFile file) {
        try {
            if (file.isReadOnly()) {
                ICVSFile cvsFile = CVSWorkspaceRoot.getCVSFileFor((IFile)file);
                return cvsFile.isManaged();
            }
        }
        catch (CVSException e) {
            CVSUIPlugin.log((CoreException)((Object)e));
        }
        return false;
    }

    private CVSTeamProvider getProvider(IFile[] files) {
        CVSTeamProvider provider = (CVSTeamProvider)RepositoryProvider.getProvider((IProject)files[0].getProject(), (String)CVSProviderPlugin.getTypeId());
        return provider;
    }

    private Shell getShell(Object context) {
        if (context instanceof Shell) {
            return (Shell)context;
        }
        return null;
    }

    private IStatus getStatus(InvocationTargetException e) {
        Throwable target = e.getTargetException();
        if (target instanceof TeamException) {
            return ((TeamException)target).getStatus();
        }
        if (target instanceof CoreException) {
            return ((CoreException)target).getStatus();
        }
        return new Status(4, "org.eclipse.team.cvs.ui", 0, Policy.bind("internal"), target);
    }

    private IStatus edit(final IFile[] files, Shell shell) {
        if (this.isPerformEdit()) {
            try {
                if (shell != null && !this.promptToEditFiles(files, shell)) {
                    throw new InterruptedException();
                }
                CVSUIPlugin.runWithProgress(shell, false, new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        try {
                            FileModificationValidator.this.edit(files, monitor);
                        }
                        catch (CVSException e) {
                            new InvocationTargetException(e);
                        }
                    }
                }, 1);
            }
            catch (InvocationTargetException e) {
                return this.getStatus(e);
            }
            catch (InterruptedException interruptedException) {
                return new Status(8, "org.eclipse.team.cvs.ui", 0, Policy.bind("FileModificationValidator.vetoMessage"), null);
            }
        } else {
            int i = 0;
            while (i < files.length) {
                IFile file = files[i];
                file.setReadOnly(false);
                ++i;
            }
        }
        return OK;
    }

    private boolean promptToEditFiles(IFile[] files, Shell shell) throws InvocationTargetException, InterruptedException {
        if (files.length == 0) {
            return true;
        }
        if (this.isNeverPrompt()) {
            return true;
        }
        EditorsAction editors = this.fetchEditors(files, shell);
        if (editors.isEmpty()) {
            if (this.isAlwaysPrompt()) {
                return this.promptEdit(shell);
            }
            return true;
        }
        return editors.promptToEdit(shell);
    }

    private boolean promptEdit(Shell shell) {
        final boolean[] result = new boolean[1];
        CVSUIPlugin.openDialog(shell, new CVSUIPlugin.IOpenableInShell(){

            public void open(Shell shell) {
                result[0] = MessageDialog.openQuestion((Shell)shell, (String)Policy.bind("FileModificationValidator.3"), (String)Policy.bind("FileModificationValidator.4"));
            }
        }, 1);
        return result[0];
    }

    private boolean isPerformEdit() {
        return "edit".equals(CVSUIPlugin.getPlugin().getPreferenceStore().getString("pref_edit_action"));
    }

    private EditorsAction fetchEditors(IFile[] files, Shell shell) throws InvocationTargetException, InterruptedException {
        final EditorsAction editors = new EditorsAction(this.getProvider(files), (IResource[])files);
        CVSUIPlugin.runWithProgress(shell, false, new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                editors.run(monitor);
            }
        }, 1);
        return editors;
    }

    private boolean isNeverPrompt() {
        return "never".equals(CVSUIPlugin.getPlugin().getPreferenceStore().getString("pref_edit_prompt"));
    }

    private boolean isAlwaysPrompt() {
        return "always".equals(CVSUIPlugin.getPlugin().getPreferenceStore().getString("pref_edit_prompt"));
    }

    private void edit(IFile[] files, IProgressMonitor monitor) throws CVSException {
        this.getProvider(files).edit((IResource[])files, false, true, 0, monitor);
    }
}

