/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ssh2;

import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.KeyPair;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.SftpATTRS;
import com.jcraft.jsch.SftpException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.team.internal.ccvs.core.util.Util;
import org.eclipse.team.internal.ccvs.ssh2.CVSSSH2Plugin;
import org.eclipse.team.internal.ccvs.ssh2.ExportDialog;
import org.eclipse.team.internal.ccvs.ssh2.JSchSession;
import org.eclipse.team.internal.ccvs.ssh2.PassphrasePrompt;
import org.eclipse.team.internal.ccvs.ssh2.Policy;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class CVSSSH2PreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    public static String KEY_PROXY = "CVSSSH2PreferencePage.PROXY";
    public static String KEY_PROXY_TYPE = "CVSSSH2PreferencePage.PROXY_TYPE";
    public static String KEY_PROXY_HOST = "CVSSSH2PreferencePage.PROXY_HOST";
    public static String KEY_PROXY_PORT = "CVSSSH2PreferencePage.PROXY_PORT";
    public static String KEY_PROXY_AUTH = "CVSSSH2PreferencePage.PROXY_AUTH";
    public static String KEY_PROXY_USER = "CVSSSH2PreferencePage.PROXY_USER";
    public static String KEY_PROXY_PASS = "CVSSSH2PreferencePage.PROXY_PASS";
    public static String KEY_SSH2HOME = "CVSSSH2PreferencePage.SSH2HOME";
    public static String KEY_KEYFILE = "CVSSSH2PreferencePage.KEYFILE";
    public static String KEY_PRIVATEKEY = "CVSSSH2PreferencePage.PRIVATEKEY";
    static String SOCKS5 = "SOCKS5";
    static String HTTP = "HTTP";
    private static String HTTP_DEFAULT_PORT = "80";
    private static String SOCKS5_DEFAULT_PORT = "1080";
    private static String privatekeys = "id_dsa,id_rsa";
    static String DSA = "DSA";
    static String RSA = "RSA";
    private Label ssh2HomeLabel;
    private Label proxyTypeLabel;
    private Label proxyHostLabel;
    private Label proxyPortLabel;
    private Label proxyUserLabel;
    private Label proxyPassLabel;
    private Label privateKeyLabel;
    private Combo proxyTypeCombo;
    private Text ssh2HomeText;
    private Text proxyHostText;
    private Text proxyPortText;
    private Text proxyUserText;
    private Text proxyPassText;
    private Text privateKeyText;
    private Button enableProxy;
    private Button enableAuth;
    private Button privateKeyAdd;
    private boolean useProxy;
    private boolean useAuth;
    private Button ssh2HomeBrowse;
    private Button keyGenerateDSA;
    private Button keyGenerateRSA;
    private Button keyLoad;
    private Button keyExport;
    private Button saveKeyPair;
    private Label keyCommentLabel;
    private Text keyCommentText;
    private Label keyFingerPrintLabel;
    private Text keyFingerPrintText;
    private Label keyPassphrase1Label;
    private Text keyPassphrase1Text;
    private Label keyPassphrase2Label;
    private Text keyPassphrase2Text;
    private Label publicKeylabel;
    private Text publicKeyText;
    private KeyPair kpair = null;
    private String kpairComment;
    public static final String AUTH_SCHEME = "";
    public static final URL FAKE_URL;

    static {
        URL temp = null;
        try {
            temp = new URL("http://org.eclipse.team.cvs.ssh2");
        }
        catch (MalformedURLException malformedURLException) {}
        FAKE_URL = temp;
    }

    public CVSSSH2PreferencePage() {
        IPreferenceStore store = CVSSSH2Plugin.getDefault().getPreferenceStore();
        this.setPreferenceStore(store);
        this.setDescription(Policy.bind("CVSSSH2PreferencePage.18"));
    }

    protected Control createContents(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        container.setLayout((Layout)layout);
        TabFolder tabFolder = new TabFolder(container, 0);
        tabFolder.setLayoutData((Object)new GridData(1808));
        TabItem tabItem = new TabItem(tabFolder, 0);
        tabItem.setText(Policy.bind("CVSSSH2PreferencePage.19"));
        tabItem.setControl(this.createGeneralPage((Composite)tabFolder));
        tabItem = new TabItem(tabFolder, 0);
        tabItem.setText(Policy.bind("CVSSSH2PreferencePage.20"));
        tabItem.setControl(this.createProxyPage((Composite)tabFolder));
        tabItem = new TabItem(tabFolder, 0);
        tabItem.setText(Policy.bind("CVSSSH2PreferencePage.21"));
        tabItem.setControl(this.createKeyManagementPage((Composite)tabFolder));
        IPreferenceStore store = CVSSSH2Plugin.getDefault().getPreferenceStore();
        CVSSSH2PreferencePage.initDefaults(store);
        this.initControls();
        Dialog.applyDialogFont((Control)parent);
        return container;
    }

    private Control createGeneralPage(Composite parent) {
        Composite group = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        group.setLayout((Layout)layout);
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        group.setLayoutData((Object)data);
        this.createSpacer(group, 3);
        this.ssh2HomeLabel = new Label(group, 0);
        this.ssh2HomeLabel.setText(Policy.bind("CVSSSH2PreferencePage.23"));
        this.ssh2HomeText = new Text(group, 2052);
        this.ssh2HomeText.setFont(group.getFont());
        GridData gd = new GridData(768);
        gd.horizontalSpan = 1;
        this.ssh2HomeText.setLayoutData((Object)gd);
        this.ssh2HomeBrowse = new Button(group, 0);
        this.ssh2HomeBrowse.setText(Policy.bind("CVSSSH2PreferencePage.24"));
        gd = new GridData(256);
        gd.horizontalSpan = 1;
        this.ssh2HomeBrowse.setLayoutData((Object)gd);
        this.createSpacer(group, 3);
        this.privateKeyLabel = new Label(group, 0);
        this.privateKeyLabel.setText(Policy.bind("CVSSSH2PreferencePage.25"));
        this.privateKeyText = new Text(group, 2052);
        this.privateKeyText.setFont(group.getFont());
        gd = new GridData(768);
        gd.horizontalSpan = 1;
        this.privateKeyText.setLayoutData((Object)gd);
        this.privateKeyAdd = new Button(group, 0);
        this.privateKeyAdd.setText(Policy.bind("CVSSSH2PreferencePage.26"));
        gd = new GridData(256);
        gd.horizontalSpan = 1;
        this.privateKeyAdd.setLayoutData((Object)gd);
        this.ssh2HomeBrowse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String home = CVSSSH2PreferencePage.this.ssh2HomeText.getText();
                if (!new File(home).exists()) {
                    int foo;
                    while ((foo = home.lastIndexOf(File.separator, home.length())) != -1 && !new File(home = home.substring(0, foo)).exists()) {
                    }
                }
                DirectoryDialog dd = new DirectoryDialog(CVSSSH2PreferencePage.this.getShell());
                dd.setFilterPath(home);
                dd.setMessage(Policy.bind("CVSSSH2PreferencePage.27"));
                String dir = dd.open();
                if (dir == null) {
                    return;
                }
                CVSSSH2PreferencePage.this.ssh2HomeText.setText(dir);
            }
        });
        this.privateKeyAdd.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String home = CVSSSH2PreferencePage.this.ssh2HomeText.getText();
                FileDialog fd = new FileDialog(CVSSSH2PreferencePage.this.getShell(), 4098);
                fd.setFilterPath(home);
                String o = fd.open();
                if (o == null) {
                    return;
                }
                String[] files = fd.getFileNames();
                String keys = CVSSSH2PreferencePage.this.privateKeyText.getText();
                String dir = fd.getFilterPath();
                dir = dir.equals(home) ? CVSSSH2PreferencePage.AUTH_SCHEME : String.valueOf(dir) + File.separator;
                int i = 0;
                while (i < files.length) {
                    String foo = files[i];
                    if (keys.length() != 0) {
                        keys = String.valueOf(keys) + ",";
                    }
                    keys = String.valueOf(keys) + dir + foo;
                    ++i;
                }
                CVSSSH2PreferencePage.this.privateKeyText.setText(keys);
            }
        });
        return group;
    }

    private Control createProxyPage(Composite parent) {
        Composite group = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        group.setLayout((Layout)layout);
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        group.setLayoutData((Object)data);
        this.enableProxy = new Button(group, 32);
        this.enableProxy.setText(Policy.bind("CVSSSH2PreferencePage.30"));
        GridData gd = new GridData();
        gd.horizontalSpan = 3;
        this.enableProxy.setLayoutData((Object)gd);
        this.proxyTypeLabel = new Label(group, 0);
        this.proxyTypeLabel.setText(Policy.bind("CVSSSH2PreferencePage.31"));
        this.proxyTypeCombo = new Combo(group, 8);
        this.proxyTypeCombo.setFont(group.getFont());
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.proxyTypeCombo.setLayoutData((Object)gd);
        this.proxyTypeCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (CVSSSH2PreferencePage.this.proxyPortText == null) {
                    return;
                }
                Combo combo = (Combo)e.getSource();
                String foo = combo.getText();
                if (foo.equals(HTTP)) {
                    CVSSSH2PreferencePage.this.proxyPortText.setText(HTTP_DEFAULT_PORT);
                } else if (foo.equals(SOCKS5)) {
                    CVSSSH2PreferencePage.this.proxyPortText.setText(SOCKS5_DEFAULT_PORT);
                }
            }
        });
        this.proxyTypeCombo.add(HTTP);
        this.proxyTypeCombo.add(SOCKS5);
        this.proxyTypeCombo.select(0);
        this.proxyHostLabel = new Label(group, 0);
        this.proxyHostLabel.setText(Policy.bind("CVSSSH2PreferencePage.32"));
        this.proxyHostText = new Text(group, 2052);
        this.proxyHostText.setFont(group.getFont());
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.proxyHostText.setLayoutData((Object)gd);
        this.proxyPortLabel = new Label(group, 0);
        this.proxyPortLabel.setText(Policy.bind("CVSSSH2PreferencePage.33"));
        this.proxyPortText = new Text(group, 2052);
        this.proxyPortText.setFont(group.getFont());
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.proxyPortText.setLayoutData((Object)gd);
        this.proxyPortText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (CVSSSH2PreferencePage.this.isValidPort(CVSSSH2PreferencePage.this.proxyPortText.getText())) {
                    CVSSSH2PreferencePage.this.setErrorMessage(null);
                }
            }
        });
        this.createSpacer(group, 3);
        this.enableAuth = new Button(group, 32);
        this.enableAuth.setText(Policy.bind("CVSSSH2PreferencePage.34"));
        gd = new GridData();
        gd.horizontalSpan = 3;
        this.enableAuth.setLayoutData((Object)gd);
        this.proxyUserLabel = new Label(group, 0);
        this.proxyUserLabel.setText(Policy.bind("CVSSSH2PreferencePage.35"));
        this.proxyUserText = new Text(group, 2052);
        this.proxyUserText.setFont(group.getFont());
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.proxyUserText.setLayoutData((Object)gd);
        this.proxyPassLabel = new Label(group, 0);
        this.proxyPassLabel.setText(Policy.bind("CVSSSH2PreferencePage.36"));
        this.proxyPassText = new Text(group, 2052);
        this.proxyPassText.setFont(group.getFont());
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.proxyPassText.setLayoutData((Object)gd);
        this.enableProxy.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                CVSSSH2PreferencePage.this.updateControls();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.enableAuth.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                CVSSSH2PreferencePage.this.updateControls();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        return group;
    }

    private Control createKeyManagementPage(Composite parent) {
        int columnSpan = 3;
        Composite group = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        group.setLayout((Layout)layout);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        group.setLayoutData((Object)gd);
        this.keyGenerateDSA = new Button(group, 0);
        this.keyGenerateDSA.setText(Policy.bind("CVSSSH2PreferencePage.131"));
        gd = new GridData();
        gd.horizontalSpan = 1;
        this.keyGenerateDSA.setLayoutData((Object)gd);
        this.keyGenerateRSA = new Button(group, 0);
        this.keyGenerateRSA.setText(Policy.bind("CVSSSH2PreferencePage.132"));
        gd = new GridData();
        gd.horizontalSpan = 1;
        this.keyGenerateRSA.setLayoutData((Object)gd);
        this.keyLoad = new Button(group, 0);
        this.keyLoad.setText(Policy.bind("CVSSSH2PreferencePage.128"));
        gd = new GridData();
        gd.horizontalSpan = 1;
        this.keyLoad.setLayoutData((Object)gd);
        this.publicKeylabel = new Label(group, 0);
        this.publicKeylabel.setText(Policy.bind("CVSSSH2PreferencePage.39"));
        gd = new GridData();
        gd.horizontalSpan = columnSpan;
        this.publicKeylabel.setLayoutData((Object)gd);
        this.publicKeyText = new Text(group, 2626);
        this.publicKeyText.setText(AUTH_SCHEME);
        this.publicKeyText.setEditable(false);
        gd = new GridData();
        gd.horizontalSpan = columnSpan;
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        this.publicKeyText.setLayoutData((Object)gd);
        this.keyExport = new Button(group, 0);
        this.keyExport.setText(Policy.bind("CVSSSH2PreferencePage.105"));
        gd = new GridData(128);
        gd.horizontalSpan = columnSpan;
        this.keyExport.setLayoutData((Object)gd);
        this.keyFingerPrintLabel = new Label(group, 0);
        this.keyFingerPrintLabel.setText(Policy.bind("CVSSSH2PreferencePage.41"));
        this.keyFingerPrintText = new Text(group, 2052);
        this.keyFingerPrintText.setFont(group.getFont());
        this.keyFingerPrintText.setEditable(false);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.keyFingerPrintText.setLayoutData((Object)gd);
        this.keyCommentLabel = new Label(group, 0);
        this.keyCommentLabel.setText(Policy.bind("CVSSSH2PreferencePage.42"));
        this.keyCommentText = new Text(group, 2052);
        this.keyCommentText.setFont(group.getFont());
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.keyCommentText.setLayoutData((Object)gd);
        this.keyCommentText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (CVSSSH2PreferencePage.this.kpair == null) {
                    return;
                }
                try {
                    ByteArrayOutputStream out = new ByteArrayOutputStream();
                    CVSSSH2PreferencePage.this.kpair.writePublicKey((OutputStream)out, CVSSSH2PreferencePage.this.keyCommentText.getText());
                    out.close();
                    CVSSSH2PreferencePage.this.publicKeyText.setText(out.toString());
                }
                catch (IOException iOException) {}
            }
        });
        this.keyPassphrase1Label = new Label(group, 0);
        this.keyPassphrase1Label.setText(Policy.bind("CVSSSH2PreferencePage.43"));
        this.keyPassphrase1Text = new Text(group, 2052);
        this.keyPassphrase1Text.setFont(group.getFont());
        this.keyPassphrase1Text.setEchoChar('*');
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.keyPassphrase1Text.setLayoutData((Object)gd);
        this.keyPassphrase2Label = new Label(group, 0);
        this.keyPassphrase2Label.setText(Policy.bind("CVSSSH2PreferencePage.44"));
        this.keyPassphrase2Text = new Text(group, 2052);
        this.keyPassphrase2Text.setFont(group.getFont());
        this.keyPassphrase2Text.setEchoChar('*');
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.keyPassphrase2Text.setLayoutData((Object)gd);
        this.keyPassphrase1Text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String pass1 = CVSSSH2PreferencePage.this.keyPassphrase1Text.getText();
                String pass2 = CVSSSH2PreferencePage.this.keyPassphrase2Text.getText();
                if (CVSSSH2PreferencePage.this.kpair != null && pass1.equals(pass2)) {
                    CVSSSH2PreferencePage.this.saveKeyPair.setEnabled(true);
                } else {
                    CVSSSH2PreferencePage.this.saveKeyPair.setEnabled(false);
                }
                if (pass2.length() == 0) {
                    CVSSSH2PreferencePage.this.setErrorMessage(null);
                    return;
                }
                if (pass1.equals(pass2)) {
                    CVSSSH2PreferencePage.this.setErrorMessage(null);
                } else {
                    CVSSSH2PreferencePage.this.setErrorMessage(Policy.bind("CVSSSH2PreferencePage.48"));
                }
            }
        });
        this.keyPassphrase2Text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String pass1 = CVSSSH2PreferencePage.this.keyPassphrase1Text.getText();
                String pass2 = CVSSSH2PreferencePage.this.keyPassphrase2Text.getText();
                if (CVSSSH2PreferencePage.this.kpair != null && pass1.equals(pass2)) {
                    CVSSSH2PreferencePage.this.saveKeyPair.setEnabled(true);
                } else {
                    CVSSSH2PreferencePage.this.saveKeyPair.setEnabled(false);
                }
                if (pass2.length() < pass1.length()) {
                    if (pass1.startsWith(pass2)) {
                        CVSSSH2PreferencePage.this.setErrorMessage(null);
                    } else {
                        CVSSSH2PreferencePage.this.setErrorMessage(Policy.bind("CVSSSH2PreferencePage.48"));
                    }
                    return;
                }
                if (pass1.equals(pass2)) {
                    CVSSSH2PreferencePage.this.setErrorMessage(null);
                } else {
                    CVSSSH2PreferencePage.this.setErrorMessage(Policy.bind("CVSSSH2PreferencePage.48"));
                }
            }
        });
        this.keyPassphrase2Text.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
                String pass1 = CVSSSH2PreferencePage.this.keyPassphrase1Text.getText();
                String pass2 = CVSSSH2PreferencePage.this.keyPassphrase2Text.getText();
                if (pass2.length() < pass1.length()) {
                    if (pass1.startsWith(pass2)) {
                        CVSSSH2PreferencePage.this.setErrorMessage(null);
                    } else {
                        CVSSSH2PreferencePage.this.setErrorMessage(Policy.bind("CVSSSH2PreferencePage.48"));
                    }
                    return;
                }
                if (pass1.equals(pass2)) {
                    CVSSSH2PreferencePage.this.setErrorMessage(null);
                } else {
                    CVSSSH2PreferencePage.this.setErrorMessage(Policy.bind("CVSSSH2PreferencePage.48"));
                }
            }

            public void focusLost(FocusEvent e) {
                String pass2;
                String pass1 = CVSSSH2PreferencePage.this.keyPassphrase1Text.getText();
                if (pass1.equals(pass2 = CVSSSH2PreferencePage.this.keyPassphrase2Text.getText())) {
                    CVSSSH2PreferencePage.this.setErrorMessage(null);
                } else {
                    CVSSSH2PreferencePage.this.setErrorMessage(Policy.bind("CVSSSH2PreferencePage.48"));
                }
            }
        });
        this.saveKeyPair = new Button(group, 0);
        this.saveKeyPair.setText(Policy.bind("CVSSSH2PreferencePage.45"));
        gd = new GridData(128);
        gd.horizontalSpan = columnSpan;
        this.saveKeyPair.setLayoutData((Object)gd);
        SelectionAdapter keygenadapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JSch jsch = JSchSession.getJSch();
                boolean ok = true;
                String _type = CVSSSH2PreferencePage.AUTH_SCHEME;
                try {
                    int type = 0;
                    if (e.widget == CVSSSH2PreferencePage.this.keyGenerateDSA) {
                        type = 1;
                        _type = DSA;
                    } else if (e.widget == CVSSSH2PreferencePage.this.keyGenerateRSA) {
                        type = 2;
                        _type = RSA;
                    } else {
                        return;
                    }
                    KeyPair[] _kpair = new KeyPair[1];
                    JSch _jsch = jsch;
                    int __type = type;
                    JSchException[] _e = new JSchException[1];
                    BusyIndicator.showWhile((Display)CVSSSH2PreferencePage.this.getShell().getDisplay(), (Runnable)new Runnable(this, _kpair, _jsch, __type, _e){
                        final /* synthetic */ 11 this$1;
                        private final /* synthetic */ KeyPair[] val$_kpair;
                        private final /* synthetic */ JSch val$_jsch;
                        private final /* synthetic */ int val$__type;
                        private final /* synthetic */ JSchException[] val$_e;
                        {
                            this.this$1 = var1_1;
                            this.val$_kpair = keyPairArray;
                            this.val$_jsch = jSch;
                            this.val$__type = n;
                            this.val$_e = jSchExceptionArray;
                        }

                        public void run() {
                            try {
                                this.val$_kpair[0] = KeyPair.genKeyPair((JSch)this.val$_jsch, (int)this.val$__type);
                            }
                            catch (JSchException e) {
                                this.val$_e[0] = e;
                            }
                        }
                    });
                    if (_e[0] != null) {
                        throw _e[0];
                    }
                    CVSSSH2PreferencePage.this.kpair = _kpair[0];
                    ByteArrayOutputStream out = new ByteArrayOutputStream();
                    CVSSSH2PreferencePage.this.kpairComment = String.valueOf(_type) + "-1024";
                    CVSSSH2PreferencePage.this.kpair.writePublicKey((OutputStream)out, CVSSSH2PreferencePage.this.kpairComment);
                    out.close();
                    CVSSSH2PreferencePage.this.publicKeyText.setText(out.toString());
                    CVSSSH2PreferencePage.this.keyFingerPrintText.setText(CVSSSH2PreferencePage.this.kpair.getFingerPrint());
                    CVSSSH2PreferencePage.this.keyCommentText.setText(CVSSSH2PreferencePage.this.kpairComment);
                    CVSSSH2PreferencePage.this.keyPassphrase1Text.setText(CVSSSH2PreferencePage.AUTH_SCHEME);
                    CVSSSH2PreferencePage.this.keyPassphrase2Text.setText(CVSSSH2PreferencePage.AUTH_SCHEME);
                    CVSSSH2PreferencePage.this.updateControls();
                }
                catch (IOException iOException) {
                    ok = false;
                }
                catch (JSchException jSchException) {
                    ok = false;
                }
                if (!ok) {
                    MessageDialog.openError((Shell)CVSSSH2PreferencePage.this.getShell(), (String)Policy.bind("CVSSSH2PreferencePage.error"), (String)Policy.bind("CVSSSH2PreferencePage.47"));
                }
            }
        };
        this.keyGenerateDSA.addSelectionListener((SelectionListener)keygenadapter);
        this.keyGenerateRSA.addSelectionListener((SelectionListener)keygenadapter);
        this.keyLoad.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean ok = true;
                String home = CVSSSH2PreferencePage.this.ssh2HomeText.getText();
                FileDialog fd = new FileDialog(CVSSSH2PreferencePage.this.getShell(), 4096);
                fd.setFilterPath(home);
                String o = fd.open();
                if (o == null) {
                    return;
                }
                String pkey = fd.getFileName();
                String pkeyab = new File(fd.getFilterPath(), pkey).getAbsolutePath();
                try {
                    JSch jsch = JSchSession.getJSch();
                    KeyPair _kpair = KeyPair.load((JSch)jsch, (String)pkeyab);
                    PassphrasePrompt prompt = null;
                    while (_kpair.isEncrypted()) {
                        if (prompt == null) {
                            prompt = new PassphrasePrompt(Policy.bind("CVSSSH2PreferencePage.126", pkey));
                        }
                        Display.getDefault().syncExec(prompt);
                        String passphrase = prompt.getPassphrase();
                        if (passphrase == null || _kpair.decrypt(passphrase)) break;
                        MessageDialog.openError((Shell)CVSSSH2PreferencePage.this.getShell(), (String)Policy.bind("CVSSSH2PreferencePage.error"), (String)Policy.bind("CVSSSH2PreferencePage.129", pkey));
                    }
                    if (_kpair.isEncrypted()) {
                        return;
                    }
                    CVSSSH2PreferencePage.this.kpair = _kpair;
                    String _type = CVSSSH2PreferencePage.this.kpair.getKeyType() == 1 ? DSA : RSA;
                    ByteArrayOutputStream out = new ByteArrayOutputStream();
                    CVSSSH2PreferencePage.this.kpairComment = String.valueOf(_type) + "-1024";
                    CVSSSH2PreferencePage.this.kpair.writePublicKey((OutputStream)out, CVSSSH2PreferencePage.this.kpairComment);
                    out.close();
                    CVSSSH2PreferencePage.this.publicKeyText.setText(out.toString());
                    CVSSSH2PreferencePage.this.keyFingerPrintText.setText(CVSSSH2PreferencePage.this.kpair.getFingerPrint());
                    CVSSSH2PreferencePage.this.keyCommentText.setText(CVSSSH2PreferencePage.this.kpairComment);
                    CVSSSH2PreferencePage.this.keyPassphrase1Text.setText(CVSSSH2PreferencePage.AUTH_SCHEME);
                    CVSSSH2PreferencePage.this.keyPassphrase2Text.setText(CVSSSH2PreferencePage.AUTH_SCHEME);
                    CVSSSH2PreferencePage.this.updateControls();
                }
                catch (IOException iOException) {
                    ok = false;
                }
                catch (JSchException jSchException) {
                    ok = false;
                }
                if (!ok) {
                    MessageDialog.openError((Shell)CVSSSH2PreferencePage.this.getShell(), (String)Policy.bind("CVSSSH2PreferencePage.error"), (String)Policy.bind("CVSSSH2PreferencePage.130"));
                }
            }
        });
        this.keyExport.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (CVSSSH2PreferencePage.this.kpair == null) {
                    return;
                }
                CVSSSH2PreferencePage.this.setErrorMessage(null);
                String[] target = new String[1];
                String title = Policy.bind("CVSSSH2PreferencePage.106");
                String message = Policy.bind("CVSSSH2PreferencePage.107");
                Display.getDefault().syncExec(new Runnable(this, title, message, target){
                    final /* synthetic */ 14 this$1;
                    private final /* synthetic */ String val$title;
                    private final /* synthetic */ String val$message;
                    private final /* synthetic */ String[] val$target;
                    {
                        this.this$1 = var1_1;
                        this.val$title = string;
                        this.val$message = string2;
                        this.val$target = stringArray;
                    }

                    public void run() {
                        Display display = Display.getCurrent();
                        Shell shell = new Shell(display);
                        ExportDialog dialog = new ExportDialog(shell, this.val$title, this.val$message);
                        dialog.open();
                        shell.dispose();
                        this.val$target[0] = dialog.getTarget();
                    }
                });
                if (target[0] == null) {
                    return;
                }
                String user = CVSSSH2PreferencePage.AUTH_SCHEME;
                String host = CVSSSH2PreferencePage.AUTH_SCHEME;
                int port = 22;
                if (target[0].indexOf(64) > 0) {
                    user = target[0].substring(0, target[0].indexOf(64));
                    host = target[0].substring(target[0].indexOf(64) + 1);
                }
                if (host.indexOf(58) > 0) {
                    try {
                        port = Integer.parseInt(host.substring(host.indexOf(58) + 1));
                    }
                    catch (NumberFormatException numberFormatException) {
                        port = -1;
                    }
                    host = host.substring(0, host.indexOf(58));
                }
                if (user.length() == 0 || host.length() == 0 || port == -1) {
                    CVSSSH2PreferencePage.this.setErrorMessage(Policy.bind("CVSSSH2PreferencePage.108", target[0]));
                    return;
                }
                String options = CVSSSH2PreferencePage.AUTH_SCHEME;
                try {
                    ByteArrayOutputStream bos = new ByteArrayOutputStream();
                    if (options.length() != 0) {
                        try {
                            bos.write((String.valueOf(options) + " ").getBytes());
                        }
                        catch (IOException iOException) {}
                    }
                    CVSSSH2PreferencePage.this.kpair.writePublicKey((OutputStream)bos, CVSSSH2PreferencePage.this.kpairComment);
                    bos.close();
                    CVSSSH2PreferencePage.this.export_via_sftp(user, host, port, ".ssh/authorized_keys", bos.toByteArray());
                }
                catch (IOException iOException) {
                }
                catch (JSchException jSchException) {
                    CVSSSH2PreferencePage.this.setErrorMessage(Policy.bind("CVSSSH2PreferencePage.111"));
                }
            }
        });
        this.saveKeyPair.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (CVSSSH2PreferencePage.this.kpair == null) {
                    return;
                }
                String pass = CVSSSH2PreferencePage.this.keyPassphrase1Text.getText();
                if (pass.length() == 0 && !MessageDialog.openConfirm((Shell)CVSSSH2PreferencePage.this.getShell(), (String)Policy.bind("CVSSSH2PreferencePage.confirmation"), (String)Policy.bind("CVSSSH2PreferencePage.49"))) {
                    return;
                }
                CVSSSH2PreferencePage.this.kpair.setPassphrase(pass);
                CVSSSH2Plugin.getDefault().getPreferenceStore();
                String home = CVSSSH2PreferencePage.this.ssh2HomeText.getText();
                File _home = new File(home);
                if (!_home.exists()) {
                    if (!MessageDialog.openConfirm((Shell)CVSSSH2PreferencePage.this.getShell(), (String)Policy.bind("CVSSSH2PreferencePage.confirmation"), (String)Policy.bind("CVSSSH2PreferencePage.50", home))) {
                        return;
                    }
                    if (!_home.mkdirs()) {
                        CVSSSH2PreferencePage.this.setErrorMessage(String.valueOf(Policy.bind("CVSSSH2PreferencePage.100")) + home);
                        return;
                    }
                }
                FileDialog fd = new FileDialog(CVSSSH2PreferencePage.this.getShell(), 8192);
                fd.setFilterPath(home);
                String file = CVSSSH2PreferencePage.this.kpair.getKeyType() == 2 ? "id_rsa" : "id_dsa";
                fd.setFileName(file);
                file = fd.open();
                if (file == null) {
                    return;
                }
                if (new File(file).exists() && !MessageDialog.openConfirm((Shell)CVSSSH2PreferencePage.this.getShell(), (String)Policy.bind("CVSSSH2PreferencePage.confirmation"), (String)Policy.bind("CVSSSH2PreferencePage.53", file))) {
                    return;
                }
                boolean ok = true;
                try {
                    CVSSSH2PreferencePage.this.kpair.writePrivateKey(file);
                    CVSSSH2PreferencePage.this.kpair.writePublicKey(String.valueOf(file) + ".pub", CVSSSH2PreferencePage.this.kpairComment);
                }
                catch (Exception exception) {
                    ok = false;
                }
                if (ok) {
                    MessageDialog.openInformation((Shell)CVSSSH2PreferencePage.this.getShell(), (String)Policy.bind("CVSSSH2PreferencePage.information"), (String)(String.valueOf(Policy.bind("CVSSSH2PreferencePage.55")) + "\n" + Policy.bind("CVSSSH2PreferencePage.57") + file + "\n" + Policy.bind("CVSSSH2PreferencePage.59") + file + ".pub"));
                }
            }
        });
        return group;
    }

    private void export_via_sftp(String user, String host, int port, String target, byte[] pkey) throws JSchException {
        try {
            NullProgressMonitor pm = new NullProgressMonitor();
            Session session = JSchSession.getSession(null, user, AUTH_SCHEME, host, port, new JSchSession.ResponsiveSocketFacory((IProgressMonitor)pm));
            if (session.getServerVersion().indexOf("OpenSSH") == -1) {
                this.setErrorMessage(Policy.bind("CVSSSH2PreferencePage.110"));
                return;
            }
            Channel channel = session.openChannel("sftp");
            channel.connect();
            ChannelSftp c = (ChannelSftp)channel;
            c.pwd();
            SftpATTRS attr = null;
            try {
                attr = c.stat(".ssh");
            }
            catch (SftpException sftpException) {}
            if (attr == null) {
                try {
                    c.mkdir(".ssh");
                }
                catch (SftpException ee) {
                    this.setErrorMessage(ee.message);
                    return;
                }
            }
            try {
                c.cd(".ssh");
            }
            catch (SftpException ee) {
                this.setErrorMessage(ee.message);
                return;
            }
            try {
                ByteArrayInputStream bis = new ByteArrayInputStream(pkey);
                c.put((InputStream)bis, "authorized_keys", null, 2);
                bis.close();
                this.checkPermission(c, "authorized_keys");
                this.checkPermission(c, ".");
                c.cd("..");
                this.checkPermission(c, ".");
            }
            catch (SftpException sftpException) {}
            MessageDialog.openInformation((Shell)this.getShell(), (String)Policy.bind("CVSSSH2PreferencePage.information"), (String)(String.valueOf(Policy.bind("CVSSSH2PreferencePage.109")) + user + "@" + host + (port == 22 ? AUTH_SCHEME : ":" + port) + ":~/.ssh/authorized_keys"));
            c.disconnect();
        }
        catch (IOException eee) {
            this.setErrorMessage(eee.toString());
        }
    }

    private void checkPermission(ChannelSftp c, String path) throws SftpException {
        SftpATTRS attr = c.stat(path);
        int permissions = attr.getPermissions();
        if ((permissions & 0x12) != 0) {
            c.chmod(permissions &= 0xFFFFFFED, path);
        }
    }

    private void updateControls() {
        boolean enable = this.enableProxy.getSelection();
        this.proxyTypeLabel.setEnabled(enable);
        this.proxyTypeCombo.setEnabled(enable);
        this.proxyPortLabel.setEnabled(enable);
        this.proxyPortText.setEnabled(enable);
        this.proxyHostLabel.setEnabled(enable);
        this.proxyHostText.setEnabled(enable);
        this.enableAuth.setEnabled(enable);
        this.proxyUserLabel.setEnabled(enable &= this.enableAuth.getSelection());
        this.proxyUserText.setEnabled(enable);
        this.proxyPassLabel.setEnabled(enable);
        this.proxyPassText.setEnabled(enable);
        enable = this.kpair != null;
        this.publicKeylabel.setEnabled(enable);
        this.publicKeyText.setEnabled(enable);
        this.keyFingerPrintLabel.setEnabled(enable);
        this.keyFingerPrintText.setEnabled(enable);
        this.keyCommentLabel.setEnabled(enable);
        this.keyCommentText.setEnabled(enable);
        this.keyPassphrase1Label.setEnabled(enable);
        this.keyPassphrase1Text.setEnabled(enable);
        this.keyPassphrase2Label.setEnabled(enable);
        this.keyPassphrase2Text.setEnabled(enable);
        this.keyExport.setEnabled(enable);
        this.saveKeyPair.setEnabled(enable);
    }

    public void init(IWorkbench workbench) {
    }

    public void initialize() {
        this.initControls();
    }

    public static void initDefaults(IPreferenceStore store) {
        CVSSSH2PreferencePage.setDefault(store, KEY_SSH2HOME, JSchSession.default_ssh_home);
        CVSSSH2PreferencePage.setDefault(store, KEY_PRIVATEKEY, privatekeys);
        CVSSSH2PreferencePage.setDefault(store, KEY_PROXY_TYPE, HTTP);
        CVSSSH2PreferencePage.setDefault(store, KEY_PROXY_PORT, HTTP_DEFAULT_PORT);
        CVSSSH2PreferencePage.setDefault(store, KEY_PROXY_AUTH, "false");
    }

    private static void setDefault(IPreferenceStore store, String key, String value) {
        store.setDefault(key, value);
        if (store.getString(key).length() == 0) {
            store.setValue(key, value);
        }
    }

    private void initControls() {
        IPreferenceStore store = CVSSSH2Plugin.getDefault().getPreferenceStore();
        this.ssh2HomeText.setText(store.getString(KEY_SSH2HOME));
        this.privateKeyText.setText(store.getString(KEY_PRIVATEKEY));
        this.useProxy = store.getString(KEY_PROXY).equals("true");
        this.enableProxy.setSelection(this.useProxy);
        this.proxyHostText.setText(store.getString(KEY_PROXY_HOST));
        this.proxyTypeCombo.select(store.getString(KEY_PROXY_TYPE).equals(HTTP) ? 0 : 1);
        this.proxyPortText.setText(store.getString(KEY_PROXY_PORT));
        this.useAuth = store.getString(KEY_PROXY_AUTH).equals("true");
        this.enableAuth.setSelection(this.useAuth);
        Map map = Platform.getAuthorizationInfo((URL)FAKE_URL, (String)"proxy", (String)AUTH_SCHEME);
        if (map != null) {
            String password;
            String username = (String)map.get(KEY_PROXY_USER);
            if (username != null) {
                this.proxyUserText.setText(username);
            }
            if ((password = (String)map.get(KEY_PROXY_PASS)) != null) {
                this.proxyPassText.setText(password);
            }
        }
        this.proxyPassText.setEchoChar('*');
        this.updateControls();
    }

    public boolean performOk() {
        boolean result = super.performOk();
        if (result) {
            this.setErrorMessage(null);
            String home = this.ssh2HomeText.getText();
            File _home = new File(home);
            if (!_home.exists() && MessageDialog.openQuestion((Shell)this.getShell(), (String)Policy.bind("CVSSSH2PreferencePage.question"), (String)Policy.bind("CVSSSH2PreferencePage.99", home)) && !_home.mkdirs()) {
                this.setErrorMessage(String.valueOf(Policy.bind("CVSSSH2PreferencePage.100")) + home);
                return false;
            }
            if (this.enableProxy.getSelection() && !this.isValidPort(this.proxyPortText.getText())) {
                return false;
            }
            IPreferenceStore store = CVSSSH2Plugin.getDefault().getPreferenceStore();
            store.setValue(KEY_SSH2HOME, home);
            store.setValue(KEY_PRIVATEKEY, this.privateKeyText.getText());
            store.setValue(KEY_PROXY, this.enableProxy.getSelection());
            store.setValue(KEY_PROXY_TYPE, this.proxyTypeCombo.getText());
            store.setValue(KEY_PROXY_HOST, this.proxyHostText.getText());
            store.setValue(KEY_PROXY_PORT, this.proxyPortText.getText());
            store.setValue(KEY_PROXY_AUTH, this.enableAuth.getSelection());
            HashMap<String, String> map = Platform.getAuthorizationInfo((URL)FAKE_URL, (String)"proxy", (String)AUTH_SCHEME);
            if (map == null) {
                map = new HashMap<String, String>(10);
            }
            map.put(KEY_PROXY_USER, this.proxyUserText.getText());
            map.put(KEY_PROXY_PASS, this.proxyPassText.getText());
            try {
                Platform.addAuthorizationInfo((URL)FAKE_URL, (String)"proxy", (String)AUTH_SCHEME, map);
            }
            catch (CoreException e) {
                Util.logError((String)"Cannot save ssh2 proxy authentication information to keyring file", (Throwable)e);
            }
        }
        CVSSSH2Plugin.getDefault().savePluginPreferences();
        return result;
    }

    private boolean isValidPort(String port) {
        int i = -1;
        try {
            i = Integer.parseInt(port);
        }
        catch (NumberFormatException numberFormatException) {}
        if (i < 0 || i > 65535) {
            this.setErrorMessage(Policy.bind("CVSSSH2PreferencePage.104"));
            return false;
        }
        return true;
    }

    public void performApply() {
        this.performOk();
    }

    protected void performDefaults() {
        super.performDefaults();
        this.enableProxy.setSelection(false);
        this.proxyHostText.setText(AUTH_SCHEME);
        this.proxyPortText.setText(HTTP_DEFAULT_PORT);
        this.proxyTypeCombo.select(0);
        this.enableAuth.setSelection(false);
        this.proxyUserText.setText(AUTH_SCHEME);
        this.proxyPassText.setText(AUTH_SCHEME);
        this.updateControls();
    }

    protected void createSpacer(Composite composite, int columnSpan) {
        Label label = new Label(composite, 0);
        GridData gd = new GridData();
        gd.horizontalSpan = columnSpan;
        label.setLayoutData((Object)gd);
    }
}

