/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.Callback;
import org.eclipse.swt.internal.win32.MSG;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.POINT;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TypedListener;
import org.eclipse.swt.widgets.Widget;

public class Tracker
extends Widget {
    Control parent;
    boolean tracking;
    boolean stippled;
    Rectangle[] rectangles;
    Rectangle[] proportions;
    Rectangle bounds;
    int resizeCursor;
    int clientCursor;
    int cursorOrientation = 0;
    boolean inEvent = false;
    static final int STEPSIZE_SMALL = 1;
    static final int STEPSIZE_LARGE = 9;

    public Tracker(Composite parent, int style) {
        super(parent, Tracker.checkStyle(style));
        this.parent = parent;
    }

    public Tracker(Display display, int style) {
        if (display == null) {
            display = Display.getCurrent();
        }
        if (display == null) {
            display = Display.getDefault();
        }
        if (!display.isValidThread()) {
            this.error(22);
        }
        this.style = Tracker.checkStyle(style);
        this.display = display;
    }

    public void addControlListener(ControlListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(11, typedListener);
        this.addListener(10, typedListener);
    }

    Point adjustMoveCursor() {
        int newX = this.bounds.x + this.bounds.width / 2;
        int newY = this.bounds.y;
        POINT pt = new POINT();
        pt.x = newX;
        pt.y = newY;
        if (this.parent != null) {
            OS.ClientToScreen(this.parent.handle, pt);
        }
        OS.SetCursorPos(pt.x, pt.y);
        return new Point(pt.x, pt.y);
    }

    Point adjustResizeCursor() {
        int newX = (this.cursorOrientation & 0x4000) != 0 ? this.bounds.x : ((this.cursorOrientation & 0x20000) != 0 ? this.bounds.x + this.bounds.width : this.bounds.x + this.bounds.width / 2);
        int newY = (this.cursorOrientation & 0x80) != 0 ? this.bounds.y : ((this.cursorOrientation & 0x400) != 0 ? this.bounds.y + this.bounds.height : this.bounds.y + this.bounds.height / 2);
        POINT pt = new POINT();
        pt.x = newX;
        pt.y = newY;
        if (this.parent != null) {
            OS.ClientToScreen(this.parent.handle, pt);
        }
        OS.SetCursorPos(pt.x, pt.y);
        if (this.clientCursor == 0) {
            int newCursor = 0;
            switch (this.cursorOrientation) {
                case 128: {
                    newCursor = OS.LoadCursor(0, 32645);
                    break;
                }
                case 1024: {
                    newCursor = OS.LoadCursor(0, 32645);
                    break;
                }
                case 16384: {
                    newCursor = OS.LoadCursor(0, 32644);
                    break;
                }
                case 131072: {
                    newCursor = OS.LoadCursor(0, 32644);
                    break;
                }
                case 16512: {
                    newCursor = OS.LoadCursor(0, 32642);
                    break;
                }
                case 132096: {
                    newCursor = OS.LoadCursor(0, 32642);
                    break;
                }
                case 17408: {
                    newCursor = OS.LoadCursor(0, 32643);
                    break;
                }
                case 131200: {
                    newCursor = OS.LoadCursor(0, 32643);
                    break;
                }
                default: {
                    newCursor = OS.LoadCursor(0, 32646);
                }
            }
            OS.SetCursor(newCursor);
            if (this.resizeCursor != 0) {
                OS.DestroyCursor(this.resizeCursor);
            }
            this.resizeCursor = newCursor;
        }
        return new Point(pt.x, pt.y);
    }

    static int checkStyle(int style) {
        if ((style & 0x24480) == 0) {
            style |= 0x24480;
        }
        return style;
    }

    public void close() {
        this.checkWidget();
        this.tracking = false;
    }

    Rectangle computeBounds() {
        int xMin = this.rectangles[0].x;
        int yMin = this.rectangles[0].y;
        int xMax = this.rectangles[0].x + this.rectangles[0].width;
        int yMax = this.rectangles[0].y + this.rectangles[0].height;
        int i = 1;
        while (i < this.rectangles.length) {
            int rectBottom;
            int rectRight;
            if (this.rectangles[i].x < xMin) {
                xMin = this.rectangles[i].x;
            }
            if (this.rectangles[i].y < yMin) {
                yMin = this.rectangles[i].y;
            }
            if ((rectRight = this.rectangles[i].x + this.rectangles[i].width) > xMax) {
                xMax = rectRight;
            }
            if ((rectBottom = this.rectangles[i].y + this.rectangles[i].height) > yMax) {
                yMax = rectBottom;
            }
            ++i;
        }
        return new Rectangle(xMin, yMin, xMax - xMin, yMax - yMin);
    }

    Rectangle[] computeProportions(Rectangle[] rects) {
        Rectangle[] result = new Rectangle[rects.length];
        this.bounds = this.computeBounds();
        int i = 0;
        while (i < rects.length) {
            int x = 0;
            int y = 0;
            int width = 0;
            int height = 0;
            if (this.bounds.width != 0) {
                x = (rects[i].x - this.bounds.x) * 100 / this.bounds.width;
                width = rects[i].width * 100 / this.bounds.width;
            } else {
                width = 100;
            }
            if (this.bounds.height != 0) {
                y = (rects[i].y - this.bounds.y) * 100 / this.bounds.height;
                height = rects[i].height * 100 / this.bounds.height;
            } else {
                height = 100;
            }
            result[i] = new Rectangle(x, y, width, height);
            ++i;
        }
        return result;
    }

    void drawRectangles(Rectangle[] rects, boolean stippled) {
        if (this.parent != null) {
            if (this.parent.isDisposed()) {
                return;
            }
            Shell shell = this.parent.getShell();
            shell.update(true);
        } else {
            this.display.update();
        }
        int bandWidth = 1;
        int hwndTrack = OS.GetDesktopWindow();
        if (this.parent != null) {
            hwndTrack = this.parent.handle;
        }
        int hDC = OS.GetDCEx(hwndTrack, 0, 2);
        int hBitmap = 0;
        int hBrush = 0;
        int oldBrush = 0;
        if (stippled) {
            bandWidth = 3;
            byte[] byArray = new byte[16];
            byArray[0] = -86;
            byArray[2] = 85;
            byArray[4] = -86;
            byArray[6] = 85;
            byArray[8] = -86;
            byArray[10] = 85;
            byArray[12] = -86;
            byArray[14] = 85;
            byte[] bits = byArray;
            hBitmap = OS.CreateBitmap(8, 8, 1, 1, bits);
            hBrush = OS.CreatePatternBrush(hBitmap);
            oldBrush = OS.SelectObject(hDC, hBrush);
        }
        int i = 0;
        while (i < rects.length) {
            Rectangle rect = rects[i];
            OS.PatBlt(hDC, rect.x, rect.y, rect.width, bandWidth, 5898313);
            OS.PatBlt(hDC, rect.x, rect.y + bandWidth, bandWidth, rect.height - bandWidth * 2, 5898313);
            OS.PatBlt(hDC, rect.x + rect.width - bandWidth, rect.y + bandWidth, bandWidth, rect.height - bandWidth * 2, 5898313);
            OS.PatBlt(hDC, rect.x, rect.y + rect.height - bandWidth, rect.width, bandWidth, 5898313);
            ++i;
        }
        if (stippled) {
            OS.SelectObject(hDC, oldBrush);
            OS.DeleteObject(hBrush);
            OS.DeleteObject(hBitmap);
        }
        OS.ReleaseDC(hwndTrack, hDC);
    }

    public Rectangle[] getRectangles() {
        this.checkWidget();
        int length = 0;
        if (this.rectangles != null) {
            length = this.rectangles.length;
        }
        Rectangle[] result = new Rectangle[length];
        int i = 0;
        while (i < length) {
            Rectangle current = this.rectangles[i];
            result[i] = new Rectangle(current.x, current.y, current.width, current.height);
            ++i;
        }
        return result;
    }

    public boolean getStippled() {
        this.checkWidget();
        return this.stippled;
    }

    void moveRectangles(int xChange, int yChange) {
        if (xChange < 0 && (this.style & 0x4000) == 0) {
            xChange = 0;
        }
        if (xChange > 0 && (this.style & 0x20000) == 0) {
            xChange = 0;
        }
        if (yChange < 0 && (this.style & 0x80) == 0) {
            yChange = 0;
        }
        if (yChange > 0 && (this.style & 0x400) == 0) {
            yChange = 0;
        }
        if (xChange == 0 && yChange == 0) {
            return;
        }
        this.bounds.x += xChange;
        this.bounds.y += yChange;
        int i = 0;
        while (i < this.rectangles.length) {
            this.rectangles[i].x += xChange;
            this.rectangles[i].y += yChange;
            ++i;
        }
    }

    /*
     * Unable to fully structure code
     */
    public boolean open() {
        this.checkWidget();
        if (this.rectangles == null) {
            return false;
        }
        cancelled = false;
        this.tracking = true;
        event = new Event();
        msg = new MSG();
        isMirrored = this.parent != null && (this.parent.style & 0x8000000) != 0;
        vStyle = this.style & 1152;
        if (vStyle == 128 || vStyle == 1024) {
            this.cursorOrientation |= vStyle;
        }
        if ((hStyle = this.style & 147456) == 16384 || hStyle == 131072) {
            this.cursorOrientation |= hStyle;
        }
        hwndTransparent = 0;
        newProc = null;
        v0 = mouseDown = OS.GetKeyState(1) < 0;
        if (!mouseDown) {
            width = OS.GetSystemMetrics(0);
            height = OS.GetSystemMetrics(1);
            hwndTransparent = OS.CreateWindowEx(32, this.display.windowClass, null, -1879048192, 0, 0, width, height, 0, 0, OS.GetModuleHandle(null), null);
            oldProc = OS.GetWindowLong(hwndTransparent, -4);
            windowProc = new Object(){

                public int windowProc(int hwnd, int msg, int wParam, int lParam) {
                    switch (msg) {
                        case 132: {
                            if (!Tracker.this.inEvent) break;
                            return -1;
                        }
                        case 32: {
                            if (Tracker.this.clientCursor != 0) {
                                OS.SetCursor(Tracker.this.clientCursor);
                                return 1;
                            }
                            if (Tracker.this.resizeCursor == 0) break;
                            OS.SetCursor(Tracker.this.resizeCursor);
                            return 1;
                        }
                    }
                    return OS.CallWindowProc(oldProc, hwnd, msg, wParam, lParam);
                }
            };
            newProc = new Callback(windowProc, "windowProc", 4);
            OS.SetWindowLong(hwndTransparent, -4, newProc.getAddress());
        }
        this.drawRectangles(this.rectangles, this.stippled);
        if (mouseDown) {
            pt = new POINT();
            OS.GetCursorPos(pt);
            cursorPos = new Point(pt.x, pt.y);
        } else {
            cursorPos = (this.style & 16) != 0 ? this.adjustResizeCursor() : this.adjustMoveCursor();
        }
        oldX = cursorPos.x;
        oldY = cursorPos.y;
        while (this.tracking && !cancelled) {
            if (this.parent != null && this.parent.isDisposed()) break;
            OS.GetMessage(msg, 0, 0, 0);
            message = msg.message;
            switch (message) {
                case 512: 
                case 514: {
                    newPos = OS.GetMessagePos();
                    newX = newPos & 65535;
                    newY = newPos >> 16;
                    if (newX == oldX && newY == oldY) ** GOTO lbl121
                    oldRectangles = this.rectangles;
                    oldStippled = this.stippled;
                    rectsToErase = new Rectangle[this.rectangles.length];
                    i = 0;
                    while (i < this.rectangles.length) {
                        current = this.rectangles[i];
                        rectsToErase[i] = new Rectangle(current.x, current.y, current.width, current.height);
                        ++i;
                    }
                    event.x = newX;
                    event.y = newY;
                    if ((this.style & 16) == 0) ** GOTO lbl91
                    if (isMirrored) {
                        this.resizeRectangles(oldX - newX, newY - oldY);
                    } else {
                        this.resizeRectangles(newX - oldX, newY - oldY);
                    }
                    this.inEvent = true;
                    this.sendEvent(11, event);
                    this.inEvent = false;
                    if (this.isDisposed()) {
                        cancelled = true;
                        break;
                    }
                    draw = false;
                    if (this.rectangles == oldRectangles) ** GOTO lbl83
                    length = this.rectangles.length;
                    if (length == rectsToErase.length) ** GOTO lbl75
                    draw = true;
                    ** GOTO lbl84
lbl75:
                    // 1 sources

                    i = 0;
                    while (i < length) {
                        if (this.rectangles[i].equals(rectsToErase[i])) ** GOTO lbl80
                        draw = true;
                        ** GOTO lbl84
lbl80:
                        // 1 sources

                        ++i;
                    }
                    ** GOTO lbl84
lbl83:
                    // 1 sources

                    draw = true;
lbl84:
                    // 4 sources

                    if (draw) {
                        this.drawRectangles(rectsToErase, oldStippled);
                        this.drawRectangles(this.rectangles, this.stippled);
                    }
                    cursorPos = this.adjustResizeCursor();
                    newX = cursorPos.x;
                    newY = cursorPos.y;
                    ** GOTO lbl119
lbl91:
                    // 1 sources

                    if (isMirrored) {
                        this.moveRectangles(oldX - newX, newY - oldY);
                    } else {
                        this.moveRectangles(newX - oldX, newY - oldY);
                    }
                    this.inEvent = true;
                    this.sendEvent(10, event);
                    this.inEvent = false;
                    if (this.isDisposed()) {
                        cancelled = true;
                        break;
                    }
                    draw = false;
                    if (this.rectangles == oldRectangles) ** GOTO lbl115
                    length = this.rectangles.length;
                    if (length == rectsToErase.length) ** GOTO lbl107
                    draw = true;
                    ** GOTO lbl116
lbl107:
                    // 1 sources

                    i = 0;
                    while (i < length) {
                        if (this.rectangles[i].equals(rectsToErase[i])) ** GOTO lbl112
                        draw = true;
                        ** GOTO lbl116
lbl112:
                        // 1 sources

                        ++i;
                    }
                    ** GOTO lbl116
lbl115:
                    // 1 sources

                    draw = true;
lbl116:
                    // 4 sources

                    if (draw) {
                        this.drawRectangles(rectsToErase, oldStippled);
                        this.drawRectangles(this.rectangles, this.stippled);
                    }
lbl119:
                    // 4 sources

                    oldX = newX;
                    oldY = newY;
lbl121:
                    // 2 sources

                    this.tracking = msg.message != 514;
                    break;
                }
                case 260: {
                    cancelled = true;
                    this.tracking = false;
                    break;
                }
                case 256: {
                    stepSize = OS.GetKeyState(17) < 0 ? 1 : 9;
                    xChange = 0;
                    yChange = 0;
                    switch (msg.wParam) {
                        case 27: {
                            cancelled = true;
                            this.tracking = false;
                            break;
                        }
                        case 13: {
                            this.tracking = false;
                            break;
                        }
                        case 37: {
                            xChange = isMirrored != false ? stepSize : -stepSize;
                            break;
                        }
                        case 39: {
                            xChange = isMirrored != false ? -stepSize : stepSize;
                            break;
                        }
                        case 38: {
                            yChange = -stepSize;
                            break;
                        }
                        case 40: {
                            yChange = stepSize;
                        }
                    }
                    if (xChange == 0 && yChange == 0) break;
                    oldRectangles = this.rectangles;
                    oldStippled = this.stippled;
                    rectsToErase = new Rectangle[this.rectangles.length];
                    i = 0;
                    while (i < this.rectangles.length) {
                        current = this.rectangles[i];
                        rectsToErase[i] = new Rectangle(current.x, current.y, current.width, current.height);
                        ++i;
                    }
                    event.x = oldX + xChange;
                    event.y = oldY + yChange;
                    if ((this.style & 16) == 0) ** GOTO lbl190
                    this.resizeRectangles(xChange, yChange);
                    this.inEvent = true;
                    this.sendEvent(11, event);
                    this.inEvent = false;
                    if (this.isDisposed()) {
                        cancelled = true;
                        break;
                    }
                    draw = false;
                    if (this.rectangles == oldRectangles) ** GOTO lbl184
                    length = this.rectangles.length;
                    if (length == rectsToErase.length) ** GOTO lbl176
                    draw = true;
                    ** GOTO lbl185
lbl176:
                    // 1 sources

                    i = 0;
                    while (i < length) {
                        if (this.rectangles[i].equals(rectsToErase[i])) ** GOTO lbl181
                        draw = true;
                        ** GOTO lbl185
lbl181:
                        // 1 sources

                        ++i;
                    }
                    ** GOTO lbl185
lbl184:
                    // 1 sources

                    draw = true;
lbl185:
                    // 4 sources

                    if (draw) {
                        this.drawRectangles(rectsToErase, oldStippled);
                        this.drawRectangles(this.rectangles, this.stippled);
                    }
                    cursorPos = this.adjustResizeCursor();
                    ** GOTO lbl216
lbl190:
                    // 1 sources

                    this.moveRectangles(xChange, yChange);
                    this.inEvent = true;
                    this.sendEvent(10, event);
                    this.inEvent = false;
                    if (this.isDisposed()) {
                        cancelled = true;
                        break;
                    }
                    draw = false;
                    if (this.rectangles == oldRectangles) ** GOTO lbl211
                    length = this.rectangles.length;
                    if (length == rectsToErase.length) ** GOTO lbl203
                    draw = true;
                    ** GOTO lbl212
lbl203:
                    // 1 sources

                    i = 0;
                    while (i < length) {
                        if (this.rectangles[i].equals(rectsToErase[i])) ** GOTO lbl208
                        draw = true;
                        ** GOTO lbl212
lbl208:
                        // 1 sources

                        ++i;
                    }
                    ** GOTO lbl212
lbl211:
                    // 1 sources

                    draw = true;
lbl212:
                    // 4 sources

                    if (draw) {
                        this.drawRectangles(rectsToErase, oldStippled);
                        this.drawRectangles(this.rectangles, this.stippled);
                    }
                    cursorPos = this.adjustMoveCursor();
lbl216:
                    // 2 sources

                    oldX = cursorPos.x;
                    oldY = cursorPos.y;
                }
            }
            if (256 <= message && message <= 264 || 512 <= message && message <= 525) continue;
            OS.DispatchMessage(msg);
        }
        if (mouseDown) {
            OS.ReleaseCapture();
        }
        if (!this.isDisposed()) {
            this.drawRectangles(this.rectangles, this.stippled);
        }
        if (hwndTransparent != 0) {
            OS.DestroyWindow(hwndTransparent);
        }
        if (newProc != null) {
            newProc.dispose();
        }
        if (this.resizeCursor != 0) {
            OS.DestroyCursor(this.resizeCursor);
        }
        this.tracking = false;
        return cancelled == false;
    }

    public void removeControlListener(ControlListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(11, listener);
        this.eventTable.unhook(10, listener);
    }

    void resizeRectangles(int xChange, int yChange) {
        Rectangle proportion;
        int i;
        if (xChange < 0 && (this.style & 0x4000) != 0 && (this.cursorOrientation & 0x20000) == 0) {
            this.cursorOrientation |= 0x4000;
        } else if (xChange > 0 && (this.style & 0x20000) != 0 && (this.cursorOrientation & 0x4000) == 0) {
            this.cursorOrientation |= 0x20000;
        } else if (yChange < 0 && (this.style & 0x80) != 0 && (this.cursorOrientation & 0x400) == 0) {
            this.cursorOrientation |= 0x80;
        } else if (yChange > 0 && (this.style & 0x400) != 0 && (this.cursorOrientation & 0x80) == 0) {
            this.cursorOrientation |= 0x400;
        }
        if ((this.cursorOrientation & 0x4000) != 0) {
            if (xChange > this.bounds.width) {
                if ((this.style & 0x20000) == 0) {
                    return;
                }
                this.cursorOrientation |= 0x20000;
                this.cursorOrientation &= 0xFFFFBFFF;
                this.bounds.x += this.bounds.width;
                xChange -= this.bounds.width;
                this.bounds.width = 0;
                if (this.proportions.length > 1) {
                    i = 0;
                    while (i < this.proportions.length) {
                        proportion = this.proportions[i];
                        proportion.x = 100 - proportion.x - proportion.width;
                        ++i;
                    }
                }
            }
        } else if ((this.cursorOrientation & 0x20000) != 0 && this.bounds.width < -xChange) {
            if ((this.style & 0x4000) == 0) {
                return;
            }
            this.cursorOrientation |= 0x4000;
            this.cursorOrientation &= 0xFFFDFFFF;
            xChange += this.bounds.width;
            this.bounds.width = 0;
            if (this.proportions.length > 1) {
                i = 0;
                while (i < this.proportions.length) {
                    proportion = this.proportions[i];
                    proportion.x = 100 - proportion.x - proportion.width;
                    ++i;
                }
            }
        }
        if ((this.cursorOrientation & 0x80) != 0) {
            if (yChange > this.bounds.height) {
                if ((this.style & 0x400) == 0) {
                    return;
                }
                this.cursorOrientation |= 0x400;
                this.cursorOrientation &= 0xFFFFFF7F;
                this.bounds.y += this.bounds.height;
                yChange -= this.bounds.height;
                this.bounds.height = 0;
                if (this.proportions.length > 1) {
                    i = 0;
                    while (i < this.proportions.length) {
                        proportion = this.proportions[i];
                        proportion.y = 100 - proportion.y - proportion.height;
                        ++i;
                    }
                }
            }
        } else if ((this.cursorOrientation & 0x400) != 0 && this.bounds.height < -yChange) {
            if ((this.style & 0x80) == 0) {
                return;
            }
            this.cursorOrientation |= 0x80;
            this.cursorOrientation &= 0xFFFFFBFF;
            yChange += this.bounds.height;
            this.bounds.height = 0;
            if (this.proportions.length > 1) {
                i = 0;
                while (i < this.proportions.length) {
                    proportion = this.proportions[i];
                    proportion.y = 100 - proportion.y - proportion.height;
                    ++i;
                }
            }
        }
        if ((this.cursorOrientation & 0x4000) != 0) {
            this.bounds.x += xChange;
            this.bounds.width -= xChange;
        } else if ((this.cursorOrientation & 0x20000) != 0) {
            this.bounds.width += xChange;
        }
        if ((this.cursorOrientation & 0x80) != 0) {
            this.bounds.y += yChange;
            this.bounds.height -= yChange;
        } else if ((this.cursorOrientation & 0x400) != 0) {
            this.bounds.height += yChange;
        }
        Rectangle[] newRects = new Rectangle[this.rectangles.length];
        int i2 = 0;
        while (i2 < this.rectangles.length) {
            Rectangle proportion2 = this.proportions[i2];
            newRects[i2] = new Rectangle(proportion2.x * this.bounds.width / 100 + this.bounds.x, proportion2.y * this.bounds.height / 100 + this.bounds.y, proportion2.width * this.bounds.width / 100, proportion2.height * this.bounds.height / 100);
            ++i2;
        }
        this.rectangles = newRects;
    }

    public void setCursor(Cursor newCursor) {
        this.checkWidget();
        this.clientCursor = 0;
        if (newCursor != null) {
            this.clientCursor = newCursor.handle;
            if (this.inEvent) {
                OS.SetCursor(this.clientCursor);
            }
        }
    }

    public void setRectangles(Rectangle[] rectangles) {
        this.checkWidget();
        if (rectangles == null) {
            this.error(4);
        }
        int length = rectangles.length;
        this.rectangles = new Rectangle[length];
        int i = 0;
        while (i < length) {
            Rectangle current = rectangles[i];
            if (current == null) {
                this.error(4);
            }
            this.rectangles[i] = new Rectangle(current.x, current.y, current.width, current.height);
            ++i;
        }
        this.proportions = this.computeProportions(rectangles);
    }

    public void setStippled(boolean stippled) {
        this.checkWidget();
        this.stippled = stippled;
    }
}

