/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.search2.internal.ui.text;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.filebuffers.IFileBuffer;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.IAnnotationModelExtension;
import org.eclipse.search.internal.ui.SearchPlugin;
import org.eclipse.search.ui.text.ISearchEditorAccess;
import org.eclipse.search.ui.text.Match;
import org.eclipse.search2.internal.ui.InternalSearchUI;
import org.eclipse.search2.internal.ui.SearchMessages;
import org.eclipse.search2.internal.ui.text.Highlighter;
import org.eclipse.search2.internal.ui.text.PositionTracker;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.texteditor.AnnotationTypeLookup;

public class EditorAccessHighlighter
extends Highlighter {
    private ISearchEditorAccess fEditorAcess;
    private Map fMatchesToAnnotations;
    private AnnotationTypeLookup fAnnotationTypeLookup = EditorsUI.getAnnotationTypeLookup();

    public EditorAccessHighlighter(ISearchEditorAccess editorAccess) {
        this.fEditorAcess = editorAccess;
        this.fMatchesToAnnotations = new HashMap();
    }

    public void addHighlights(Match[] matches) {
        HashMap mapsByAnnotationModel = new HashMap();
        int i = 0;
        while (i < matches.length) {
            int offset = matches[i].getOffset();
            int length = matches[i].getLength();
            if (offset >= 0 && length >= 0) {
                try {
                    Map map;
                    Position position = this.createPosition(matches[i]);
                    if (position != null && (map = this.getMap(mapsByAnnotationModel, matches[i])) != null) {
                        Annotation annotation = new Annotation(this.fAnnotationTypeLookup.getAnnotationType("org.eclipse.search.searchmarker", 0), true, null);
                        this.fMatchesToAnnotations.put(matches[i], annotation);
                        map.put(annotation, position);
                    }
                }
                catch (BadLocationException e) {
                    SearchPlugin.log((IStatus)new Status(4, SearchPlugin.getID(), 0, SearchMessages.getString("EditorAccessHighlighter.error.badLocation"), (Throwable)e));
                }
            }
            ++i;
        }
        Iterator maps = mapsByAnnotationModel.keySet().iterator();
        while (maps.hasNext()) {
            IAnnotationModel model = (IAnnotationModel)maps.next();
            Map positionMap = (Map)mapsByAnnotationModel.get(model);
            this.addAnnotations(model, positionMap);
        }
    }

    private Position createPosition(Match match) throws BadLocationException {
        Position position = InternalSearchUI.getInstance().getPositionTracker().getCurrentPosition(match);
        position = position == null ? new Position(match.getOffset(), match.getLength()) : new Position(position.getOffset(), position.getLength());
        if (match.getBaseUnit() == 1) {
            IDocument doc = this.fEditorAcess.getDocument(match);
            if (doc != null) {
                position = PositionTracker.convertToCharacterPosition(position, doc);
            } else {
                SearchPlugin.log((IStatus)new Status(4, SearchPlugin.getID(), 0, SearchMessages.getString("AnnotationHighlighter.error.noDocument"), null));
                return null;
            }
        }
        return position;
    }

    private Map getMap(Map mapsByAnnotationModel, Match match) {
        IAnnotationModel model = this.fEditorAcess.getAnnotationModel(match);
        if (model == null) {
            return null;
        }
        HashMap map = (HashMap)mapsByAnnotationModel.get(model);
        if (map == null) {
            map = new HashMap();
            mapsByAnnotationModel.put(model, map);
        }
        return map;
    }

    private Set getSet(Map setsByAnnotationModel, Match match) {
        IAnnotationModel model = this.fEditorAcess.getAnnotationModel(match);
        if (model == null) {
            return null;
        }
        HashSet set = (HashSet)setsByAnnotationModel.get(model);
        if (set == null) {
            set = new HashSet();
            setsByAnnotationModel.put(model, set);
        }
        return set;
    }

    public void removeHighlights(Match[] matches) {
        HashMap setsByAnnotationModel = new HashMap();
        int i = 0;
        while (i < matches.length) {
            Set annotations;
            Annotation annotation = (Annotation)this.fMatchesToAnnotations.remove(matches[i]);
            if (annotation != null && (annotations = this.getSet(setsByAnnotationModel, matches[i])) != null) {
                annotations.add(annotation);
            }
            ++i;
        }
        Iterator maps = setsByAnnotationModel.keySet().iterator();
        while (maps.hasNext()) {
            IAnnotationModel model = (IAnnotationModel)maps.next();
            Set set = (Set)setsByAnnotationModel.get(model);
            this.removeAnnotations(model, set);
        }
    }

    private void addAnnotations(IAnnotationModel model, Map annotationToPositionMap) {
        if (model instanceof IAnnotationModelExtension) {
            IAnnotationModelExtension ame = (IAnnotationModelExtension)model;
            ame.replaceAnnotations(new Annotation[0], annotationToPositionMap);
        } else {
            Iterator elements = annotationToPositionMap.keySet().iterator();
            while (elements.hasNext()) {
                Annotation element = (Annotation)elements.next();
                Position p = (Position)annotationToPositionMap.get(element);
                model.addAnnotation(element, p);
            }
        }
    }

    private void removeAnnotations(IAnnotationModel model, Set annotations) {
        if (model instanceof IAnnotationModelExtension) {
            IAnnotationModelExtension ame = (IAnnotationModelExtension)model;
            Annotation[] annotationArray = new Annotation[annotations.size()];
            ame.replaceAnnotations(annotations.toArray(annotationArray), Collections.EMPTY_MAP);
        } else {
            Iterator iter = annotations.iterator();
            while (iter.hasNext()) {
                Annotation element = (Annotation)iter.next();
                model.removeAnnotation(element);
            }
        }
    }

    public void removeAll() {
        Set matchSet = this.fMatchesToAnnotations.keySet();
        Match[] matches = new Match[matchSet.size()];
        this.removeHighlights(matchSet.toArray(matches));
    }

    protected void handleContentReplaced(IFileBuffer buffer) {
        if (!(buffer instanceof ITextFileBuffer)) {
            return;
        }
        Object document = null;
        ITextFileBuffer textBuffer = (ITextFileBuffer)buffer;
        Match[] matches = this.fMatchesToAnnotations.keySet().iterator();
        while (matches.hasNext()) {
            Match match = (Match)matches.next();
            document = this.fEditorAcess.getDocument(match);
            if (document != null) break;
        }
        if (document != null && document.equals(textBuffer.getDocument())) {
            matches = new Match[this.fMatchesToAnnotations.keySet().size()];
            this.fMatchesToAnnotations.keySet().toArray(matches);
            this.removeAll();
            this.addHighlights(matches);
        }
    }
}

