/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.search2.internal.ui;

import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.Assert;
import org.eclipse.search.internal.ui.SearchPlugin;
import org.eclipse.search.internal.ui.SearchPreferencePage;
import org.eclipse.search.internal.ui.util.ExceptionHandler;
import org.eclipse.search.ui.IQueryListener;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.ISearchResultViewPart;
import org.eclipse.search.ui.NewSearchUI;
import org.eclipse.search2.internal.ui.QueryManager;
import org.eclipse.search2.internal.ui.SearchMessages;
import org.eclipse.search2.internal.ui.ThrottlingProgressMonitor;
import org.eclipse.search2.internal.ui.text.PositionTracker;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.progress.IWorkbenchSiteProgressService;

public class InternalSearchUI {
    private static final int HISTORY_COUNT = 10;
    private static InternalSearchUI fgInstance;
    private HashMap fSearchJobs;
    private QueryManager fSearchResultsManager;
    private PositionTracker fPositionTracker;
    public static final Object FAMILY_SEARCH;
    static /* synthetic */ Class class$0;

    static {
        FAMILY_SEARCH = new Object();
    }

    private void searchJobStarted(SearchJobRecord record) {
        record.fIsRunning = true;
        this.getSearchManager().queryStarting(record.fQuery);
    }

    private void searchJobFinished(SearchJobRecord record) {
        record.fIsRunning = false;
        this.getSearchManager().queryFinished(record.fQuery);
    }

    public InternalSearchUI() {
        fgInstance = this;
        this.fSearchJobs = new HashMap();
        this.fSearchResultsManager = new QueryManager();
        this.fPositionTracker = new PositionTracker();
        URL iconURL = SearchPlugin.getDefault().getBundle().getEntry("icons/full/eview16/searchres.gif");
        ImageDescriptor image = ImageDescriptor.createFromURL((URL)iconURL);
        PlatformUI.getWorkbench().getProgressService().registerIconForFamily(image, FAMILY_SEARCH);
    }

    public static InternalSearchUI getInstance() {
        if (fgInstance == null) {
            fgInstance = new InternalSearchUI();
        }
        return fgInstance;
    }

    public ISearchResultViewPart getSearchView() {
        return (ISearchResultViewPart)SearchPlugin.getActivePage().findView("org.eclipse.search.ui.views.SearchView");
    }

    public boolean runSearchInBackground(ISearchQuery query) {
        Assert.isTrue((this.fSearchJobs.get(query) == null ? 1 : 0) != 0);
        this.addQuery(query);
        if (this.isQueryRunning(query)) {
            return false;
        }
        SearchJobRecord sjr = new SearchJobRecord(query, true);
        this.fSearchJobs.put(query, sjr);
        this.doRunSearchInBackground(sjr);
        return true;
    }

    public boolean isQueryRunning(ISearchQuery query) {
        SearchJobRecord sjr = (SearchJobRecord)this.fSearchJobs.get(query);
        return sjr != null && sjr.fIsRunning;
    }

    public IStatus runSearchInForeground(IRunnableContext context, ISearchQuery query) {
        Assert.isTrue((this.fSearchJobs.get(query) == null ? 1 : 0) != 0);
        this.addQuery(query);
        SearchJobRecord sjr = new SearchJobRecord(query, false);
        this.fSearchJobs.put(query, sjr);
        return this.doRunSearchInForeground(sjr, context);
    }

    private void doRunSearchInBackground(SearchJobRecord jobRecord) {
        if (jobRecord.fJob == null) {
            jobRecord.fJob = new InternalSearchJob(jobRecord);
            jobRecord.fJob.setPriority(40);
        }
        jobRecord.fJob.setUser(true);
        IWorkbenchSiteProgressService service = this.getProgressService();
        if (service != null) {
            service.schedule(jobRecord.fJob, 0L, true);
        } else {
            jobRecord.fJob.schedule();
        }
    }

    public IWorkbenchSiteProgressService getProgressService() {
        IWorkbenchPartSite site;
        ISearchResultViewPart view = this.getSearchView();
        if (view != null && (site = view.getSite()) != null) {
            IWorkbenchPartSite iWorkbenchPartSite = view.getSite();
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.ui.progress.IWorkbenchSiteProgressService");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            return (IWorkbenchSiteProgressService)iWorkbenchPartSite.getAdapter((Class)clazz);
        }
        return null;
    }

    public boolean runAgain(ISearchQuery job) {
        SearchJobRecord rec = (SearchJobRecord)this.fSearchJobs.get(job);
        if (rec == null) {
            return false;
        }
        if (rec.fBackground) {
            this.doRunSearchInBackground(rec);
        } else {
            ProgressMonitorDialog pmd = new ProgressMonitorDialog(this.getSearchView().getSite().getShell());
            this.doRunSearchInForeground(rec, (IRunnableContext)pmd);
        }
        return true;
    }

    private IStatus doRunSearchInForeground(final SearchJobRecord rec, IRunnableContext context) {
        final IStatus[] temp = new IStatus[1];
        if (context == null) {
            context = this.getContext();
        }
        try {
            context.run(true, true, new IRunnableWithProgress(){

                /*
                 * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                public void run(IProgressMonitor monitor) {
                    InternalSearchUI.this.searchJobStarted(rec);
                    try {
                        temp[0] = rec.fQuery.run(monitor);
                    }
                    catch (Throwable throwable) {
                        Object var2_3 = null;
                        InternalSearchUI.this.searchJobFinished(rec);
                        throw throwable;
                    }
                    {
                        Object var2_4 = null;
                    }
                    InternalSearchUI.this.searchJobFinished(rec);
                }
            });
        }
        catch (InvocationTargetException e) {
            temp[0] = new Status(4, SearchPlugin.getID(), 0, SearchMessages.getString("InternalSearchUI.error.unexpected"), e.getTargetException());
        }
        catch (InterruptedException interruptedException) {
            temp[0] = Status.OK_STATUS;
        }
        return temp[0];
    }

    private IRunnableContext getContext() {
        return new ProgressMonitorDialog(null);
    }

    public static void shutdown() {
        InternalSearchUI instance = fgInstance;
        if (instance != null) {
            instance.doShutdown();
        }
    }

    private void doShutdown() {
        Iterator jobRecs = this.fSearchJobs.values().iterator();
        while (jobRecs.hasNext()) {
            SearchJobRecord element = (SearchJobRecord)jobRecs.next();
            if (element.fJob == null) continue;
            element.fJob.cancel();
        }
        this.fPositionTracker.dispose();
    }

    public void cancelSearch(ISearchQuery job) {
        SearchJobRecord rec = (SearchJobRecord)this.fSearchJobs.get(job);
        if (rec != null && rec.fJob != null) {
            rec.fJob.cancel();
        }
    }

    public ISearchResultViewPart activateSearchView() {
        String defaultPerspectiveId = NewSearchUI.getDefaultPerspectiveId();
        if (defaultPerspectiveId != null) {
            IWorkbenchWindow window = SearchPlugin.getActiveWorkbenchWindow();
            if (window != null && window.getShell() != null && !window.getShell().isDisposed()) {
                try {
                    PlatformUI.getWorkbench().showPerspective(defaultPerspectiveId, window);
                }
                catch (WorkbenchException workbenchException) {}
            }
        }
        try {
            ISearchResultViewPart viewPart = (ISearchResultViewPart)SearchPlugin.getActivePage().findView("org.eclipse.search.ui.views.SearchView");
            if (viewPart == null || SearchPreferencePage.isViewBroughtToFront()) {
                viewPart = (ISearchResultViewPart)SearchPlugin.getActivePage().showView("org.eclipse.search.ui.views.SearchView", null, 1);
            }
            return viewPart;
        }
        catch (PartInitException ex) {
            ExceptionHandler.handle((CoreException)((Object)ex), SearchMessages.getString("Search.Error.openResultView.title"), SearchMessages.getString("Search.Error.openResultView.message"));
            return null;
        }
    }

    public QueryManager getSearchManager() {
        return this.fSearchResultsManager;
    }

    public PositionTracker getPositionTracker() {
        return this.fPositionTracker;
    }

    public void addQueryListener(IQueryListener l) {
        this.getSearchManager().addQueryListener(l);
    }

    public ISearchQuery[] getQueries() {
        return this.getSearchManager().getQueries();
    }

    public void removeQueryListener(IQueryListener l) {
        this.getSearchManager().removeQueryListener(l);
    }

    public void removeQuery(ISearchQuery query) {
        this.cancelSearch(query);
        this.getSearchManager().removeQuery(query);
        this.fSearchJobs.remove(query);
    }

    public void addQuery(ISearchQuery query) {
        while (this.getSearchManager().getQueries().length >= 10) {
            this.removeQuery(this.getSearchManager().getOldestQuery());
        }
        this.getSearchManager().addQuery(query);
    }

    public void removeAllQueries() {
        Iterator queries = this.fSearchJobs.keySet().iterator();
        while (queries.hasNext()) {
            ISearchQuery query = (ISearchQuery)queries.next();
            this.cancelSearch(query);
        }
        this.fSearchJobs.clear();
        this.getSearchManager().removeAll();
    }

    private class SearchJobRecord {
        public ISearchQuery fQuery;
        public Job fJob;
        public boolean fBackground;
        public boolean fIsRunning;

        SearchJobRecord(ISearchQuery job, boolean bg) {
            this.fQuery = job;
            this.fBackground = bg;
            this.fIsRunning = false;
        }
    }

    private class InternalSearchJob
    extends Job {
        SearchJobRecord fSearchJobRecord;

        public InternalSearchJob(SearchJobRecord sjr) {
            super(sjr.fQuery.getLabel());
            this.fSearchJobRecord = sjr;
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        protected IStatus run(IProgressMonitor monitor) {
            ThrottlingProgressMonitor realMonitor = new ThrottlingProgressMonitor(monitor, 0.5f);
            this.fSearchJobRecord.fJob = this;
            InternalSearchUI.this.searchJobStarted(this.fSearchJobRecord);
            IStatus status = null;
            try {
                status = this.fSearchJobRecord.fQuery.run((IProgressMonitor)realMonitor);
            }
            catch (Throwable throwable) {
                Object var4_5 = null;
                InternalSearchUI.this.searchJobFinished(this.fSearchJobRecord);
                throw throwable;
            }
            {
                Object var4_6 = null;
            }
            InternalSearchUI.this.searchJobFinished(this.fSearchJobRecord);
            this.fSearchJobRecord.fJob = null;
            return status;
        }

        public boolean belongsTo(Object family) {
            return family == FAMILY_SEARCH;
        }
    }
}

