/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.wizards.templates;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.pde.core.plugin.IPluginBase;
import org.eclipse.pde.core.plugin.IPluginElement;
import org.eclipse.pde.core.plugin.IPluginExtension;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.IPluginModelFactory;
import org.eclipse.pde.core.plugin.IPluginObject;
import org.eclipse.pde.core.plugin.IPluginReference;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.wizards.templates.BaseEditorTemplate;
import org.eclipse.pde.internal.ui.wizards.templates.PluginReference;
import org.eclipse.pde.ui.IFieldData;
import org.eclipse.pde.ui.templates.TemplateOption;

public class EditorTemplate
extends BaseEditorTemplate {
    public static final String EDITOR_CLASS_NAME = "editorClass";
    public static final String EDITOR_NAME = "editorName";
    public static final String EXTENSIONS = "extensions";
    private static final String KEY_TITLE = "EditorTemplate.title";
    private static final String KEY_DESC = "EditorTemplate.desc";
    private static final String KEY_PACKAGE_LABEL = "EditorTemplate.packageName";
    private static final String KEY_CLASS_LABEL = "EditorTemplate.editorClass";
    private static final String KEY_EDITOR_LABEL = "EditorTemplate.editorName";
    private static final String KEY_EXTENSION_LABEL = "EditorTemplate.fileExtension";
    private static final String KEY_DEFAULT_EDITOR_NAME = "EditorTemplate.defaultEditorName";

    public EditorTemplate() {
        this.setPageCount(1);
        this.createOptions();
    }

    public IPluginReference[] getDependencies(String schemaVersion) {
        if (schemaVersion != null) {
            IPluginReference[] dep = new IPluginReference[]{new PluginReference("org.eclipse.core.runtime", null, 0), new PluginReference("org.eclipse.ui", null, 0), new PluginReference("org.eclipse.jface.text", null, 0), new PluginReference("org.eclipse.ui.editors", null, 0), new PluginReference("org.eclipse.ui.workbench.texteditor", null, 0)};
            return dep;
        }
        return super.getDependencies(schemaVersion);
    }

    public void addPages(Wizard wizard) {
        WizardPage page = this.createPage(0, "org.eclipse.pde.doc.user.template_editor");
        page.setTitle(PDEPlugin.getResourceString(KEY_TITLE));
        page.setDescription(PDEPlugin.getResourceString(KEY_DESC));
        wizard.addPage((IWizardPage)page);
        this.markPagesAdded();
    }

    private void createOptions() {
        this.addOption("packageName", PDEPlugin.getResourceString(KEY_PACKAGE_LABEL), null, 0);
        this.addOption(EDITOR_CLASS_NAME, PDEPlugin.getResourceString(KEY_CLASS_LABEL), "XMLEditor", 0);
        this.addOption(EDITOR_NAME, PDEPlugin.getResourceString(KEY_EDITOR_LABEL), PDEPlugin.getResourceString(KEY_DEFAULT_EDITOR_NAME), 0);
        this.addOption(EXTENSIONS, PDEPlugin.getResourceString(KEY_EXTENSION_LABEL), "xml", 0);
    }

    public String getSectionId() {
        return "editor";
    }

    public int getNumberOfWorkUnits() {
        return super.getNumberOfWorkUnits() + 1;
    }

    protected void initializeFields(IFieldData data) {
        String id = data.getId();
        this.initializeOption("packageName", String.valueOf(id) + ".editors");
    }

    public void initializeFields(IPluginModelBase model) {
        String pluginId = model.getPluginBase().getId();
        this.initializeOption("packageName", String.valueOf(pluginId) + ".editors");
    }

    public boolean isDependentOnParentWizard() {
        return true;
    }

    public void validateOptions(TemplateOption source) {
        if (source.isRequired() && source.isEmpty()) {
            this.flagMissingRequiredOption(source);
        } else {
            this.validateContainerPage(source);
        }
    }

    private void validateContainerPage(TemplateOption source) {
        TemplateOption[] options = this.getOptions(0);
        int i = 0;
        while (i < options.length) {
            TemplateOption nextOption = options[i];
            if (nextOption.isRequired() && nextOption.isEmpty()) {
                this.flagMissingRequiredOption(nextOption);
                return;
            }
            ++i;
        }
        this.resetPageState();
    }

    protected void updateModel(IProgressMonitor monitor) throws CoreException {
        IPluginBase plugin = this.model.getPluginBase();
        IPluginExtension extension = this.createExtension(this.getUsedExtensionPoint(), true);
        IPluginModelFactory factory = this.model.getPluginFactory();
        IPluginElement editorElement = factory.createElement((IPluginObject)extension);
        editorElement.setName("editor");
        editorElement.setAttribute("id", String.valueOf(this.getStringOption("packageName")) + "." + this.getStringOption(EDITOR_CLASS_NAME));
        editorElement.setAttribute("name", this.getStringOption(EDITOR_NAME));
        editorElement.setAttribute("icon", "icons/sample.gif");
        editorElement.setAttribute(EXTENSIONS, this.getStringOption(EXTENSIONS));
        editorElement.setAttribute("class", String.valueOf(this.getStringOption("packageName")) + "." + this.getStringOption(EDITOR_CLASS_NAME));
        editorElement.setAttribute("contributorClass", "org.eclipse.ui.texteditor.BasicTextEditorActionContributor");
        extension.add((IPluginObject)editorElement);
        if (!extension.isInTheModel()) {
            plugin.add(extension);
        }
    }
}

