/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.wizards.feature;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.ifeature.IFeatureModel;
import org.eclipse.pde.internal.core.ifeature.IFeaturePlugin;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.elements.DefaultContentProvider;
import org.eclipse.pde.internal.ui.wizards.IProjectProvider;
import org.eclipse.pde.internal.ui.wizards.ListUtil;
import org.eclipse.pde.internal.ui.wizards.feature.BasePluginListPage;
import org.eclipse.pde.internal.ui.wizards.feature.NewFeaturePatchWizard;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.help.WorkbenchHelp;

public class PatchPluginListPage
extends BasePluginListPage {
    public static final String PAGE_TITLE = "PatchPlugins.title";
    public static final String PAGE_DESC = "PatchPlugins.desc";
    private IProjectProvider provider;
    private CheckboxTableViewer pluginViewer;

    public PatchPluginListPage(IProjectProvider provider) {
        super("patchPluginList");
        this.provider = provider;
        this.setTitle(PDEPlugin.getResourceString(PAGE_TITLE));
        this.setDescription(PDEPlugin.getResourceString(PAGE_DESC));
    }

    public PatchPluginListPage() {
        super("patchPluginListPage");
        this.setTitle(PDEPlugin.getResourceString(PAGE_TITLE));
        this.setDescription(PDEPlugin.getResourceString(PAGE_DESC));
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.verticalSpacing = 9;
        container.setLayout((Layout)layout);
        this.tablePart.createControl(container);
        this.pluginViewer = this.tablePart.getTableViewer();
        this.pluginViewer.setContentProvider((IContentProvider)new PluginContentProvider());
        this.pluginViewer.setLabelProvider((IBaseLabelProvider)PDEPlugin.getDefault().getLabelProvider());
        this.pluginViewer.setSorter(ListUtil.PLUGIN_SORTER);
        GridData gd = (GridData)this.tablePart.getControl().getLayoutData();
        gd.heightHint = 250;
        this.pluginViewer.setInput((Object)PDECore.getDefault().getWorkspaceModelManager());
        this.tablePart.setSelection(new Object[0]);
        this.setControl((Control)container);
        Dialog.applyDialogFont((Control)container);
        WorkbenchHelp.setHelp((Control)container, (String)"org.eclipse.pde.doc.user.new_patch_referenced_plugins");
    }

    private Object[] getPluginModels() {
        IFeatureModel featureModel = ((NewFeaturePatchWizard.FeaturePatchProvider)this.provider).getFeatureToPatch();
        if (featureModel == null) {
            return new Object[0];
        }
        return featureModel.getFeature().getPlugins();
    }

    public IFeaturePlugin[] getSelectedPlugins() {
        IFeatureModel featureModel = ((NewFeaturePatchWizard.FeaturePatchProvider)this.provider).getFeatureToPatch();
        if (featureModel == null) {
            return new IFeaturePlugin[0];
        }
        Object[] result = this.tablePart.getSelection();
        IFeaturePlugin[] plugins = new IFeaturePlugin[result.length];
        int i = 0;
        while (i < plugins.length) {
            plugins[i] = (IFeaturePlugin)result[i];
            ++i;
        }
        return plugins;
    }

    public void setVisible(boolean visible) {
        visible = true;
        if (true) {
            this.pluginViewer.refresh();
        }
        super.setVisible(visible);
    }

    class PluginContentProvider
    extends DefaultContentProvider
    implements IStructuredContentProvider {
        PluginContentProvider() {
        }

        public Object[] getElements(Object parent) {
            return PatchPluginListPage.this.getPluginModels();
        }
    }
}

