/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.text;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.editor.text.IColorManager;
import org.eclipse.pde.internal.ui.editor.text.IPDEColorConstants;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;

public class ColorManager
implements IColorManager,
IPDEColorConstants {
    private static ColorManager fColorManager;
    private Map fColorTable = new HashMap(5);
    private static int counter;

    static {
        counter = 0;
    }

    public ColorManager() {
        this.initialize();
    }

    public static ColorManager getDefault() {
        if (fColorManager == null) {
            fColorManager = new ColorManager();
        }
        ++counter;
        return fColorManager;
    }

    public static void initializeDefaults(IPreferenceStore store) {
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)"editor.color.default", (RGB)IPDEColorConstants.DEFAULT);
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)"editor.color.instr", (RGB)IPDEColorConstants.PROC_INSTR);
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)"editor.color.string", (RGB)IPDEColorConstants.STRING);
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)"editor.color.tag", (RGB)IPDEColorConstants.TAG);
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)"editor.color.xml_comment", (RGB)IPDEColorConstants.XML_COMMENT);
    }

    private void initialize() {
        IPreferenceStore pstore = PDEPlugin.getDefault().getPreferenceStore();
        this.putColor(pstore, "editor.color.default");
        this.putColor(pstore, "editor.color.instr");
        this.putColor(pstore, "editor.color.string");
        this.putColor(pstore, "editor.color.tag");
        this.putColor(pstore, "editor.color.xml_comment");
    }

    public void dispose() {
        if (--counter == 0) {
            Iterator e = this.fColorTable.values().iterator();
            while (e.hasNext()) {
                ((Color)e.next()).dispose();
            }
            fColorManager = null;
        }
    }

    private void putColor(IPreferenceStore pstore, String property) {
        RGB setting = PreferenceConverter.getColor((IPreferenceStore)pstore, (String)property);
        Color oldColor = (Color)this.fColorTable.get(property);
        if (oldColor != null) {
            if (oldColor.getRGB().equals((Object)setting)) {
                return;
            }
            oldColor.dispose();
        }
        this.fColorTable.put(property, new Color((Device)Display.getCurrent(), setting));
    }

    public void updateProperty(String property) {
        IPreferenceStore pstore = PDEPlugin.getDefault().getPreferenceStore();
        this.putColor(pstore, property);
    }

    public Color getColor(String key) {
        Color color = (Color)this.fColorTable.get(key);
        if (color == null) {
            color = Display.getCurrent().getSystemColor(24);
        }
        return color;
    }
}

