/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.plugin;

import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.pde.core.IBaseModel;
import org.eclipse.pde.core.plugin.IFragment;
import org.eclipse.pde.core.plugin.IFragmentModel;
import org.eclipse.pde.core.plugin.IPlugin;
import org.eclipse.pde.core.plugin.IPluginModel;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.builders.DependencyLoop;
import org.eclipse.pde.internal.builders.DependencyLoopFinder;
import org.eclipse.pde.internal.core.ModelEntry;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.plugin.ImportObject;
import org.eclipse.pde.internal.ui.PDELabelProvider;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEPluginImages;
import org.eclipse.pde.internal.ui.editor.PDEFormPage;
import org.eclipse.pde.internal.ui.editor.PDESection;
import org.eclipse.pde.internal.ui.editor.plugin.LoopDialog;
import org.eclipse.pde.internal.ui.search.DependencyExtentAction;
import org.eclipse.pde.internal.ui.search.FindDeclarationsAction;
import org.eclipse.pde.internal.ui.search.FindReferencesAction;
import org.eclipse.pde.internal.ui.search.UnusedDependenciesAction;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.IPartSelectionListener;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormText;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public class DependencyAnalysisSection
extends PDESection
implements IPartSelectionListener {
    private FormText formText;
    private ImportObject fSelectedDependency;

    public DependencyAnalysisSection(PDEFormPage page, Composite parent) {
        super(page, parent, 66);
        this.createClient(this.getSection(), page.getEditor().getToolkit());
    }

    public void selectionChanged(IFormPart part, ISelection selection) {
        if (selection == null || selection.isEmpty()) {
            this.fSelectedDependency = null;
        } else {
            IStructuredSelection ssel = (IStructuredSelection)selection;
            this.fSelectedDependency = (ImportObject)ssel.getFirstElement();
        }
    }

    private String getFormText() {
        boolean editable = this.getPage().getModel().isEditable();
        if (this.getPage().getModel() instanceof IPluginModel) {
            if (editable) {
                return PDEPlugin.getResourceString("DependencyAnalysisSection.plugin.editable");
            }
            return PDEPlugin.getResourceString("DependencyAnalysisSection.plugin.notEditable");
        }
        if (editable) {
            return PDEPlugin.getResourceString("DependencyAnalysisSection.fragment.editable");
        }
        return PDEPlugin.getResourceString("DependencyAnalysisSection.fragment.notEditable");
    }

    protected void createClient(Section section, FormToolkit toolkit) {
        section.setText(PDEPlugin.getResourceString("DependencyAnalysisSection.title"));
        this.formText = toolkit.createFormText((Composite)section, true);
        this.formText.setText(this.getFormText(), true, false);
        PDELabelProvider lp = PDEPlugin.getDefault().getLabelProvider();
        this.formText.setImage("loops", lp.get(PDEPluginImages.DESC_LOOP_OBJ));
        this.formText.setImage("search", lp.get(PDEPluginImages.DESC_PSEARCH_OBJ));
        this.formText.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                if (e.getHref().equals("extent")) {
                    DependencyAnalysisSection.this.doFindPlugins();
                } else if (e.getHref().equals("unused")) {
                    DependencyAnalysisSection.this.doFindUnusedDependencies();
                } else if (e.getHref().equals("loops")) {
                    DependencyAnalysisSection.this.doFindLoops();
                } else if (e.getHref().equals("references")) {
                    DependencyAnalysisSection.this.doFindReferences();
                }
            }
        });
        section.setClient((Control)this.formText);
    }

    protected void doFindLoops() {
        IBaseModel model = this.getPage().getModel();
        if (model instanceof IPluginModel) {
            IPlugin plugin = ((IPluginModel)model).getPlugin();
            DependencyLoop[] loops = DependencyLoopFinder.findLoops((IPlugin)plugin);
            if (loops.length == 0) {
                MessageDialog.openInformation((Shell)PDEPlugin.getActiveWorkbenchShell(), (String)PDEPlugin.getResourceString("DependencyAnalysisSection.loops"), (String)PDEPlugin.getResourceString("DependencyAnalysisSection.noCycles"));
            } else {
                LoopDialog dialog = new LoopDialog(PDEPlugin.getActiveWorkbenchShell(), loops);
                dialog.open();
            }
        }
    }

    protected void doFindPlugins() {
        if (this.fSelectedDependency != null) {
            new DependencyExtentAction(this.fSelectedDependency.getImport()).run();
        }
    }

    protected void doFindUnusedDependencies() {
        IBaseModel model = this.getPage().getModel();
        if (model instanceof IPluginModelBase) {
            new UnusedDependenciesAction((IPluginModelBase)model).run();
        }
    }

    private void doFindReferences() {
        IBaseModel model = this.getPage().getModel();
        if (model instanceof IPluginModel) {
            new FindReferencesAction(((IPluginModel)model).getPlugin()).run();
        } else if (model instanceof IFragmentModel) {
            IFragment fragment = ((IFragmentModel)model).getFragment();
            String id = fragment.getPluginId();
            ModelEntry entry = PDECore.getDefault().getModelManager().findEntry(id);
            if (entry != null) {
                IPluginModelBase pluginModel = entry.getActiveModel();
                new FindDeclarationsAction(pluginModel.getPluginBase()).run();
            } else {
                MessageDialog.openInformation((Shell)PDEPlugin.getActiveWorkbenchShell(), (String)PDEPlugin.getResourceString(PDEPlugin.getResourceString("DependencyAnalysisSection.references")), (String)PDEPlugin.getResourceString(PDEPlugin.getResourceString("DependencyAnalysisSection.noReferencesFound")));
            }
        }
    }
}

