/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.plugin;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.pde.core.IBaseModel;
import org.eclipse.pde.core.IModelChangedEvent;
import org.eclipse.pde.internal.ui.editor.PDEFormEditor;
import org.eclipse.pde.internal.ui.editor.SystemFileEditorInput;
import org.eclipse.pde.internal.ui.editor.context.UTF8InputContext;
import org.eclipse.pde.internal.ui.model.AbstractEditingModel;
import org.eclipse.pde.internal.ui.model.IDocumentKey;
import org.eclipse.pde.internal.ui.model.bundle.BundleModel;
import org.eclipse.pde.internal.ui.model.bundle.ManifestHeader;
import org.eclipse.text.edits.DeleteEdit;
import org.eclipse.text.edits.InsertEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IStorageEditorInput;

public class BundleInputContext
extends UTF8InputContext {
    public static final String CONTEXT_ID = "bundle-context";
    private HashMap fOperationTable = new HashMap();
    static /* synthetic */ Class class$0;

    public BundleInputContext(PDEFormEditor editor, IEditorInput input, boolean primary) {
        super(editor, input, primary);
        this.create();
    }

    protected IBaseModel createModel(IEditorInput input) throws CoreException {
        BundleModel model = null;
        if (input instanceof IStorageEditorInput) {
            boolean isReconciling = input instanceof IFileEditorInput;
            IDocument document = this.getDocumentProvider().getDocument((Object)input);
            model = new BundleModel(document, isReconciling);
            if (input instanceof IFileEditorInput) {
                IFile file = ((IFileEditorInput)input).getFile();
                model.setUnderlyingResource((IResource)file);
                model.setCharset(file.getCharset());
            } else if (input instanceof SystemFileEditorInput) {
                SystemFileEditorInput systemFileEditorInput = (SystemFileEditorInput)input;
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("java.io.File");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                File file = (File)systemFileEditorInput.getAdapter(clazz);
                model.setInstallLocation(file.getParent());
                model.setCharset(this.getDefaultCharset());
            }
            model.load();
        }
        return model;
    }

    public String getId() {
        return CONTEXT_ID;
    }

    protected void addTextEditOperation(ArrayList ops, IModelChangedEvent event) {
        Object[] objects = event.getChangedObjects();
        if (objects != null) {
            int i = 0;
            while (i < objects.length) {
                Object object = objects[i];
                if (object instanceof ManifestHeader) {
                    ManifestHeader header = (ManifestHeader)object;
                    TextEdit op = (TextEdit)this.fOperationTable.get(header);
                    if (op != null) {
                        this.fOperationTable.remove(header);
                        ops.remove(op);
                    }
                    if (header.getValue() == null || header.getValue().trim().length() == 0) {
                        this.deleteKey(header, ops);
                    } else {
                        this.modifyKey(header, ops);
                    }
                }
                ++i;
            }
        }
    }

    protected TextEdit[] getMoveOperations() {
        return new TextEdit[0];
    }

    private void insertKey(IDocumentKey key, ArrayList ops) {
        IDocument doc = this.getDocumentProvider().getDocument((Object)this.getInput());
        int offset = doc.getLength();
        int i = doc.getNumberOfLines() - 1;
        while (i >= 0) {
            try {
                if (doc.get(doc.getLineOffset(i), doc.getLineLength(i)).trim().length() > 0) break;
                offset = doc.getLineOffset(i);
            }
            catch (BadLocationException badLocationException) {}
            --i;
        }
        InsertEdit op = new InsertEdit(offset, String.valueOf(key.write()) + System.getProperty("line.separator"));
        this.fOperationTable.put(key, op);
        ops.add(op);
    }

    private void deleteKey(IDocumentKey key, ArrayList ops) {
        if (key.getOffset() > 0) {
            DeleteEdit op = new DeleteEdit(key.getOffset(), key.getLength());
            this.fOperationTable.put(key, op);
            ops.add(op);
        }
    }

    private void modifyKey(IDocumentKey key, ArrayList ops) {
        if (key.getOffset() == -1) {
            this.insertKey(key, ops);
        } else {
            ReplaceEdit op = new ReplaceEdit(key.getOffset(), key.getLength(), String.valueOf(key.write()) + System.getProperty("line.separator"));
            this.fOperationTable.put(key, op);
            ops.add(op);
        }
    }

    public void doRevert() {
        this.fEditOperations.clear();
        this.fOperationTable.clear();
        AbstractEditingModel model = (AbstractEditingModel)this.getModel();
        model.reconciled(model.getDocument());
    }
}

