/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.build;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.pde.internal.build.AbstractScriptGenerator;
import org.eclipse.pde.internal.build.AssembleScriptGenerator;
import org.eclipse.pde.internal.build.AssemblyInformation;
import org.eclipse.pde.internal.build.SourceFeatureInformation;
import org.eclipse.pde.internal.build.builder.DevClassPathHelper;
import org.eclipse.pde.internal.build.builder.FeatureBuildScriptGenerator;
import org.eclipse.pde.internal.build.builder.ModelBuildScriptGenerator;

public class BuildScriptGenerator
extends AbstractScriptGenerator {
    protected boolean generateArchive = true;
    protected boolean children = true;
    protected String[] elements;
    protected DevClassPathHelper devEntries;
    protected String[] pluginPath;
    protected boolean recursiveGeneration = true;
    private boolean generateAssembleScript = true;

    public void generate() throws CoreException {
        ArrayList plugins = new ArrayList(5);
        ArrayList features = new ArrayList(5);
        this.sortElements(features, plugins);
        this.generateModels(plugins);
        this.generateFeatures(features);
    }

    protected void sortElements(List features, List plugins) {
        int i = 0;
        while (i < this.elements.length) {
            int index = this.elements[i].indexOf(64);
            String type = this.elements[i].substring(0, index);
            String element = this.elements[i].substring(index + 1);
            if (type.equals("plugin") || type.equals("fragment")) {
                plugins.add(element);
            } else if (type.equals("feature")) {
                features.add(element);
            }
            ++i;
        }
    }

    protected void generateModels(List models) throws CoreException {
        Iterator iterator = models.iterator();
        while (iterator.hasNext()) {
            ModelBuildScriptGenerator generator = new ModelBuildScriptGenerator();
            String model = (String)iterator.next();
            generator.setModelId(model);
            generator.generate();
        }
    }

    protected void generateFeatures(List features) throws CoreException {
        Iterator i = features.iterator();
        while (i.hasNext()) {
            AssemblyInformation assemblageInformation = null;
            assemblageInformation = new AssemblyInformation();
            String featureId = (String)i.next();
            String versionId = null;
            int versionPosition = featureId.indexOf(":");
            if (versionPosition != -1) {
                versionId = featureId.substring(versionPosition + 1);
                featureId = featureId.substring(0, versionPosition);
            }
            FeatureBuildScriptGenerator generator = new FeatureBuildScriptGenerator(featureId, versionId, assemblageInformation);
            generator.setGenerateIncludedFeatures(this.recursiveGeneration);
            generator.setAnalyseChildren(this.children);
            generator.setSourceFeatureGeneration(false);
            generator.setBinaryFeatureGeneration(true);
            generator.setScriptGeneration(true);
            generator.setPluginPath(this.pluginPath);
            generator.setBuildSiteFactory(null);
            generator.setDevEntries(this.devEntries);
            generator.setSourceToGather(new SourceFeatureInformation());
            generator.setCompiledElements(generator.getCompiledElements());
            generator.setBuildingOSGi(AbstractScriptGenerator.isBuildingOSGi());
            generator.generate();
            if (!this.generateAssembleScript) continue;
            AssembleScriptGenerator assembler = new AssembleScriptGenerator(AbstractScriptGenerator.workingDirectory, assemblageInformation, featureId, null);
            assembler.generate();
        }
    }

    public void setGenerateArchive(boolean generateArchive) {
        this.generateArchive = generateArchive;
    }

    public void setChildren(boolean children) {
        this.children = children;
    }

    public void setDevEntries(String devEntries) {
        if (devEntries != null) {
            this.devEntries = new DevClassPathHelper(devEntries);
        }
    }

    public void setElements(String[] elements) {
        this.elements = elements;
    }

    public void setPluginPath(String[] pluginPath) throws CoreException {
        this.pluginPath = pluginPath;
    }

    public void setRecursiveGeneration(boolean recursiveGeneration) {
        this.recursiveGeneration = recursiveGeneration;
    }

    public void setGenerateAssembleScript(boolean generateAssembleScript) {
        this.generateAssembleScript = generateAssembleScript;
    }
}

