/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.framework.internal.core;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import org.eclipse.osgi.framework.console.CommandInterpreter;
import org.eclipse.osgi.framework.console.CommandProvider;
import org.eclipse.osgi.framework.internal.core.AbstractBundle;
import org.eclipse.osgi.framework.internal.core.BundleContextImpl;
import org.eclipse.osgi.framework.internal.core.ConsoleMsg;
import org.eclipse.osgi.framework.internal.core.OSGi;
import org.eclipse.osgi.framework.internal.core.ServiceReferenceImpl;
import org.eclipse.osgi.framework.internal.core.StartLevelManager;
import org.eclipse.osgi.framework.internal.core.Util;
import org.eclipse.osgi.framework.launcher.Launcher;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.packageadmin.ExportedPackage;
import org.osgi.service.packageadmin.PackageAdmin;
import org.osgi.service.startlevel.StartLevel;

public class FrameworkCommandProvider
implements CommandProvider {
    private OSGi osgi;
    private BundleContext context;
    private StartLevelManager slImpl;
    private String tab = "\t";
    private String newline = "\r\n";
    static /* synthetic */ Class class$0;

    public FrameworkCommandProvider(OSGi osgi) {
        this.osgi = osgi;
        this.context = osgi.getBundleContext();
        this.slImpl = osgi.framework.startLevelManager;
        Hashtable<String, Integer> props = new Hashtable<String, Integer>();
        ((Dictionary)props).put("service.ranking", new Integer(Integer.MAX_VALUE));
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.osgi.framework.console.CommandProvider");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.context.registerService(clazz.getName(), (Object)this, props);
    }

    public String getHelp() {
        StringBuffer help = new StringBuffer(1024);
        help.append(this.newline);
        help.append(ConsoleMsg.formatter.getString("CONSOLE_HELP_VALID_COMMANDS_HEADER"));
        help.append(this.newline);
        this.addHeader("CONSOLE_HELP_CONTROLLING_FRAMEWORK_HEADER", help);
        this.addCommand("launch", "CONSOLE_HELP_LAUNCH_COMMAND_DESCRIPTION", help);
        this.addCommand("shutdown", "CONSOLE_HELP_SHUTDOWN_COMMAND_DESCRIPTION", help);
        this.addCommand("close", "CONSOLE_HELP_CLOSE_COMMAND_DESCRIPTION", help);
        this.addCommand("exit", "CONSOLE_HELP_EXIT_COMMAND_DESCRIPTION", help);
        this.addCommand("gc", "CONSOLE_HELP_GC_COMMAND_DESCRIPTION", help);
        this.addCommand("init", "CONSOLE_HELP_INIT_COMMAND_DESCRIPTION", help);
        this.addCommand("setprop", "CONSOLE_HELP_KEYVALUE_ARGUMENT_DESCRIPTION", "CONSOLE_HELP_SETPROP_COMMAND_DESCRIPTION", help);
        this.addHeader("CONSOLE_HELP_CONTROLLING_BUNDLES_HEADER", help);
        this.addCommand("install", "CONSOLE_HELP_INSTALL_COMMAND_DESCRIPTION", help);
        this.addCommand("uninstall", "CONSOLE_HELP_UNINSTALL_COMMAND_DESCRIPTION", help);
        this.addCommand("start", "CONSOLE_HELP_START_COMMAND_DESCRIPTION", help);
        this.addCommand("stop", "CONSOLE_HELP_STOP_COMMAND_DESCRIPTION", help);
        this.addCommand("refresh", "CONSOLE_HELP_REFRESH_COMMAND_DESCRIPTION", help);
        this.addCommand("update", "CONSOLE_HELP_UPDATE_COMMAND_DESCRIPTION", help);
        this.addHeader("CONSOLE_HELP_DISPLAYING_STATUS_HEADER", help);
        this.addCommand("status", "CONSOLE_HELP_STATUS_COMMAND_DESCRIPTION", help);
        this.addCommand("ss", "CONSOLE_HELP_SS_COMMAND_DESCRIPTION", help);
        this.addCommand("services", "CONSOLE_HELP_FILTER_ARGUMENT_DESCRIPTION", "CONSOLE_HELP_SERVICES_COMMAND_DESCRIPTION", help);
        this.addCommand("packages", "CONSOLE_HELP_PACKAGES_ARGUMENT_DESCRIPTION", "CONSOLE_HELP_PACKAGES_COMMAND_DESCRIPTION", help);
        this.addCommand("bundles", "CONSOLE_HELP_BUNDLES_COMMAND_DESCRIPTION", help);
        this.addCommand("bundle", "CONSOLE_HELP_IDLOCATION_ARGUMENT_DESCRIPTION", "CONSOLE_HELP_BUNDLE_COMMAND_DESCRIPTION", help);
        this.addCommand("headers", "CONSOLE_HELP_IDLOCATION_ARGUMENT_DESCRIPTION", "CONSOLE_HELP_HEADERS_COMMAND_DESCRIPTION", help);
        this.addCommand("log", "CONSOLE_HELP_IDLOCATION_ARGUMENT_DESCRIPTION", "CONSOLE_HELP_LOG_COMMAND_DESCRIPTION", help);
        this.addHeader("CONSOLE_HELP_EXTRAS_HEADER", help);
        this.addCommand("exec", "CONSOLE_HELP_COMMAND_ARGUMENT_DESCRIPTION", "CONSOLE_HELP_EXEC_COMMAND_DESCRIPTION", help);
        this.addCommand("fork", "CONSOLE_HELP_COMMAND_ARGUMENT_DESCRIPTION", "CONSOLE_HELP_FORK_COMMAND_DESCRIPTION", help);
        this.addHeader("STARTLEVEL_HELP_HEADING", help);
        this.addCommand("sl", "CONSOLE_HELP_OPTIONAL_IDLOCATION_ARGUMENT_DESCRIPTION", "STARTLEVEL_HELP_SL", help);
        this.addCommand("setfwsl", "STARTLEVEL_ARGUMENT_DESCRIPTION", "STARTLEVEL_HELP_SETFWSL", help);
        this.addCommand("setbsl", "STARTLEVEL_IDLOCATION_ARGUMENT_DESCRIPTION", "STARTLEVEL_HELP_SETBSL", help);
        this.addCommand("setibsl", "STARTLEVEL_ARGUMENT_DESCRIPTION", "STARTLEVEL_HELP_SETIBSL", help);
        return help.toString();
    }

    private void addHeader(String header, StringBuffer help) {
        help.append("---");
        help.append(ConsoleMsg.formatter.getString(header));
        help.append("---");
        help.append(this.newline);
    }

    private void addCommand(String command, String description, StringBuffer help) {
        help.append(this.tab);
        help.append(command);
        help.append(" - ");
        help.append(ConsoleMsg.formatter.getString(description));
        help.append(this.newline);
    }

    private void addCommand(String command, String parameters, String description, StringBuffer help) {
        help.append(this.tab);
        help.append(command);
        help.append(" ");
        help.append(ConsoleMsg.formatter.getString(parameters));
        help.append(" - ");
        help.append(ConsoleMsg.formatter.getString(description));
        help.append(this.newline);
    }

    public void _exit(CommandInterpreter intp) throws Exception {
        intp.println();
        System.exit(0);
    }

    public void _launch(CommandInterpreter intp) throws Exception {
        this.osgi.launch();
    }

    public void _shutdown(CommandInterpreter intp) throws Exception {
        this.osgi.shutdown();
    }

    public void _sta(CommandInterpreter intp) throws Exception {
        this._start(intp);
    }

    public void _start(CommandInterpreter intp) throws Exception {
        String nextArg = intp.nextArgument();
        if (nextArg == null) {
            intp.println((Object)ConsoleMsg.formatter.getString("CONSOLE_NO_BUNDLE_SPECIFIED_ERROR"));
        }
        while (nextArg != null) {
            AbstractBundle bundle = this.getBundleFromToken(intp, nextArg, true);
            if (bundle != null) {
                bundle.start();
            }
            nextArg = intp.nextArgument();
        }
    }

    public void _sto(CommandInterpreter intp) throws Exception {
        this._stop(intp);
    }

    public void _stop(CommandInterpreter intp) throws Exception {
        String nextArg = intp.nextArgument();
        if (nextArg == null) {
            intp.println((Object)ConsoleMsg.formatter.getString("CONSOLE_NO_BUNDLE_SPECIFIED_ERROR"));
        }
        while (nextArg != null) {
            AbstractBundle bundle = this.getBundleFromToken(intp, nextArg, true);
            if (bundle != null) {
                bundle.stop();
            }
            nextArg = intp.nextArgument();
        }
    }

    public void _i(CommandInterpreter intp) throws Exception {
        this._install(intp);
    }

    public void _install(CommandInterpreter intp) throws Exception {
        String url = intp.nextArgument();
        if (url == null) {
            intp.println((Object)ConsoleMsg.formatter.getString("CONSOLE_NOTHING_TO_INSTALL_ERROR"));
        } else {
            String start;
            AbstractBundle bundle = (AbstractBundle)this.context.installBundle(url);
            intp.print((Object)ConsoleMsg.formatter.getString("CONSOLE_BUNDLE_ID_MESSAGE"));
            intp.println((Object)new Long(bundle.getBundleId()));
            String nextArg = intp.nextArgument();
            if (nextArg != null && Launcher.matchCommand((String)"start", (String)(start = nextArg.toLowerCase()), (int)1)) {
                bundle.start();
            }
        }
    }

    public void _up(CommandInterpreter intp) throws Exception {
        this._update(intp);
    }

    public void _update(CommandInterpreter intp) throws Exception {
        String token = intp.nextArgument();
        if (token == null) {
            intp.println((Object)ConsoleMsg.formatter.getString("CONSOLE_NO_BUNDLE_SPECIFIED_ERROR"));
        }
        while (token != null) {
            if ("*".equals(token)) {
                AbstractBundle[] bundles = (AbstractBundle[])this.context.getBundles();
                int size = bundles.length;
                if (size > 0) {
                    int i = 0;
                    while (i < size) {
                        AbstractBundle bundle = bundles[i];
                        if (bundle.getBundleId() != 0L) {
                            try {
                                bundle.update();
                            }
                            catch (BundleException e) {
                                intp.printStackTrace((Throwable)e);
                            }
                        }
                        ++i;
                    }
                } else {
                    intp.println((Object)ConsoleMsg.formatter.getString("CONSOLE_NO_INSTALLED_BUNDLES_ERROR"));
                }
            } else {
                AbstractBundle bundle = this.getBundleFromToken(intp, token, true);
                if (bundle != null) {
                    String source = intp.nextArgument();
                    try {
                        if (source != null) {
                            bundle.update(new URL(source).openStream());
                        }
                        bundle.update();
                    }
                    catch (BundleException e) {
                        intp.printStackTrace((Throwable)e);
                    }
                }
            }
            token = intp.nextArgument();
        }
    }

    public void _un(CommandInterpreter intp) throws Exception {
        this._uninstall(intp);
    }

    public void _uninstall(CommandInterpreter intp) throws Exception {
        String nextArg = intp.nextArgument();
        if (nextArg == null) {
            intp.println((Object)ConsoleMsg.formatter.getString("CONSOLE_NO_BUNDLE_SPECIFIED_ERROR"));
        }
        while (nextArg != null) {
            AbstractBundle bundle = this.getBundleFromToken(intp, nextArg, true);
            if (bundle != null) {
                bundle.uninstall();
            }
            nextArg = intp.nextArgument();
        }
    }

    public void _s(CommandInterpreter intp) throws Exception {
        this._status(intp);
    }

    public void _status(CommandInterpreter intp) throws Exception {
        if (this.osgi.isActive()) {
            intp.println((Object)ConsoleMsg.formatter.getString("CONSOLE_FRAMEWORK_IS_LAUNCHED_MESSAGE"));
        } else {
            intp.println((Object)ConsoleMsg.formatter.getString("CONSOLE_FRAMEWORK_IS_SHUTDOWN_MESSAGE"));
        }
        intp.println();
        AbstractBundle[] bundles = (AbstractBundle[])this.context.getBundles();
        int size = bundles.length;
        if (size == 0) {
            intp.println((Object)ConsoleMsg.formatter.getString("CONSOLE_NO_INSTALLED_BUNDLES_ERROR"));
            return;
        }
        intp.print((Object)ConsoleMsg.formatter.getString("CONSOLE_ID"));
        intp.print((Object)this.tab);
        intp.println((Object)ConsoleMsg.formatter.getString("CONSOLE_BUNDLE_LOCATION_MESSAGE"));
        intp.println((Object)ConsoleMsg.formatter.getString("CONSOLE_STATE_BUNDLE_FILE_NAME_HEADER"));
        int i = 0;
        while (i < size) {
            AbstractBundle bundle = bundles[i];
            intp.print((Object)new Long(bundle.getBundleId()));
            intp.print((Object)this.tab);
            intp.println((Object)bundle.getLocation());
            intp.print((Object)"  ");
            intp.print((Object)this.getStateName(bundle.getState()));
            intp.println((Object)bundle.bundledata);
            ++i;
        }
        ServiceReference[] services = this.context.getServiceReferences(null, null);
        if (services != null) {
            intp.println((Object)ConsoleMsg.formatter.getString("CONSOLE_REGISTERED_SERVICES_MESSAGE"));
            size = services.length;
            int i2 = 0;
            while (i2 < size) {
                intp.println((Object)services[i2]);
                ++i2;
            }
        }
    }

    public void _se(CommandInterpreter intp) throws Exception {
        this._services(intp);
    }

    public void _services(CommandInterpreter intp) throws Exception {
        int size;
        ServiceReference[] services;
        String filter = null;
        String nextArg = intp.nextArgument();
        if (nextArg != null) {
            StringBuffer buf = new StringBuffer();
            while (nextArg != null) {
                buf.append(' ');
                buf.append(nextArg);
                nextArg = intp.nextArgument();
            }
            filter = buf.toString();
        }
        if ((services = this.context.getServiceReferences(null, filter)) != null && (size = services.length) > 0) {
            int j = 0;
            while (j < size) {
                ServiceReference service = services[j];
                intp.println((Object)service);
                intp.print((Object)"  ");
                intp.print((Object)ConsoleMsg.formatter.getString("CONSOLE_REGISTERED_BY_BUNDLE_MESSAGE"));
                intp.print((Object)" ");
                intp.println((Object)service.getBundle());
                AbstractBundle[] users = (AbstractBundle[])service.getUsingBundles();
                if (users != null) {
                    intp.print((Object)"  ");
                    intp.println((Object)ConsoleMsg.formatter.getString("CONSOLE_BUNDLES_USING_SERVICE_MESSAGE"));
                    int k = 0;
                    while (k < users.length) {
                        intp.print((Object)"    ");
                        intp.println((Object)users[k]);
                        ++k;
                    }
                } else {
                    intp.print((Object)"  ");
                    intp.println((Object)ConsoleMsg.formatter.getString("CONSOLE_NO_BUNDLES_USING_SERVICE_MESSAGE"));
                }
                ++j;
            }
            return;
        }
        intp.println((Object)ConsoleMsg.formatter.getString("CONSOLE_NO_REGISTERED_SERVICES_MESSAGE"));
    }

    public void _p(CommandInterpreter intp) throws Exception {
        this._packages(intp);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void _packages(CommandInterpreter intp) throws Exception {
        ServiceReference packageAdminRef;
        AbstractBundle bundle = null;
        String token = intp.nextArgument();
        if (token != null) {
            bundle = this.getBundleFromToken(intp, token, false);
        }
        if ((packageAdminRef = this.context.getServiceReference("org.osgi.service.packageadmin.PackageAdmin")) == null) {
            intp.println((Object)ConsoleMsg.formatter.getString("CONSOLE_NO_EXPORTED_PACKAGES_NO_PACKAGE_ADMIN_MESSAGE"));
            return;
        }
        PackageAdmin packageAdmin = (PackageAdmin)this.context.getService(packageAdminRef);
        if (packageAdmin == null) return;
        try {
            ExportedPackage[] packages = null;
            if (token != null && bundle == null) {
                ExportedPackage pkg = packageAdmin.getExportedPackage(token);
                if (pkg != null) {
                    packages = new ExportedPackage[]{pkg};
                }
            } else {
                packages = packageAdmin.getExportedPackages((Bundle)bundle);
            }
            if (packages == null) {
                intp.println((Object)ConsoleMsg.formatter.getString("CONSOLE_NO_EXPORTED_PACKAGES_MESSAGE"));
            } else {
                int i = 0;
                while (i < packages.length) {
                    Bundle exporter;
                    ExportedPackage pkg = packages[i];
                    intp.print((Object)pkg);
                    boolean removalPending = pkg.isRemovalPending();
                    if (removalPending) {
                        intp.print((Object)"(");
                        intp.print((Object)ConsoleMsg.formatter.getString("CONSOLE_REMOVAL_PENDING_MESSAGE"));
                        intp.println((Object)")");
                    }
                    if ((exporter = pkg.getExportingBundle()) != null) {
                        intp.print((Object)"<");
                        intp.print((Object)exporter);
                        intp.println((Object)">");
                        Bundle[] importers = pkg.getImportingBundles();
                        int j = 0;
                        while (j < importers.length) {
                            intp.print((Object)"  ");
                            intp.print((Object)importers[j]);
                            intp.print((Object)" ");
                            intp.println((Object)ConsoleMsg.formatter.getString("CONSOLE_IMPORTS_MESSAGE"));
                            ++j;
                        }
                    } else {
                        intp.print((Object)"<");
                        intp.print((Object)ConsoleMsg.formatter.getString("CONSOLE_STALE_MESSAGE"));
                        intp.println((Object)">");
                    }
                    ++i;
                }
            }
        }
        catch (Throwable throwable) {
            Object var13_15 = null;
            this.context.ungetService(packageAdminRef);
            throw throwable;
        }
        {
            Object var13_16 = null;
            this.context.ungetService(packageAdminRef);
            return;
        }
    }

    public void _bundles(CommandInterpreter intp) throws Exception {
        AbstractBundle[] bundles = (AbstractBundle[])this.context.getBundles();
        int size = bundles.length;
        if (size == 0) {
            intp.println((Object)ConsoleMsg.formatter.getString("CONSOLE_NO_INSTALLED_BUNDLES_ERROR"));
            return;
        }
        int i = 0;
        while (i < size) {
            AbstractBundle bundle = bundles[i];
            long id = bundle.getBundleId();
            intp.println((Object)bundle);
            intp.print((Object)"  ");
            intp.print((Object)ConsoleMsg.formatter.getString("CONSOLE_ID_MESSAGE", (Object)String.valueOf(id)));
            intp.print((Object)", ");
            intp.print((Object)ConsoleMsg.formatter.getString("CONSOLE_STATUS_MESSAGE", (Object)this.getStateName(bundle.getState())));
            if (id != 0L) {
                File dataRoot = this.osgi.framework.getDataFile(bundle, "");
                String root = dataRoot == null ? null : dataRoot.getAbsolutePath();
                intp.print((Object)ConsoleMsg.formatter.getString("CONSOLE_DATA_ROOT_MESSAGE", (Object)root));
            } else {
                intp.println();
            }
            ServiceReference[] services = bundle.getRegisteredServices();
            if (services != null) {
                intp.print((Object)"  ");
                intp.println((Object)ConsoleMsg.formatter.getString("CONSOLE_REGISTERED_SERVICES_MESSAGE"));
                int j = 0;
                while (j < services.length) {
                    intp.print((Object)"    ");
                    intp.println((Object)services[j]);
                    ++j;
                }
            } else {
                intp.print((Object)"  ");
                intp.println((Object)ConsoleMsg.formatter.getString("CONSOLE_NO_REGISTERED_SERVICES_MESSAGE"));
            }
            services = bundle.getServicesInUse();
            if (services != null) {
                intp.print((Object)"  ");
                intp.println((Object)ConsoleMsg.formatter.getString("CONSOLE_SERVICES_IN_USE_MESSAGE"));
                int j = 0;
                while (j < services.length) {
                    intp.print((Object)"    ");
                    intp.println((Object)services[j]);
                    ++j;
                }
            } else {
                intp.print((Object)"  ");
                intp.println((Object)ConsoleMsg.formatter.getString("CONSOLE_NO_SERVICES_IN_USE_MESSAGE"));
            }
            ++i;
        }
    }

    public void _b(CommandInterpreter intp) throws Exception {
        this._bundle(intp);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void _bundle(CommandInterpreter intp) throws Exception {
        nextArg = intp.nextArgument();
        if (nextArg == null) {
            intp.println((Object)ConsoleMsg.formatter.getString("CONSOLE_NO_BUNDLE_SPECIFIED_ERROR"));
        }
        while (true) {
            block50: {
                block49: {
                    block51: {
                        if (nextArg == null) {
                            return;
                        }
                        bundle = this.getBundleFromToken(intp, nextArg, true);
                        if (bundle == null) break block50;
                        id = bundle.getBundleId();
                        intp.println((Object)bundle);
                        intp.print((Object)"  ");
                        intp.print((Object)ConsoleMsg.formatter.getString("CONSOLE_ID_MESSAGE", (Object)String.valueOf(id)));
                        intp.print((Object)", ");
                        intp.print((Object)ConsoleMsg.formatter.getString("CONSOLE_STATUS_MESSAGE", (Object)this.getStateName(bundle.getState())));
                        if (id != 0L) {
                            dataRoot = this.osgi.framework.getDataFile(bundle, "");
                            root = dataRoot == null ? null : dataRoot.getAbsolutePath();
                            intp.print((Object)ConsoleMsg.formatter.getString("CONSOLE_DATA_ROOT_MESSAGE", (Object)root));
                        } else {
                            intp.println();
                        }
                        services = bundle.getRegisteredServices();
                        if (services != null) {
                            intp.print((Object)"  ");
                            intp.println((Object)ConsoleMsg.formatter.getString("CONSOLE_REGISTERED_SERVICES_MESSAGE"));
                            j = 0;
                            while (j < services.length) {
                                intp.print((Object)"    ");
                                intp.println((Object)services[j]);
                                ++j;
                            }
                        } else {
                            intp.print((Object)"  ");
                            intp.println((Object)ConsoleMsg.formatter.getString("CONSOLE_NO_REGISTERED_SERVICES_MESSAGE"));
                        }
                        services = bundle.getServicesInUse();
                        if (services != null) {
                            intp.print((Object)"  ");
                            intp.println((Object)ConsoleMsg.formatter.getString("CONSOLE_SERVICES_IN_USE_MESSAGE"));
                            j = 0;
                            while (j < services.length) {
                                intp.print((Object)"    ");
                                intp.println((Object)services[j]);
                                ++j;
                            }
                        } else {
                            intp.print((Object)"  ");
                            intp.println((Object)ConsoleMsg.formatter.getString("CONSOLE_NO_SERVICES_IN_USE_MESSAGE"));
                        }
                        packageAdminRef = this.context.getServiceReference("org.osgi.service.packageadmin.PackageAdmin");
                        if (packageAdminRef == null) break block51;
                        packageAdmin = (PackageAdmin)this.context.getService(packageAdminRef);
                        if (packageAdmin == null) break block49;
                        try {
                            block53: {
                                block47: {
                                    block48: {
                                        block52: {
                                            exportedpkgs = packageAdmin.getExportedPackages(null);
                                            if (exportedpkgs != null) break block52;
                                            intp.print((Object)"  ");
                                            intp.println((Object)ConsoleMsg.formatter.getString("CONSOLE_NO_EXPORTED_PACKAGES_MESSAGE"));
                                            intp.print((Object)"  ");
                                            intp.println((Object)ConsoleMsg.formatter.getString("CONSOLE_NO_IMPORTED_PACKAGES_MESSAGE"));
                                            ** GOTO lbl-1000
                                        }
                                        title = true;
                                        i = 0;
                                        while (true) {
                                            if (i >= exportedpkgs.length) {
                                                if (title) {
                                                    intp.print((Object)"  ");
                                                    intp.println((Object)ConsoleMsg.formatter.getString("CONSOLE_NO_EXPORTED_PACKAGES_MESSAGE"));
                                                }
                                                break;
                                            }
                                            exportedpkg = exportedpkgs[i];
                                            if (exportedpkg.getExportingBundle() == bundle) {
                                                if (title) {
                                                    intp.print((Object)"  ");
                                                    intp.println((Object)ConsoleMsg.formatter.getString("CONSOLE_EXPORTED_PACKAGES_MESSAGE"));
                                                    title = false;
                                                }
                                                intp.print((Object)"    ");
                                                intp.print((Object)exportedpkg);
                                                if (exportedpkg.isRemovalPending()) {
                                                    intp.println((Object)ConsoleMsg.formatter.getString("CONSOLE_EXPORTED_REMOVAL_PENDING_MESSAGE"));
                                                } else {
                                                    intp.println((Object)ConsoleMsg.formatter.getString("CONSOLE_EXPORTED_MESSAGE"));
                                                }
                                            }
                                            ++i;
                                        }
                                        title = true;
                                        i = 0;
                                        while (true) {
                                            if (i >= exportedpkgs.length) {
                                                if (title) {
                                                    intp.print((Object)"  ");
                                                    intp.println((Object)ConsoleMsg.formatter.getString("CONSOLE_NO_IMPORTED_PACKAGES_MESSAGE"));
                                                }
                                                intp.print((Object)"  ");
                                                if ((packageAdmin.getBundleType((Bundle)bundle) & 1) <= 0) break block47;
                                                hosts = packageAdmin.getHosts((Bundle)bundle);
                                                if (hosts != null) {
                                                    intp.println((Object)ConsoleMsg.formatter.getString("CONSOLE_HOST_MESSAGE"));
                                                    i = 0;
                                                    break;
                                                }
                                                break block48;
                                            }
                                            exportedpkg = exportedpkgs[i];
                                            importers = exportedpkg.getImportingBundles();
                                            j = 0;
                                            while (j < importers.length) {
                                                if (importers[j] == bundle) {
                                                    if (title) {
                                                        intp.print((Object)"  ");
                                                        intp.println((Object)ConsoleMsg.formatter.getString("CONSOLE_IMPORTED_PACKAGES_MESSAGE"));
                                                        title = false;
                                                    }
                                                    intp.print((Object)"    ");
                                                    intp.print((Object)exportedpkg);
                                                    exporter = exportedpkg.getExportingBundle();
                                                    if (exporter != null) {
                                                        intp.print((Object)"<");
                                                        intp.print((Object)exporter);
                                                        intp.println((Object)">");
                                                        break;
                                                    }
                                                    intp.print((Object)"<");
                                                    intp.print((Object)ConsoleMsg.formatter.getString("CONSOLE_STALE_MESSAGE"));
                                                    intp.println((Object)">");
                                                    break;
                                                }
                                                ++j;
                                            }
                                            ++i;
                                        }
                                        while (i < hosts.length) {
                                            intp.print((Object)"    ");
                                            intp.println((Object)hosts[i]);
                                            ++i;
                                        }
                                        break block53;
                                    }
                                    intp.println((Object)ConsoleMsg.formatter.getString("CONSOLE_NO_HOST_MESSAGE"));
                                    break block53;
                                }
                                fragments = packageAdmin.getFragments((Bundle)bundle);
                                if (fragments != null) {
                                    intp.println((Object)ConsoleMsg.formatter.getString("CONSOLE_FRAGMENT_MESSAGE"));
                                    i = 0;
                                    while (i < fragments.length) {
                                        intp.print((Object)"    ");
                                        intp.println((Object)fragments[i]);
                                        ++i;
                                    }
                                } else {
                                    intp.println((Object)ConsoleMsg.formatter.getString("CONSOLE_NO_FRAGMENT_MESSAGE"));
                                }
                            }
                            namedClassSpaces = packageAdmin.getProvidingBundles(null);
                            namedClassSpace = null;
                            if (namedClassSpaces != null) {
                                i = 0;
                                while (i < namedClassSpaces.length) {
                                    if (namedClassSpaces[i].getBundle() == bundle) {
                                        namedClassSpace = namedClassSpaces[i];
                                        break;
                                    }
                                    ++i;
                                }
                            }
                            if (namedClassSpace == null) {
                                intp.print((Object)"  ");
                                intp.println((Object)ConsoleMsg.formatter.getString("CONSOLE_NO_NAMED_CLASS_SPACES_MESSAGE"));
                            } else {
                                intp.print((Object)"  ");
                                intp.println((Object)ConsoleMsg.formatter.getString("CONSOLE_NAMED_CLASS_SPACE_MESSAGE"));
                                intp.print((Object)"    ");
                                intp.print(namedClassSpace);
                                if (namedClassSpace.isRemovalPending()) {
                                    intp.println((Object)ConsoleMsg.formatter.getString("CONSOLE_REMOVAL_PENDING_MESSAGE"));
                                } else {
                                    intp.println((Object)ConsoleMsg.formatter.getString("CONSOLE_PROVIDED_MESSAGE"));
                                }
                            }
                            title = true;
                            i = 0;
                            while (true) {
                                block54: {
                                    if (i < namedClassSpaces.length) break block54;
                                    if (title) {
                                        intp.print((Object)"  ");
                                        intp.println((Object)ConsoleMsg.formatter.getString("CONSOLE_NO_REQUIRED_BUNDLES_MESSAGE"));
                                    }
                                    break;
                                }
                                if (namedClassSpaces[i] != namedClassSpace && (depBundles = namedClassSpaces[i].getRequiringBundles()) != null) {
                                    j = 0;
                                    while (j < depBundles.length) {
                                        if (depBundles[j] == bundle) {
                                            if (title) {
                                                intp.print((Object)"  ");
                                                intp.println((Object)ConsoleMsg.formatter.getString("CONSOLE_REQUIRED_BUNDLES_MESSAGE"));
                                                title = false;
                                            }
                                            intp.print((Object)"    ");
                                            intp.print((Object)namedClassSpaces[i]);
                                            provider = namedClassSpaces[i].getBundle();
                                            intp.print((Object)"<");
                                            intp.print((Object)provider);
                                            intp.println((Object)">");
                                        }
                                        ++j;
                                    }
                                }
                                ++i;
                            }
                        }
                        catch (Throwable var18_28) {
                            var17_27 = null;
                            this.context.ungetService(packageAdminRef);
                            throw var18_28;
                        }
lbl-1000:
                        // 2 sources

                        {
                            var17_27 = null;
                            this.context.ungetService(packageAdminRef);
                            break block49;
                        }
                    }
                    intp.print((Object)"  ");
                    intp.println((Object)ConsoleMsg.formatter.getString("CONSOLE_NO_EXPORTED_PACKAGES_NO_PACKAGE_ADMIN_MESSAGE"));
                }
                if ((sm = System.getSecurityManager()) != null) {
                    domain = bundle.getProtectionDomain();
                    intp.println((Object)domain);
                }
            }
            nextArg = intp.nextArgument();
        }
    }

    public void _l(CommandInterpreter intp) throws Exception {
        this._log(intp);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void _log(CommandInterpreter intp) throws Exception {
        block24: {
            Object logreader;
            ServiceReference logreaderRef;
            long logid = -1L;
            String token = intp.nextArgument();
            if (token != null) {
                AbstractBundle bundle = this.getBundleFromToken(intp, token, false);
                if (bundle == null) {
                    try {
                        logid = Long.parseLong(token);
                    }
                    catch (NumberFormatException numberFormatException) {
                        return;
                    }
                } else {
                    logid = bundle.getBundleId();
                }
            }
            if ((logreaderRef = this.context.getServiceReference("org.osgi.service.log.LogReaderService")) == null || (logreader = this.context.getService(logreaderRef)) == null) break block24;
            try {
                Enumeration logentries = (Enumeration)logreader.getClass().getMethod("getLog", null).invoke(logreader, null);
                if (logentries.hasMoreElements()) {
                    Object logentry = logentries.nextElement();
                    Class<?> clazz = logentry.getClass();
                    Method getBundle = clazz.getMethod("getBundle", null);
                    Method getLevel = clazz.getMethod("getLevel", null);
                    Method getMessage = clazz.getMethod("getMessage", null);
                    Method getServiceReference = clazz.getMethod("getServiceReference", null);
                    Method getException = clazz.getMethod("getException", null);
                    while (true) {
                        AbstractBundle bundle = (AbstractBundle)getBundle.invoke(logentry, null);
                        if (logid == -1L || bundle != null && logid == bundle.getBundleId()) {
                            Integer level = (Integer)getLevel.invoke(logentry, null);
                            switch (level) {
                                case 4: {
                                    intp.print((Object)">");
                                    intp.print((Object)ConsoleMsg.formatter.getString("CONSOLE_DEBUG_MESSAGE"));
                                    intp.print((Object)" ");
                                    break;
                                }
                                case 3: {
                                    intp.print((Object)">");
                                    intp.print((Object)ConsoleMsg.formatter.getString("CONSOLE_INFO_MESSAGE"));
                                    intp.print((Object)" ");
                                    break;
                                }
                                case 2: {
                                    intp.print((Object)">");
                                    intp.print((Object)ConsoleMsg.formatter.getString("CONSOLE_WARNING_MESSAGE"));
                                    intp.print((Object)" ");
                                    break;
                                }
                                case 1: {
                                    intp.print((Object)">");
                                    intp.print((Object)ConsoleMsg.formatter.getString("CONSOLE_ERROR_MESSAGE"));
                                    intp.print((Object)" ");
                                    break;
                                }
                                default: {
                                    intp.print((Object)">");
                                    intp.print((Object)level);
                                    intp.print((Object)" ");
                                }
                            }
                            if (bundle != null) {
                                intp.print((Object)"[");
                                intp.print((Object)new Long(bundle.getBundleId()));
                                intp.print((Object)"] ");
                            }
                            intp.print(getMessage.invoke(logentry, null));
                            intp.print((Object)" ");
                            ServiceReferenceImpl svcref = (ServiceReferenceImpl)getServiceReference.invoke(logentry, null);
                            if (svcref != null) {
                                intp.print((Object)"{");
                                intp.print((Object)"service.id");
                                intp.print((Object)"=");
                                intp.print((Object)svcref.getProperty("service.id").toString());
                                intp.println((Object)"}");
                            } else if (bundle != null) {
                                intp.println((Object)bundle.getLocation());
                            } else {
                                intp.println();
                            }
                            Throwable t = (Throwable)getException.invoke(logentry, null);
                            if (t != null) {
                                intp.printStackTrace(t);
                            }
                        }
                        if (logentries.hasMoreElements()) {
                            logentry = logentries.nextElement();
                            continue;
                        }
                        break;
                    }
                }
            }
            catch (Throwable throwable) {
                Object var19_19 = null;
                this.context.ungetService(logreaderRef);
                throw throwable;
            }
            {
                Object var19_20 = null;
                this.context.ungetService(logreaderRef);
                return;
            }
        }
        intp.println((Object)ConsoleMsg.formatter.getString("CONSOLE_LOGSERVICE_NOT_REGISTERED_MESSAGE"));
    }

    public void _gc(CommandInterpreter intp) throws Exception {
        long before = Runtime.getRuntime().freeMemory();
        System.gc();
        System.gc();
        System.runFinalization();
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException interruptedException) {}
        long after = Runtime.getRuntime().freeMemory();
        intp.print((Object)ConsoleMsg.formatter.getString("CONSOLE_FREE_MEMORY_BEFORE_GARBAGE_COLLECTION_MESSAGE"));
        intp.println((Object)String.valueOf(before));
        intp.print((Object)ConsoleMsg.formatter.getString("CONSOLE_FREE_MEMORY_AFTER_GARBAGE_COLLECTION_MESSAGE"));
        intp.println((Object)String.valueOf(after));
        intp.print((Object)ConsoleMsg.formatter.getString("CONSOLE_MEMORY_GAINED_WITH_GARBAGE_COLLECTION_MESSAGE"));
        intp.println((Object)String.valueOf(after - before));
    }

    public void _init(CommandInterpreter intp) throws Exception {
        if (this.osgi.isActive()) {
            intp.print((Object)this.newline);
            intp.println((Object)ConsoleMsg.formatter.getString("CONSOLE_FRAMEWORK_LAUNCHED_PLEASE_SHUTDOWN_MESSAGE"));
            return;
        }
        AbstractBundle[] bundles = (AbstractBundle[])this.context.getBundles();
        int size = bundles.length;
        if (size > 0) {
            int i = 0;
            while (i < size) {
                AbstractBundle bundle = bundles[i];
                if (bundle.getBundleId() != 0L) {
                    try {
                        bundle.uninstall();
                    }
                    catch (BundleException e) {
                        intp.printStackTrace((Throwable)e);
                    }
                }
                ++i;
            }
        } else {
            intp.println((Object)ConsoleMsg.formatter.getString("CONSOLE_NO_INSTALLED_BUNDLES_ERROR"));
        }
    }

    public void _close(CommandInterpreter intp) throws Exception {
        intp.println();
        this.osgi.close();
        System.exit(0);
    }

    public void _r(CommandInterpreter intp) throws Exception {
        this._refresh(intp);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void _refresh(CommandInterpreter intp) throws Exception {
        ServiceReference packageAdminRef;
        block9: {
            block8: {
                packageAdminRef = this.context.getServiceReference("org.osgi.service.packageadmin.PackageAdmin");
                if (packageAdminRef == null) {
                    intp.println((Object)ConsoleMsg.formatter.getString("CONSOLE_CAN_NOT_REFRESH_NO_PACKAGE_ADMIN_ERROR"));
                    return;
                }
                PackageAdmin packageAdmin = (PackageAdmin)this.context.getService(packageAdminRef);
                if (packageAdmin == null) return;
                try {
                    Object[] refresh = null;
                    String token = intp.nextArgument();
                    if (token != null) {
                        int size;
                        Vector<AbstractBundle> bundles = new Vector<AbstractBundle>();
                        while (true) {
                            if (token == null) {
                                size = bundles.size();
                                if (size != 0) break;
                                intp.println((Object)ConsoleMsg.formatter.getString("CONSOLE_INVALID_BUNDLE_SPECIFICATION_ERROR"));
                                Object var8_9 = null;
                                break block8;
                            }
                            AbstractBundle bundle = this.getBundleFromToken(intp, token, true);
                            if (bundle != null) {
                                bundles.addElement(bundle);
                            }
                            token = intp.nextArgument();
                        }
                        refresh = new AbstractBundle[size];
                        bundles.copyInto(refresh);
                    }
                    packageAdmin.refreshPackages((Bundle[])refresh);
                    break block9;
                }
                catch (Throwable throwable) {
                    Object var8_10 = null;
                    this.context.ungetService(packageAdminRef);
                    throw throwable;
                }
            }
            this.context.ungetService(packageAdminRef);
            return;
        }
        Object var8_11 = null;
        this.context.ungetService(packageAdminRef);
    }

    public void _exec(CommandInterpreter intp) throws Exception {
        String command = intp.nextArgument();
        if (command == null) {
            intp.println((Object)ConsoleMsg.formatter.getString("CONSOLE_NO_COMMAND_SPECIFIED_ERROR"));
            return;
        }
        Process p = Runtime.getRuntime().exec(command);
        intp.println((Object)ConsoleMsg.formatter.getString("CONSOLE_STARTED_IN_MESSAGE", (Object)command, (Object)String.valueOf(p)));
        int result = p.waitFor();
        intp.println((Object)ConsoleMsg.formatter.getString("CONSOLE_EXECUTED_RESULT_CODE_MESSAGE", (Object)command, (Object)String.valueOf(result)));
    }

    public void _fork(CommandInterpreter intp) throws Exception {
        String command = intp.nextArgument();
        if (command == null) {
            intp.println((Object)ConsoleMsg.formatter.getString("CONSOLE_NO_COMMAND_SPECIFIED_ERROR"));
            return;
        }
        Process p = Runtime.getRuntime().exec(command);
        intp.println((Object)ConsoleMsg.formatter.getString("CONSOLE_STARTED_IN_MESSAGE", (Object)command, (Object)String.valueOf(p)));
    }

    public void _h(CommandInterpreter intp) throws Exception {
        this._headers(intp);
    }

    public void _headers(CommandInterpreter intp) throws Exception {
        String nextArg = intp.nextArgument();
        if (nextArg == null) {
            intp.println((Object)ConsoleMsg.formatter.getString("CONSOLE_NO_BUNDLE_SPECIFIED_ERROR"));
        }
        while (nextArg != null) {
            AbstractBundle bundle = this.getBundleFromToken(intp, nextArg, true);
            if (bundle != null) {
                intp.printDictionary(bundle.getHeaders(), ConsoleMsg.formatter.getString("CONSOLE_BUNDLE_HEADERS_TITLE"));
            }
            nextArg = intp.nextArgument();
        }
    }

    public void _pr(CommandInterpreter intp) throws Exception {
        this._props(intp);
    }

    public void _props(CommandInterpreter intp) throws Exception {
        intp.printDictionary((Dictionary)System.getProperties(), ConsoleMsg.formatter.getString("CONSOLE_SYSTEM_PROPERTIES_TITLE"));
    }

    public void _setp(CommandInterpreter intp) throws Exception {
        this._setprop(intp);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void _setprop(CommandInterpreter intp) throws Exception {
        String argument = intp.nextArgument();
        if (argument == null) {
            intp.println((Object)ConsoleMsg.formatter.getString("CONSOLE_NO_PARAMETERS_SPECIFIED_TITLE"));
            this._props(intp);
            return;
        }
        ByteArrayInputStream in = new ByteArrayInputStream(argument.getBytes());
        try {
            try {
                Properties sysprops = System.getProperties();
                Properties newprops = new Properties();
                newprops.load(in);
                intp.println((Object)ConsoleMsg.formatter.getString("CONSOLE_SETTING_PROPERTIES_TITLE"));
                Enumeration<?> keys = newprops.propertyNames();
                while (keys.hasMoreElements()) {
                    String key = (String)keys.nextElement();
                    String value = (String)newprops.get(key);
                    sysprops.put(key, value);
                    intp.println((Object)(String.valueOf(this.tab) + key + " = " + value));
                }
            }
            catch (IOException iOException) {}
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            try {
                ((InputStream)in).close();
                throw throwable;
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        {
            Object var9_11 = null;
        }
        try {}
        catch (IOException iOException) {
            return;
        }
        ((InputStream)in).close();
    }

    public void _ss(CommandInterpreter intp) throws Exception {
        if (this.osgi.isActive()) {
            intp.println();
            intp.println((Object)ConsoleMsg.formatter.getString("CONSOLE_FRAMEWORK_IS_LAUNCHED_MESSAGE"));
        } else {
            intp.println();
            intp.println((Object)ConsoleMsg.formatter.getString("CONSOLE_FRAMEWORK_IS_SHUTDOWN_MESSAGE"));
        }
        AbstractBundle[] bundles = (AbstractBundle[])this.context.getBundles();
        if (bundles.length == 0) {
            intp.println((Object)ConsoleMsg.formatter.getString("CONSOLE_NO_INSTALLED_BUNDLES_ERROR"));
        } else {
            intp.print((Object)this.newline);
            intp.print((Object)ConsoleMsg.formatter.getString("CONSOLE_ID"));
            intp.print((Object)this.tab);
            intp.print((Object)ConsoleMsg.formatter.getString("CONSOLE_TYPE"));
            intp.print((Object)this.tab);
            intp.println((Object)ConsoleMsg.formatter.getString("CONSOLE_STATE_BUNDLE_TITLE"));
            int i = 0;
            while (i < bundles.length) {
                AbstractBundle b = bundles[i];
                String type = "    ";
                intp.println((Object)(String.valueOf(b.getBundleId()) + "\t" + type + " \t" + this.getStateName(b.getState()) + b));
                if (b.isFragment()) {
                    AbstractBundle master = (AbstractBundle)b.getHost();
                    if (master != null) {
                        intp.println((Object)("\t\tMaster=" + master.getBundleId()));
                    }
                } else {
                    Bundle[] fragments = b.getFragments();
                    if (fragments != null) {
                        int f = 0;
                        while (f < fragments.length) {
                            AbstractBundle fragment = (AbstractBundle)fragments[f];
                            intp.println((Object)("\t\tFragment=" + fragment.getBundleId()));
                            ++f;
                        }
                    }
                }
                ++i;
            }
        }
    }

    public void _t(CommandInterpreter intp) throws Exception {
        this._threads(intp);
    }

    public void _threads(CommandInterpreter intp) throws Exception {
        Object[] threadGroups = this.getThreadGroups();
        Util.sort((Object[])threadGroups);
        Object tg = this.getTopThreadGroup();
        Object[] threads = new Thread[((ThreadGroup)tg).activeCount()];
        int count = ((ThreadGroup)tg).enumerate((Thread[])threads, true);
        Util.sort((Object[])threads);
        StringBuffer sb = new StringBuffer(120);
        intp.println();
        intp.println((Object)ConsoleMsg.formatter.getString("CONSOLE_THREADGROUP_TITLE"));
        int i = 0;
        while (i < threadGroups.length) {
            tg = threadGroups[i];
            int all = ((ThreadGroup)tg).activeCount();
            int local = ((ThreadGroup)tg).enumerate(new Thread[all], false);
            ThreadGroup p = ((ThreadGroup)tg).getParent();
            String parent = p == null ? "-none-" : p.getName();
            sb.setLength(0);
            sb.append(Util.toString((Object)this.simpleClassName(tg), (int)18)).append(" ").append(Util.toString((Object)((ThreadGroup)tg).getName(), (int)21)).append(" ").append(Util.toString((Object)parent, (int)16)).append(Util.toString((Object)new Integer(((ThreadGroup)tg).getMaxPriority()), (int)3)).append(Util.toString((Object)new Integer(local), (int)4)).append("/").append(Util.toString((Object)String.valueOf(all), (int)6));
            intp.println((Object)sb.toString());
            ++i;
        }
        intp.print((Object)this.newline);
        intp.println((Object)ConsoleMsg.formatter.getString("CONSOLE_THREADTYPE_TITLE"));
        int j = 0;
        while (j < count) {
            Object t = threads[j];
            if (t != null) {
                sb.setLength(0);
                sb.append(Util.toString((Object)this.simpleClassName(t), (int)18)).append(" ").append(Util.toString((Object)((Thread)t).getName(), (int)21)).append(" ").append(Util.toString((Object)((Thread)t).getThreadGroup().getName(), (int)16)).append(Util.toString((Object)new Integer(((Thread)t).getPriority()), (int)3));
                intp.println((Object)sb.toString());
            }
            ++j;
        }
    }

    public void _sl(CommandInterpreter intp) throws Exception {
        if (this.isStartLevelSvcPresent(intp)) {
            AbstractBundle bundle = null;
            String token = intp.nextArgument();
            int value = 0;
            if (token != null && (bundle = this.getBundleFromToken(intp, token, true)) == null) {
                return;
            }
            if (bundle == null) {
                value = this.slImpl.getStartLevel();
                intp.println((Object)ConsoleMsg.formatter.getString("STARTLEVEL_FRAMEWORK_ACTIVE_STARTLEVEL", value));
            } else {
                value = this.slImpl.getBundleStartLevel((Bundle)bundle);
                intp.println((Object)ConsoleMsg.formatter.getString("STARTLEVEL_BUNDLE_STARTLEVEL", (Object)new Long(bundle.getBundleId()), (Object)new Integer(value)));
            }
        }
    }

    public void _setfwsl(CommandInterpreter intp) throws Exception {
        if (this.isStartLevelSvcPresent(intp)) {
            int value = 0;
            String token = intp.nextArgument();
            if (token == null) {
                intp.println((Object)ConsoleMsg.formatter.getString("STARTLEVEL_NO_STARTLEVEL_GIVEN"));
                value = this.slImpl.getStartLevel();
                intp.println((Object)ConsoleMsg.formatter.getString("STARTLEVEL_FRAMEWORK_ACTIVE_STARTLEVEL", value));
            } else {
                value = this.getStartLevelFromToken(intp, token);
                if (value > 0) {
                    try {
                        this.slImpl.setStartLevel(value);
                        intp.println((Object)ConsoleMsg.formatter.getString("STARTLEVEL_FRAMEWORK_ACTIVE_STARTLEVEL", value));
                    }
                    catch (IllegalArgumentException e) {
                        intp.println((Object)e.getMessage());
                    }
                }
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    public void _setbsl(CommandInterpreter intp) throws Exception {
        block5: {
            if (!this.isStartLevelSvcPresent(intp)) break block5;
            bundle = null;
            token = intp.nextArgument();
            if (token == null) {
                intp.println((Object)ConsoleMsg.formatter.getString("STARTLEVEL_NO_STARTLEVEL_OR_BUNDLE_GIVEN"));
                return;
            }
            newSL = this.getStartLevelFromToken(intp, token);
            token = intp.nextArgument();
            if (token != null) ** GOTO lbl21
            intp.println((Object)ConsoleMsg.formatter.getString("STARTLEVEL_NO_STARTLEVEL_OR_BUNDLE_GIVEN"));
            return;
lbl-1000:
            // 1 sources

            {
                bundle = this.getBundleFromToken(intp, token, true);
                if (bundle != null) {
                    try {
                        this.slImpl.setBundleStartLevel((Bundle)bundle, newSL);
                        intp.println((Object)ConsoleMsg.formatter.getString("STARTLEVEL_BUNDLE_STARTLEVEL", (Object)new Long(bundle.getBundleId()), (Object)new Integer(newSL)));
                    }
                    catch (IllegalArgumentException e) {
                        intp.println((Object)e.getMessage());
                    }
                }
                token = intp.nextArgument();
lbl21:
                // 2 sources

                ** while (token != null)
            }
        }
    }

    public void _setibsl(CommandInterpreter intp) throws Exception {
        if (this.isStartLevelSvcPresent(intp)) {
            int value = 0;
            String token = intp.nextArgument();
            if (token == null) {
                intp.println((Object)ConsoleMsg.formatter.getString("STARTLEVEL_NO_STARTLEVEL_GIVEN"));
                value = this.slImpl.getInitialBundleStartLevel();
                intp.println((Object)ConsoleMsg.formatter.getString("STARTLEVEL_INITIAL_BUNDLE_STARTLEVEL", value));
            } else {
                value = this.getStartLevelFromToken(intp, token);
                if (value > 0) {
                    try {
                        this.slImpl.setInitialBundleStartLevel(value);
                        intp.println((Object)ConsoleMsg.formatter.getString("STARTLEVEL_INITIAL_BUNDLE_STARTLEVEL", value));
                    }
                    catch (IllegalArgumentException e) {
                        intp.println((Object)e.getMessage());
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void _classSpaces(CommandInterpreter intp) {
        token = intp.nextArgument();
        packageAdminRef = this.context.getServiceReference("org.osgi.service.packageadmin.PackageAdmin");
        if (packageAdminRef == null) {
            intp.println((Object)ConsoleMsg.formatter.getString("CONSOLE_NO_EXPORTED_PACKAGES_NO_PACKAGE_ADMIN_MESSAGE"));
            return;
        }
        packageAdmin = (PackageAdmin)this.context.getService(packageAdminRef);
        if (packageAdmin == null) return;
        try {
            block10: {
                symBundles = null;
                symBundles = packageAdmin.getProvidingBundles(token);
                if (symBundles != null) break block10;
                intp.println((Object)ConsoleMsg.formatter.getString("CONSOLE_NO_NAMED_CLASS_SPACES_MESSAGE"));
                ** GOTO lbl-1000
            }
            i = 0;
            while (i < symBundles.length) {
                symBundle = symBundles[i];
                intp.print((Object)symBundle);
                removalPending = symBundle.isRemovalPending();
                if (removalPending) {
                    intp.print((Object)"(");
                    intp.print((Object)ConsoleMsg.formatter.getString("CONSOLE_REMOVAL_PENDING_MESSAGE"));
                    intp.println((Object)")");
                }
                if ((provider = symBundle.getBundle()) != null) {
                    intp.print((Object)"<");
                    intp.print((Object)provider);
                    intp.println((Object)">");
                    requiring = symBundle.getRequiringBundles();
                    if (requiring != null) {
                        j = 0;
                        while (j < requiring.length) {
                            intp.print((Object)"  ");
                            intp.print((Object)requiring[j]);
                            intp.print((Object)" ");
                            intp.println((Object)ConsoleMsg.formatter.getString("CONSOLE_REQUIRES_MESSAGE"));
                            ++j;
                        }
                    }
                } else {
                    intp.print((Object)"<");
                    intp.print((Object)ConsoleMsg.formatter.getString("CONSOLE_STALE_MESSAGE"));
                    intp.println((Object)">");
                }
                ++i;
            }
        }
        catch (Throwable var13_12) {
            var12_13 = null;
            this.context.ungetService(packageAdminRef);
            throw var13_12;
        }
lbl-1000:
        // 2 sources

        {
            var12_14 = null;
            this.context.ungetService(packageAdminRef);
            return;
        }
    }

    protected boolean isStartLevelSvcPresent(CommandInterpreter intp) {
        boolean retval = false;
        ServiceReference slSvcRef = this.context.getServiceReference("org.osgi.service.startlevel.StartLevel");
        if (slSvcRef != null) {
            StartLevel slSvc = (StartLevel)this.context.getService(slSvcRef);
            if (slSvc != null) {
                retval = true;
            }
        } else {
            intp.println((Object)ConsoleMsg.formatter.getString("CONSOLE_CAN_NOT_USE_STARTLEVEL_NO_STARTLEVEL_SVC_ERROR"));
        }
        return retval;
    }

    protected AbstractBundle getBundleFromToken(CommandInterpreter intp, String token, boolean error) {
        AbstractBundle bundle;
        try {
            long id = Long.parseLong(token);
            bundle = (AbstractBundle)this.context.getBundle(id);
        }
        catch (NumberFormatException numberFormatException) {
            bundle = ((BundleContextImpl)this.context).getBundleByLocation(token);
        }
        if (bundle == null && error) {
            intp.println((Object)ConsoleMsg.formatter.getString("CONSOLE_CANNOT_FIND_BUNDLE_ERROR", (Object)token));
        }
        return bundle;
    }

    protected int getStartLevelFromToken(CommandInterpreter intp, String value) {
        int retval = -1;
        try {
            retval = Integer.parseInt(value);
            if (Integer.parseInt(value) <= 0) {
                intp.println((Object)ConsoleMsg.formatter.getString("STARTLEVEL_POSITIVE_INTEGER"));
            }
        }
        catch (NumberFormatException numberFormatException) {
            intp.println((Object)ConsoleMsg.formatter.getString("STARTLEVEL_POSITIVE_INTEGER"));
        }
        return retval;
    }

    protected String getStateName(int state) {
        switch (state) {
            case 1: {
                return ConsoleMsg.formatter.getString("CONSOLE_UNINSTALLED_MESSAGE");
            }
            case 2: {
                return ConsoleMsg.formatter.getString("CONSOLE_INSTALLED_MESSAGE");
            }
            case 4: {
                return ConsoleMsg.formatter.getString("CONSOLE_RESOLVED_MESSAGE");
            }
            case 8: {
                return ConsoleMsg.formatter.getString("CONSOLE_STARTING_MESSAGE");
            }
            case 16: {
                return ConsoleMsg.formatter.getString("CONSOLE_STOPPING_MESSAGE");
            }
            case 32: {
                return ConsoleMsg.formatter.getString("CONSOLE_ACTIVE_MESSAGE");
            }
        }
        return Integer.toHexString(state);
    }

    protected ThreadGroup[] getThreadGroups() {
        ThreadGroup[] groups;
        ThreadGroup tg = this.getTopThreadGroup();
        int count = tg.enumerate(groups = new ThreadGroup[tg.activeGroupCount()], true);
        if (count == groups.length) {
            return groups;
        }
        ThreadGroup[] ngroups = new ThreadGroup[count];
        System.arraycopy(groups, 0, ngroups, 0, count);
        return ngroups;
    }

    protected ThreadGroup getTopThreadGroup() {
        ThreadGroup topGroup = Thread.currentThread().getThreadGroup();
        if (topGroup != null) {
            while (topGroup.getParent() != null) {
                topGroup = topGroup.getParent();
            }
        }
        return topGroup;
    }

    public String simpleClassName(Object o) {
        StringTokenizer t = new StringTokenizer(o.getClass().getName(), ".");
        int ct = t.countTokens();
        int i = 1;
        while (i < ct) {
            t.nextToken();
            ++i;
        }
        return t.nextToken();
    }
}

