/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ltk.internal.ui.refactoring;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.util.Assert;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.TextChange;
import org.eclipse.ltk.core.refactoring.TextEditChangeGroup;
import org.eclipse.ltk.internal.ui.refactoring.ChangeElement;
import org.eclipse.ltk.internal.ui.refactoring.ChangePreviewViewerDescriptor;
import org.eclipse.ltk.internal.ui.refactoring.DefaultChangeElement;
import org.eclipse.ltk.internal.ui.refactoring.PseudoJavaChangeElement;
import org.eclipse.ltk.internal.ui.refactoring.TextChangePreviewViewer;
import org.eclipse.ltk.ui.refactoring.ChangePreviewViewerInput;
import org.eclipse.ltk.ui.refactoring.IChangePreviewViewer;

class TextEditChangeElement
extends ChangeElement {
    private static final ChangeElement[] fgChildren = new ChangeElement[0];
    private TextEditChangeGroup fChangeGroup;

    public TextEditChangeElement(ChangeElement parent, TextEditChangeGroup changeGroup) {
        super(parent);
        this.fChangeGroup = changeGroup;
        Assert.isNotNull((Object)this.fChangeGroup);
    }

    public TextEditChangeGroup getTextEditChange() {
        return this.fChangeGroup;
    }

    public Change getChange() {
        return null;
    }

    public ChangePreviewViewerDescriptor getChangePreviewViewerDescriptor() throws CoreException {
        DefaultChangeElement element = this.getDefaultChangeElement();
        if (element == null) {
            return null;
        }
        return element.getChangePreviewViewerDescriptor();
    }

    public void feedInput(IChangePreviewViewer viewer) throws CoreException {
        DefaultChangeElement element = this.getDefaultChangeElement();
        if (element != null) {
            Change change = element.getChange();
            if (change instanceof TextChange) {
                IRegion range = TextEditChangeElement.getTextRange(this);
                ChangePreviewViewerInput input = null;
                input = range != null ? TextChangePreviewViewer.createInput(change, new TextEditChangeGroup[]{this.fChangeGroup}, range) : TextChangePreviewViewer.createInput(change, this.fChangeGroup, 2);
                viewer.setInput(input);
            }
        } else {
            viewer.setInput(null);
        }
    }

    public void setActive(boolean active) {
        this.fChangeGroup.setEnabled(active);
    }

    public int getActive() {
        return this.fChangeGroup.isEnabled() ? 2 : 0;
    }

    public ChangeElement[] getChildren() {
        return fgChildren;
    }

    private DefaultChangeElement getDefaultChangeElement() {
        ChangeElement element = this.getParent();
        while (!(element instanceof DefaultChangeElement) && element != null) {
            element = element.getParent();
        }
        return (DefaultChangeElement)element;
    }

    private static IRegion getTextRange(ChangeElement element) throws CoreException {
        if (element == null) {
            return null;
        }
        if (element instanceof PseudoJavaChangeElement) {
            return ((PseudoJavaChangeElement)element).getTextRange();
        }
        if (element instanceof DefaultChangeElement) {
            return null;
        }
        return TextEditChangeElement.getTextRange(element.getParent());
    }
}

