/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ui.actions;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.ILocalVariable;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.refactoring.code.InlineTempRefactoring;
import org.eclipse.jdt.internal.ui.actions.ActionUtil;
import org.eclipse.jdt.internal.ui.actions.SelectionConverter;
import org.eclipse.jdt.internal.ui.javaeditor.CompilationUnitEditor;
import org.eclipse.jdt.internal.ui.javaeditor.JavaTextSelection;
import org.eclipse.jdt.internal.ui.refactoring.InlineTempWizard;
import org.eclipse.jdt.internal.ui.refactoring.RefactoringMessages;
import org.eclipse.jdt.internal.ui.refactoring.actions.RefactoringStarter;
import org.eclipse.jdt.internal.ui.util.ExceptionHandler;
import org.eclipse.jdt.ui.actions.SelectionDispatchAction;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.ui.refactoring.RefactoringWizard;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.help.WorkbenchHelp;

public class InlineTempAction
extends SelectionDispatchAction {
    private CompilationUnitEditor fEditor;
    private static final String DIALOG_MESSAGE_TITLE = RefactoringMessages.getString("InlineTempAction.inline_temp");

    public InlineTempAction(CompilationUnitEditor editor) {
        this((IWorkbenchSite)editor.getEditorSite());
        this.fEditor = editor;
        this.setEnabled(SelectionConverter.canOperateOn(this.fEditor));
    }

    InlineTempAction(IWorkbenchSite site) {
        super(site);
        this.setText(RefactoringMessages.getString("InlineTempAction.label"));
        WorkbenchHelp.setHelp((IAction)this, (String)"org.eclipse.jdt.ui.inline_action");
    }

    public void selectionChanged(ITextSelection selection) {
        this.setEnabled(true);
    }

    public void selectionChanged(JavaTextSelection selection) {
        try {
            this.setEnabled(this.canEnable(selection));
        }
        catch (JavaModelException javaModelException) {
            this.setEnabled(false);
        }
    }

    private boolean canEnable(JavaTextSelection selection) throws JavaModelException {
        IJavaElement[] elements = selection.resolveElementAtOffset();
        if (elements.length != 1) {
            return false;
        }
        return elements[0] instanceof ILocalVariable && InlineTempRefactoring.isAvailable((ILocalVariable)elements[0]);
    }

    public void run(ITextSelection selection) {
        try {
            ICompilationUnit input = SelectionConverter.getInputAsCompilationUnit(this.fEditor);
            if (!ActionUtil.isProcessable(this.getShell(), input)) {
                return;
            }
            Refactoring refactoring = this.createRefactoring(input, selection);
            if (refactoring == null) {
                return;
            }
            new RefactoringStarter().activate(refactoring, this.createWizard(refactoring), this.getShell(), DIALOG_MESSAGE_TITLE, false);
        }
        catch (JavaModelException e) {
            ExceptionHandler.handle((CoreException)((Object)e), DIALOG_MESSAGE_TITLE, RefactoringMessages.getString("NewTextRefactoringAction.exception"));
        }
    }

    protected Refactoring createRefactoring(ICompilationUnit cunit, ITextSelection selection) {
        return InlineTempRefactoring.create(cunit, selection.getOffset(), selection.getLength());
    }

    protected RefactoringWizard createWizard(Refactoring refactoring) {
        InlineTempWizard result = new InlineTempWizard((InlineTempRefactoring)refactoring);
        return result;
    }

    public void run(IStructuredSelection selection) {
    }

    public void selectionChanged(IStructuredSelection selection) {
        this.setEnabled(false);
    }
}

