/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.wizards.buildpaths;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.CorrectionEngine;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.preferences.PreferencePageSupport;
import org.eclipse.jdt.internal.ui.preferences.UserLibraryPreferencePage;
import org.eclipse.jdt.internal.ui.util.ExceptionHandler;
import org.eclipse.jdt.internal.ui.wizards.NewWizardMessages;
import org.eclipse.jdt.ui.wizards.BuildPathDialogAccess;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.IPreferencePage;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IMarkerResolution;
import org.eclipse.ui.IMarkerResolution2;
import org.eclipse.ui.IMarkerResolutionGenerator;
import org.eclipse.ui.IMarkerResolutionGenerator2;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class UserLibraryMarkerResolutionGenerator
implements IMarkerResolutionGenerator,
IMarkerResolutionGenerator2 {
    private static final IMarkerResolution[] NO_RESOLUTION = new IMarkerResolution[0];

    public boolean hasResolutions(IMarker marker) {
        int id = marker.getAttribute("id", -1);
        return id == 963;
    }

    public IMarkerResolution[] getResolutions(IMarker marker) {
        Image image;
        String label;
        final Shell shell = JavaPlugin.getActiveWorkbenchShell();
        if (!this.hasResolutions(marker) || shell == null) {
            return NO_RESOLUTION;
        }
        ArrayList<UserLibraryMarkerResolution> resolutions = new ArrayList<UserLibraryMarkerResolution>();
        String[] arguments = CorrectionEngine.getProblemArguments((IMarker)marker);
        Path path = new Path(arguments[0]);
        IJavaProject project = this.getJavaProject(marker);
        if (path.segment(0).equals("org.eclipse.jdt.USER_LIBRARY")) {
            label = NewWizardMessages.getString("UserLibraryMarkerResolutionGenerator.changetouserlib.label");
            image = JavaPluginImages.get("org.eclipse.jdt.ui.correction_rename.gif");
            resolutions.add(new UserLibraryMarkerResolution(label, image, (IPath)path, project){
                private final /* synthetic */ IPath val$path;
                private final /* synthetic */ IJavaProject val$project;
                {
                    this.val$path = iPath;
                    this.val$project = iJavaProject;
                }

                public void run(IMarker m) {
                    UserLibraryMarkerResolutionGenerator.this.changeToExistingLibrary(shell, this.val$path, false, this.val$project);
                }
            });
            if (path.segmentCount() == 2) {
                String label2 = NewWizardMessages.getFormattedString("UserLibraryMarkerResolutionGenerator.createuserlib.label", path.segment(1));
                Image image2 = JavaPluginImages.get("org.eclipse.jdt.ui.add_correction.gif");
                resolutions.add(new UserLibraryMarkerResolution(label2, image2, (IPath)path, project){
                    private final /* synthetic */ IPath val$path;
                    private final /* synthetic */ IJavaProject val$project;
                    {
                        this.val$path = iPath;
                        this.val$project = iJavaProject;
                    }

                    public void run(IMarker m) {
                        UserLibraryMarkerResolutionGenerator.this.createUserLibrary(shell, this.val$path, this.val$project);
                    }
                });
            }
        }
        label = NewWizardMessages.getString("UserLibraryMarkerResolutionGenerator.changetoother");
        image = JavaPluginImages.get("org.eclipse.jdt.ui.correction_rename.gif");
        resolutions.add(new UserLibraryMarkerResolution(label, image, (IPath)path, project){
            private final /* synthetic */ IPath val$path;
            private final /* synthetic */ IJavaProject val$project;
            {
                this.val$path = iPath;
                this.val$project = iJavaProject;
            }

            public void run(IMarker m) {
                UserLibraryMarkerResolutionGenerator.this.changeToExistingLibrary(shell, this.val$path, true, this.val$project);
            }
        });
        return resolutions.toArray(new IMarkerResolution[resolutions.size()]);
    }

    protected void changeToExistingLibrary(Shell shell, IPath path, boolean isNew, final IJavaProject project) {
        try {
            IClasspathEntry[] res;
            IClasspathEntry[] entries = project.getRawClasspath();
            int idx = this.indexOfClasspath(entries, path);
            if (idx == -1) {
                return;
            }
            if (isNew) {
                res = BuildPathDialogAccess.chooseContainerEntries(shell, project, entries);
                if (res == null) {
                    return;
                }
            } else {
                IClasspathEntry resEntry = BuildPathDialogAccess.configureContainerEntry(shell, entries[idx], project, entries);
                if (resEntry == null) {
                    return;
                }
                res = new IClasspathEntry[]{resEntry};
            }
            final IClasspathEntry[] newEntries = new IClasspathEntry[entries.length - 1 + res.length];
            System.arraycopy(entries, 0, newEntries, 0, idx);
            System.arraycopy(res, 0, newEntries, idx, res.length);
            System.arraycopy(entries, idx + 1, newEntries, idx + res.length, entries.length - idx - 1);
            IWorkbenchWindow context = JavaPlugin.getActiveWorkbenchWindow();
            if (context == null) {
                context = PlatformUI.getWorkbench().getProgressService();
            }
            context.run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        project.setRawClasspath(newEntries, project.getOutputLocation(), monitor);
                    }
                    catch (CoreException e) {
                        throw new InvocationTargetException(e);
                    }
                }
            });
        }
        catch (JavaModelException e) {
            String title = NewWizardMessages.getString("UserLibraryMarkerResolutionGenerator.error.title");
            String message = NewWizardMessages.getString("UserLibraryMarkerResolutionGenerator.error.creationfailed.message");
            ExceptionHandler.handle((CoreException)((Object)e), shell, title, message);
        }
        catch (InvocationTargetException e) {
            String title = NewWizardMessages.getString("UserLibraryMarkerResolutionGenerator.error.title");
            String message = NewWizardMessages.getString("UserLibraryMarkerResolutionGenerator.error.applyingfailed.message");
            ExceptionHandler.handle(e, shell, title, message);
        }
        catch (InterruptedException interruptedException) {}
    }

    private int indexOfClasspath(IClasspathEntry[] entries, IPath path) {
        int i = 0;
        while (i < entries.length) {
            IClasspathEntry curr = entries[i];
            if (curr.getEntryKind() == 5 && curr.getPath().equals((Object)path)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    protected void createUserLibrary(Shell shell, IPath unboundPath, IJavaProject project) {
        String name = unboundPath.segment(1);
        UserLibraryPreferencePage page = new UserLibraryPreferencePage(name, true);
        PreferencePageSupport.showPreferencePage(shell, "org.eclipse.jdt.ui.preferences.UserLibraryPreferencePage", (IPreferencePage)page);
    }

    private IJavaProject getJavaProject(IMarker marker) {
        return JavaCore.create((IProject)marker.getResource().getProject());
    }

    private static abstract class UserLibraryMarkerResolution
    implements IMarkerResolution,
    IMarkerResolution2 {
        private String fLabel;
        private Image fImage;

        public UserLibraryMarkerResolution(String label, Image image) {
            this.fLabel = label;
            this.fImage = image;
        }

        public String getLabel() {
            return this.fLabel;
        }

        public String getDescription() {
            return null;
        }

        public Image getImage() {
            return this.fImage;
        }
    }
}

