/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.refactoring.nls.search;

import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.ui.search.SearchMessages;
import org.eclipse.jdt.internal.ui.search.SearchUtil;
import org.eclipse.jdt.internal.ui.util.ExceptionHandler;
import org.eclipse.search.ui.IGroupByKeyComputer;

class NLSGroupByKeyComputer
implements IGroupByKeyComputer {
    IJavaElement fLastJavaElement = null;
    String fLastHandle = null;

    NLSGroupByKeyComputer() {
    }

    public Object computeGroupByKey(IMarker marker) {
        if (marker == null || marker.getResource() == null) {
            return null;
        }
        if (!marker.getResource().getName().endsWith(".java")) {
            return marker.getResource();
        }
        IJavaElement jElement = this.getJavaElement(marker);
        if (jElement != null && jElement.exists()) {
            return this.fLastHandle;
        }
        return null;
    }

    private String getJavaElementHandleId(IMarker marker) {
        try {
            return (String)marker.getAttribute("org.eclipse.jdt.internal.ui.search.handleID");
        }
        catch (CoreException ex) {
            ExceptionHandler.handle(ex, SearchMessages.getString("Search.Error.markerAttributeAccess.title"), SearchMessages.getString("Search.Error.markerAttributeAccess.message"));
            return null;
        }
    }

    private IJavaElement getJavaElement(IMarker marker) {
        String handle = this.getJavaElementHandleId(marker);
        if (handle == null) {
            this.fLastHandle = null;
            this.fLastJavaElement = null;
            return null;
        }
        if (!handle.equals(this.fLastHandle)) {
            this.fLastHandle = handle;
            this.fLastJavaElement = SearchUtil.getJavaElement(marker);
            IResource handleResource = null;
            try {
                if (this.fLastJavaElement != null) {
                    handleResource = this.fLastJavaElement.getCorrespondingResource();
                }
            }
            catch (JavaModelException ex) {
                ExceptionHandler.handle((CoreException)((Object)ex), SearchMessages.getString("Search.Error.javaElementAccess.title"), SearchMessages.getString("Search.Error.javaElementAccess.message"));
            }
            if (this.fLastJavaElement != null) {
                marker.getResource().equals((Object)handleResource);
            }
        }
        return this.fLastJavaElement;
    }
}

