/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.template.java;

import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.internal.corext.template.java.CompilationUnitContext;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.TemplateBuffer;
import org.eclipse.jface.text.templates.TemplateContext;
import org.eclipse.jface.text.templates.TemplateContextType;
import org.eclipse.jface.text.templates.TemplateException;
import org.eclipse.jface.text.templates.TemplateTranslator;

public class JavaDocContext
extends CompilationUnitContext {
    private static final char HTML_TAG_BEGIN = '<';
    private static final char HTML_TAG_END = '>';
    private static final char JAVADOC_TAG_BEGIN = '@';

    public JavaDocContext(TemplateContextType type, IDocument document, int completionOffset, int completionLength, ICompilationUnit compilationUnit) {
        super(type, document, completionOffset, completionLength, compilationUnit);
    }

    public boolean canEvaluate(Template template) {
        String key = this.getKey();
        if (this.fForceEvaluation) {
            return true;
        }
        return template.matches(key, this.getContextType().getId()) && key.length() != 0 && template.getName().toLowerCase().startsWith(key.toLowerCase());
    }

    public int getStart() {
        try {
            IDocument document = this.getDocument();
            if (this.getCompletionLength() == 0) {
                int start = this.getCompletionOffset();
                if (start != 0 && document.getChar(start - 1) == '>') {
                    --start;
                }
                while (start != 0 && Character.isUnicodeIdentifierPart(document.getChar(start - 1))) {
                    --start;
                }
                if (start != 0 && Character.isUnicodeIdentifierStart(document.getChar(start - 1))) {
                    --start;
                }
                if (start != 0 && (document.getChar(start - 1) == '<' || document.getChar(start - 1) == '@')) {
                    --start;
                }
                return start;
            }
            int start = this.getCompletionOffset();
            int end = this.getCompletionOffset() + this.getCompletionLength();
            while (start != 0 && Character.isUnicodeIdentifierPart(document.getChar(start - 1))) {
                --start;
            }
            while (start != end && Character.isWhitespace(document.getChar(start))) {
                ++start;
            }
            if (start == end) {
                start = this.getCompletionOffset();
            }
            return start;
        }
        catch (BadLocationException badLocationException) {
            return this.getCompletionOffset();
        }
    }

    public int getEnd() {
        if (this.getCompletionLength() == 0) {
            return super.getEnd();
        }
        try {
            IDocument document = this.getDocument();
            int start = this.getCompletionOffset();
            int end = this.getCompletionOffset() + this.getCompletionLength();
            while (start != end && Character.isWhitespace(document.getChar(end - 1))) {
                --end;
            }
            return end;
        }
        catch (BadLocationException badLocationException) {
            return super.getEnd();
        }
    }

    public String getKey() {
        if (this.getCompletionLength() == 0) {
            return super.getKey();
        }
        try {
            IDocument document = this.getDocument();
            int start = this.getStart();
            int end = this.getCompletionOffset();
            return start <= end ? document.get(start, end - start) : "";
        }
        catch (BadLocationException badLocationException) {
            return super.getKey();
        }
    }

    public TemplateBuffer evaluate(Template template) throws BadLocationException, TemplateException {
        TemplateTranslator translator = new TemplateTranslator();
        TemplateBuffer buffer = translator.translate(template);
        this.getContextType().resolve(buffer, (TemplateContext)this);
        return buffer;
    }
}

