/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.rename;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.jdt.core.compiler.IProblem;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclaration;
import org.eclipse.jdt.internal.corext.SourceRange;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.dom.NodeFinder;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.jdt.internal.corext.refactoring.base.JavaStringStatusContext;
import org.eclipse.jface.text.IRegion;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.RefactoringStatusContext;
import org.eclipse.ltk.core.refactoring.TextChange;
import org.eclipse.text.edits.TextEdit;

public class RefactoringAnalyzeUtil {
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;

    private RefactoringAnalyzeUtil() {
    }

    public static IRegion[] getNewRanges(TextEdit[] edits, TextChange change) {
        IRegion[] result = new IRegion[edits.length];
        int i = 0;
        while (i < edits.length) {
            result[i] = RefactoringAnalyzeUtil.getNewTextRange(edits[i], change);
            ++i;
        }
        return result;
    }

    public static RefactoringStatus reportProblemNodes(String modifiedWorkingCopySource, SimpleName[] problemNodes) {
        RefactoringStatus result = new RefactoringStatus();
        int i = 0;
        while (i < problemNodes.length) {
            JavaStringStatusContext context = new JavaStringStatusContext(modifiedWorkingCopySource, new SourceRange((ASTNode)problemNodes[i]));
            result.addError(RefactoringCoreMessages.getFormattedString("RefactoringAnalyzeUtil.name_collision", problemNodes[i].getIdentifier()), (RefactoringStatusContext)context);
            ++i;
        }
        return result;
    }

    public static String getFullBindingKey(VariableDeclaration decl) {
        MethodDeclaration md;
        Class<?> clazz;
        TypeDeclaration td;
        Class<?> clazz2;
        AnonymousClassDeclaration acd;
        Class<?> clazz3;
        StringBuffer buff = new StringBuffer();
        if (decl.resolveBinding() != null) {
            buff.append(decl.resolveBinding().getVariableId());
            buff.append('/');
        } else {
            buff.append(decl.getStartPosition()).append('*').append('/');
        }
        if ((clazz3 = class$0) == null) {
            try {
                clazz3 = class$0 = Class.forName("org.eclipse.jdt.core.dom.AnonymousClassDeclaration");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((acd = (AnonymousClassDeclaration)ASTNodes.getParent((ASTNode)decl, clazz3)) != null && acd.resolveBinding() != null) {
            if (acd.resolveBinding().getKey() != null) {
                buff.append(acd.resolveBinding().getKey());
            } else {
                buff.append("AnonymousClassDeclaration");
            }
            buff.append('/');
        }
        if ((clazz2 = class$1) == null) {
            try {
                clazz2 = class$1 = Class.forName("org.eclipse.jdt.core.dom.TypeDeclaration");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((td = (TypeDeclaration)ASTNodes.getParent((ASTNode)decl, clazz2)) != null && td.resolveBinding() != null) {
            if (td.resolveBinding().getKey() != null) {
                buff.append(td.resolveBinding().getKey());
            } else {
                buff.append("TypeDeclaration");
            }
            buff.append('/');
        }
        if ((clazz = class$2) == null) {
            try {
                clazz = class$2 = Class.forName("org.eclipse.jdt.core.dom.MethodDeclaration");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((md = (MethodDeclaration)ASTNodes.getParent((ASTNode)decl, clazz)) != null && md.resolveBinding() != null) {
            if (md.resolveBinding().getKey() != null) {
                buff.append(md.resolveBinding().getKey());
            } else {
                buff.append("MethodDeclaration");
            }
        }
        return buff.toString();
    }

    public static MethodDeclaration getMethodDeclaration(TextEdit edit, TextChange change, CompilationUnit cuNode) {
        SimpleName decl = RefactoringAnalyzeUtil.findSimpleNameNode(RefactoringAnalyzeUtil.getNewTextRange(edit, change), cuNode);
        Class<?> clazz = class$2;
        if (clazz == null) {
            try {
                clazz = class$2 = Class.forName("org.eclipse.jdt.core.dom.MethodDeclaration");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (MethodDeclaration)ASTNodes.getParent((ASTNode)decl, clazz);
    }

    public static Block getBlock(TextEdit edit, TextChange change, CompilationUnit cuNode) {
        SimpleName decl = RefactoringAnalyzeUtil.findSimpleNameNode(RefactoringAnalyzeUtil.getNewTextRange(edit, change), cuNode);
        Class<?> clazz = class$3;
        if (clazz == null) {
            try {
                clazz = class$3 = Class.forName("org.eclipse.jdt.core.dom.Block");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (Block)ASTNodes.getParent((ASTNode)decl, clazz);
    }

    public static IProblem[] getIntroducedCompileProblems(CompilationUnit newCUNode, CompilationUnit oldCuNode) {
        HashSet<IProblem> subResult = new HashSet<IProblem>();
        Set oldProblems = RefactoringAnalyzeUtil.getOldProblems(oldCuNode);
        IProblem[] newProblems = ASTNodes.getProblems((ASTNode)newCUNode, 2, 3);
        int i = 0;
        while (i < newProblems.length) {
            IProblem correspondingOld = RefactoringAnalyzeUtil.findCorrespondingProblem(oldProblems, newProblems[i]);
            if (correspondingOld == null) {
                subResult.add(newProblems[i]);
            }
            ++i;
        }
        return subResult.toArray(new IProblem[subResult.size()]);
    }

    private static IProblem findCorrespondingProblem(Set oldProblems, IProblem iProblem) {
        Iterator iter = oldProblems.iterator();
        while (iter.hasNext()) {
            IProblem oldProblem = (IProblem)iter.next();
            if (!RefactoringAnalyzeUtil.isCorresponding(oldProblem, iProblem)) continue;
            return oldProblem;
        }
        return null;
    }

    private static boolean isCorresponding(IProblem oldProblem, IProblem iProblem) {
        if (oldProblem.getID() != iProblem.getID()) {
            return false;
        }
        return oldProblem.getMessage().equals(iProblem.getMessage());
    }

    private static SimpleName getSimpleName(ASTNode node) {
        if (node instanceof SimpleName) {
            return (SimpleName)node;
        }
        if (node instanceof VariableDeclaration) {
            return ((VariableDeclaration)node).getName();
        }
        return null;
    }

    private static SimpleName findSimpleNameNode(IRegion range, CompilationUnit cuNode) {
        ASTNode node = NodeFinder.perform((ASTNode)cuNode, range.getOffset(), range.getLength());
        return RefactoringAnalyzeUtil.getSimpleName(node);
    }

    private static IRegion getNewTextRange(TextEdit edit, TextChange change) {
        return change.getPreviewEdit(edit).getRegion();
    }

    private static Set getOldProblems(CompilationUnit oldCuNode) {
        return new HashSet<IProblem>(Arrays.asList(ASTNodes.getProblems((ASTNode)oldCuNode, 2, 3)));
    }
}

