/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.code.flow;

import java.util.Iterator;
import java.util.List;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.CatchClause;
import org.eclipse.jdt.core.dom.ForStatement;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.ReturnStatement;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationExpression;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.VariableDeclarationStatement;
import org.eclipse.jdt.internal.corext.refactoring.code.flow.FlowAnalyzer;
import org.eclipse.jdt.internal.corext.refactoring.code.flow.FlowContext;
import org.eclipse.jdt.internal.corext.refactoring.code.flow.FlowInfo;
import org.eclipse.jdt.internal.corext.refactoring.code.flow.GenericSequentialFlowInfo;

public class InOutFlowAnalyzer
extends FlowAnalyzer {
    public InOutFlowAnalyzer(FlowContext context) {
        super(context);
    }

    public FlowInfo perform(ASTNode[] selectedNodes) {
        FlowContext context = this.getFlowContext();
        GenericSequentialFlowInfo result = this.createSequential();
        int i = 0;
        while (i < selectedNodes.length) {
            ASTNode node = selectedNodes[i];
            node.accept((ASTVisitor)this);
            result.merge(this.getFlowInfo(node), context);
            ++i;
        }
        return result;
    }

    protected boolean traverseNode(ASTNode node) {
        return true;
    }

    protected boolean createReturnFlowInfo(ReturnStatement node) {
        return true;
    }

    public void endVisit(Block node) {
        super.endVisit(node);
        this.clearAccessMode(this.accessFlowInfo((ASTNode)node), node.statements());
    }

    public void endVisit(CatchClause node) {
        super.endVisit(node);
        this.clearAccessMode(this.accessFlowInfo((ASTNode)node), node.getException());
    }

    public void endVisit(ForStatement node) {
        super.endVisit(node);
        this.clearAccessMode(this.accessFlowInfo((ASTNode)node), node.initializers());
    }

    public void endVisit(MethodDeclaration node) {
        super.endVisit(node);
        FlowInfo info = this.accessFlowInfo((ASTNode)node);
        Iterator iter = node.parameters().iterator();
        while (iter.hasNext()) {
            this.clearAccessMode(info, (SingleVariableDeclaration)iter.next());
        }
    }

    private void clearAccessMode(FlowInfo info, SingleVariableDeclaration decl) {
        IVariableBinding binding = decl.resolveBinding();
        if (binding != null && !binding.isField()) {
            info.clearAccessMode(binding, this.fFlowContext);
        }
    }

    private void clearAccessMode(FlowInfo info, List nodes) {
        if (nodes == null || nodes.isEmpty() || info == null) {
            return;
        }
        Iterator iter = nodes.iterator();
        while (iter.hasNext()) {
            Object node = iter.next();
            Iterator fragments = null;
            if (node instanceof VariableDeclarationStatement) {
                fragments = ((VariableDeclarationStatement)node).fragments().iterator();
            } else if (node instanceof VariableDeclarationExpression) {
                fragments = ((VariableDeclarationExpression)node).fragments().iterator();
            }
            if (fragments == null) continue;
            while (fragments.hasNext()) {
                this.clearAccessMode(info, (VariableDeclarationFragment)fragments.next());
            }
        }
    }

    private void clearAccessMode(FlowInfo info, VariableDeclarationFragment fragment) {
        IVariableBinding binding = fragment.resolveBinding();
        if (binding != null && !binding.isField()) {
            info.clearAccessMode(binding, this.fFlowContext);
        }
    }
}

