/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui.propertypages;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.debug.core.IJavaBreakpoint;
import org.eclipse.jdt.internal.debug.ui.JDIDebugUIPlugin;
import org.eclipse.jdt.internal.debug.ui.propertypages.PropertyPageMessages;
import org.eclipse.jdt.ui.JavaElementLabelProvider;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.PropertyPage;

public class JavaBreakpointPage
extends PropertyPage {
    protected JavaElementLabelProvider fJavaLabelProvider = new JavaElementLabelProvider(JavaElementLabelProvider.SHOW_DEFAULT);
    protected Button fEnabledButton;
    protected Button fHitCountButton;
    protected Button fSuspendThreadButton;
    protected Button fSuspendVMButton;
    protected Text fHitCountText;
    protected List fErrorMessages = new ArrayList();
    private static final String fgHitCountErrorMessage = PropertyPageMessages.getString("JavaBreakpointPage.0");

    public boolean performOk() {
        IWorkspaceRunnable wr = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                JavaBreakpointPage.this.doStore();
            }
        };
        try {
            ResourcesPlugin.getWorkspace().run(wr, null, 0, null);
        }
        catch (CoreException e) {
            JDIDebugUIPlugin.errorDialog(PropertyPageMessages.getString("JavaBreakpointPage.1"), e);
            JDIDebugUIPlugin.log(e);
        }
        return super.performOk();
    }

    public void addErrorMessage(String message) {
        if (message == null) {
            return;
        }
        this.fErrorMessages.remove(message);
        this.fErrorMessages.add(message);
        this.setErrorMessage(message);
        this.setValid(false);
    }

    public void setErrorMessage(String newMessage) {
        super.setErrorMessage(newMessage);
    }

    public void removeErrorMessage(String message) {
        this.fErrorMessages.remove(message);
        if (this.fErrorMessages.isEmpty()) {
            this.setErrorMessage(null);
            this.setValid(true);
        } else {
            this.setErrorMessage((String)this.fErrorMessages.get(this.fErrorMessages.size() - 1));
        }
    }

    protected void doStore() throws CoreException {
        IJavaBreakpoint breakpoint = this.getBreakpoint();
        this.storeSuspendPolicy(breakpoint);
        this.storeHitCount(breakpoint);
        this.storeEnabled(breakpoint);
    }

    private void storeEnabled(IJavaBreakpoint breakpoint) throws CoreException {
        boolean enabled = this.fEnabledButton.getSelection();
        breakpoint.setEnabled(enabled);
    }

    private void storeHitCount(IJavaBreakpoint breakpoint) throws CoreException {
        boolean hitCountEnabled = this.fHitCountButton.getSelection();
        int hitCount = -1;
        if (hitCountEnabled) {
            try {
                hitCount = Integer.parseInt(this.fHitCountText.getText());
            }
            catch (NumberFormatException e) {
                JDIDebugUIPlugin.log((IStatus)new Status(4, JDIDebugUIPlugin.getUniqueIdentifier(), 4, MessageFormat.format(PropertyPageMessages.getString("JavaBreakpointPage.2"), this.fHitCountText.getText()), (Throwable)e));
            }
        }
        breakpoint.setHitCount(hitCount);
    }

    private void storeSuspendPolicy(IJavaBreakpoint breakpoint) throws CoreException {
        int suspendPolicy = 1;
        if (this.fSuspendThreadButton.getSelection()) {
            suspendPolicy = 2;
        }
        breakpoint.setSuspendPolicy(suspendPolicy);
    }

    protected Control createContents(Composite parent) {
        this.noDefaultAndApplyButton();
        Composite mainComposite = this.createComposite(parent, 1);
        this.createLabels(mainComposite);
        try {
            this.createEnabledButton(mainComposite);
            this.createHitCountEditor(mainComposite);
            this.createTypeSpecificEditors(mainComposite);
            this.createSuspendPolicyEditor(mainComposite);
        }
        catch (CoreException e) {
            JDIDebugUIPlugin.log(e);
        }
        this.setValid(true);
        return mainComposite;
    }

    protected void createLabels(Composite parent) {
        IJavaBreakpoint breakpoint = (IJavaBreakpoint)this.getElement();
        Composite labelComposite = this.createComposite(parent, 2);
        try {
            String typeName = breakpoint.getTypeName();
            if (typeName != null) {
                this.createLabel(labelComposite, PropertyPageMessages.getString("JavaBreakpointPage.3"));
                this.createLabel(labelComposite, typeName);
            }
            this.createTypeSpecificLabels(labelComposite);
        }
        catch (CoreException ce) {
            JDIDebugUIPlugin.log(ce);
        }
    }

    private void createSuspendPolicyEditor(Composite parent) throws CoreException {
        IJavaBreakpoint breakpoint = this.getBreakpoint();
        this.createLabel(parent, PropertyPageMessages.getString("JavaBreakpointPage.6"));
        boolean suspendThread = breakpoint.getSuspendPolicy() == 2;
        Composite radioComposite = this.createComposite(parent, 2);
        this.fSuspendThreadButton = this.createRadioButton(radioComposite, PropertyPageMessages.getString("JavaBreakpointPage.7"));
        this.fSuspendThreadButton.setSelection(suspendThread);
        this.fSuspendVMButton = this.createRadioButton(radioComposite, PropertyPageMessages.getString("JavaBreakpointPage.8"));
        this.fSuspendVMButton.setSelection(!suspendThread);
    }

    private void createHitCountEditor(Composite parent) throws CoreException {
        IJavaBreakpoint breakpoint = this.getBreakpoint();
        Composite hitCountComposite = this.createComposite(parent, 2);
        this.fHitCountButton = this.createCheckButton(hitCountComposite, PropertyPageMessages.getString("JavaBreakpointPage.4"));
        this.fHitCountButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                JavaBreakpointPage.this.fHitCountText.setEnabled(JavaBreakpointPage.this.fHitCountButton.getSelection());
                JavaBreakpointPage.this.hitCountChanged();
            }
        });
        int hitCount = breakpoint.getHitCount();
        String hitCountString = "";
        if (hitCount > 0) {
            hitCountString = new Integer(hitCount).toString();
            this.fHitCountButton.setSelection(true);
        } else {
            this.fHitCountButton.setSelection(false);
        }
        this.fHitCountText = this.createText(hitCountComposite, hitCountString);
        if (hitCount <= 0) {
            this.fHitCountText.setEnabled(false);
        }
        this.fHitCountText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                JavaBreakpointPage.this.hitCountChanged();
            }
        });
    }

    private void hitCountChanged() {
        if (!this.fHitCountButton.getSelection()) {
            this.removeErrorMessage(fgHitCountErrorMessage);
            return;
        }
        String hitCountText = this.fHitCountText.getText();
        int hitCount = -1;
        try {
            hitCount = Integer.parseInt(hitCountText);
        }
        catch (NumberFormatException numberFormatException) {
            this.addErrorMessage(fgHitCountErrorMessage);
            return;
        }
        if (hitCount < 1) {
            this.addErrorMessage(fgHitCountErrorMessage);
        } else if (fgHitCountErrorMessage.equals(this.getErrorMessage())) {
            this.removeErrorMessage(fgHitCountErrorMessage);
        }
    }

    protected void createEnabledButton(Composite parent) throws CoreException {
        this.fEnabledButton = this.createCheckButton(parent, PropertyPageMessages.getString("JavaBreakpointPage.5"));
        this.fEnabledButton.setSelection(this.getBreakpoint().isEnabled());
    }

    protected IJavaBreakpoint getBreakpoint() {
        return (IJavaBreakpoint)this.getElement();
    }

    protected void createTypeSpecificLabels(Composite parent) {
    }

    protected void createTypeSpecificEditors(Composite parent) throws CoreException {
    }

    protected Text createText(Composite parent, String initialValue) {
        Composite textComposite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        textComposite.setLayout((Layout)layout);
        textComposite.setLayoutData((Object)new GridData(768));
        textComposite.setFont(parent.getFont());
        Text text = new Text(textComposite, 2052);
        text.setText(initialValue);
        text.setFont(parent.getFont());
        text.setLayoutData((Object)new GridData(768));
        return text;
    }

    protected Composite createComposite(Composite parent, int numColumns) {
        Composite composit = new Composite(parent, 0);
        composit.setFont(parent.getFont());
        GridLayout layout = new GridLayout();
        layout.numColumns = numColumns;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        composit.setLayout((Layout)layout);
        composit.setLayoutData((Object)new GridData(768));
        return composit;
    }

    protected Button createCheckButton(Composite parent, String text) {
        Button button = new Button(parent, 16416);
        button.setText(text);
        button.setFont(parent.getFont());
        button.setLayoutData((Object)new GridData());
        return button;
    }

    protected Label createLabel(Composite parent, String text) {
        Label label = new Label(parent, 0);
        label.setText(text);
        label.setFont(parent.getFont());
        label.setLayoutData((Object)new GridData());
        return label;
    }

    protected Button createRadioButton(Composite parent, String text) {
        Button button = new Button(parent, 16400);
        button.setText(text);
        button.setFont(parent.getFont());
        button.setLayoutData((Object)new GridData());
        return button;
    }
}

