/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui.jres;

import java.io.File;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.internal.debug.ui.JDIDebugUIPlugin;
import org.eclipse.jdt.internal.debug.ui.actions.AddExternalJarAction;
import org.eclipse.jdt.internal.debug.ui.actions.AttachSourceAction;
import org.eclipse.jdt.internal.debug.ui.actions.MoveDownAction;
import org.eclipse.jdt.internal.debug.ui.actions.MoveUpAction;
import org.eclipse.jdt.internal.debug.ui.actions.RemoveAction;
import org.eclipse.jdt.internal.debug.ui.actions.RuntimeClasspathAction;
import org.eclipse.jdt.internal.debug.ui.jres.AddVMDialog;
import org.eclipse.jdt.internal.debug.ui.jres.JREMessages;
import org.eclipse.jdt.internal.debug.ui.launcher.IClasspathViewer;
import org.eclipse.jdt.internal.debug.ui.launcher.IEntriesChangedListener;
import org.eclipse.jdt.internal.debug.ui.launcher.RuntimeClasspathViewer;
import org.eclipse.jdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.jdt.launching.IRuntimeClasspathEntry;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.IVMInstallType;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.launching.LibraryLocation;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class VMLibraryBlock
implements IEntriesChangedListener {
    protected IVMInstall fVmInstall;
    protected IVMInstallType fVmInstallType;
    protected File fHome;
    protected RuntimeClasspathViewer fPathViewer;
    protected Button fDefaultButton;
    protected AddVMDialog fDialog = null;
    protected boolean fInCallback = false;
    protected static final String DIALOG_SETTINGS_PREFIX = "VMLibraryBlock";

    public VMLibraryBlock(AddVMDialog dialog) {
        this.fDialog = dialog;
    }

    public Control createControl(Composite parent) {
        Font font = parent.getFont();
        Composite comp = new Composite(parent, 0);
        GridLayout topLayout = new GridLayout();
        topLayout.numColumns = 2;
        topLayout.marginHeight = 0;
        topLayout.marginWidth = 0;
        comp.setLayout((Layout)topLayout);
        GridData gd = new GridData(1808);
        comp.setLayoutData((Object)gd);
        this.fDefaultButton = new Button(comp, 32);
        this.fDefaultButton.setText(JREMessages.getString("VMLibraryBlock.Use_default_system_libraries_1"));
        gd = new GridData(32);
        gd.horizontalSpan = 2;
        this.fDefaultButton.setLayoutData((Object)gd);
        this.fDefaultButton.setFont(font);
        this.fDefaultButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                VMLibraryBlock.this.handleDefaultButtonSelected();
            }
        });
        this.fPathViewer = new RuntimeClasspathViewer(comp);
        gd = new GridData(1808);
        this.fPathViewer.getControl().setLayoutData((Object)gd);
        this.fPathViewer.getControl().setFont(font);
        this.fPathViewer.addEntriesChangedListener(this);
        Composite pathButtonComp = new Composite(comp, 0);
        GridLayout pathButtonLayout = new GridLayout();
        pathButtonLayout.marginHeight = 0;
        pathButtonLayout.marginWidth = 0;
        pathButtonComp.setLayout((Layout)pathButtonLayout);
        gd = new GridData(258);
        pathButtonComp.setLayoutData((Object)gd);
        pathButtonComp.setFont(font);
        RuntimeClasspathAction action = new MoveUpAction(this.fPathViewer);
        Button button = this.createPushButton(pathButtonComp, action.getText());
        action.setButton(button);
        action = new MoveDownAction(this.fPathViewer);
        button = this.createPushButton(pathButtonComp, action.getText());
        action.setButton(button);
        action = new RemoveAction(this.fPathViewer);
        button = this.createPushButton(pathButtonComp, action.getText());
        action.setButton(button);
        action = new AddExternalJarAction(this.fPathViewer, DIALOG_SETTINGS_PREFIX);
        button = this.createPushButton(pathButtonComp, action.getText());
        action.setButton(button);
        action = new AttachSourceAction(this.fPathViewer, 8);
        button = this.createPushButton(pathButtonComp, action.getText());
        action.setButton(button);
        return comp;
    }

    protected void handleDefaultButtonSelected() {
        this.update();
    }

    protected Button createPushButton(Composite parent, String label) {
        Button button = new Button(parent, 8);
        button.setFont(parent.getFont());
        button.setText(label);
        this.fDialog.setButtonLayoutData(button);
        return button;
    }

    protected void createVerticalSpacer(Composite comp, int colSpan) {
        Label label = new Label(comp, 0);
        GridData gd = new GridData();
        gd.horizontalSpan = colSpan;
        label.setLayoutData((Object)gd);
    }

    public void initializeFrom(IVMInstall vm, IVMInstallType type) {
        this.setVMInstall(vm);
        this.setVMInstallType(type);
        if (vm != null) {
            this.setHomeDirectory(vm.getInstallLocation());
        }
        this.fDefaultButton.setSelection(vm == null || vm.getLibraryLocations() == null);
        if (this.isDefaultSystemLibrary()) {
            this.update();
        } else {
            LibraryLocation[] libs = vm.getLibraryLocations();
            IRuntimeClasspathEntry[] entries = new IRuntimeClasspathEntry[libs.length];
            int i = 0;
            while (i < libs.length) {
                entries[i] = JavaRuntime.newArchiveRuntimeClasspathEntry((IPath)libs[i].getSystemLibraryPath());
                entries[i].setSourceAttachmentPath(libs[i].getSystemLibrarySourcePath());
                entries[i].setSourceAttachmentRootPath(libs[i].getPackageRootPath());
                ++i;
            }
            this.fPathViewer.setEntries(entries);
            this.fPathViewer.setEnabled(true);
        }
    }

    public void setHomeDirectory(File file) {
        this.fHome = file;
    }

    protected File getHomeDirectory() {
        return this.fHome;
    }

    public void update() {
        boolean useDefault = this.fDefaultButton.getSelection();
        LibraryLocation[] libs = null;
        StatusInfo status = null;
        if (useDefault) {
            libs = this.getHomeDirectory() == null ? new LibraryLocation[]{} : this.getVMInstallType().getDefaultLibraryLocations(this.getHomeDirectory());
            IRuntimeClasspathEntry[] entries = new IRuntimeClasspathEntry[libs.length];
            int i = 0;
            while (i < libs.length) {
                IPath libPath = libs[i].getSystemLibraryPath();
                entries[i] = JavaRuntime.newArchiveRuntimeClasspathEntry((IPath)libPath);
                entries[i].setSourceAttachmentPath(libs[i].getSystemLibrarySourcePath());
                entries[i].setSourceAttachmentRootPath(libs[i].getPackageRootPath());
                if (!libPath.toFile().exists() && status == null) {
                    status = new Status(4, JDIDebugUIPlugin.getUniqueIdentifier(), 150, JREMessages.getString("VMLibraryBlock.Default_libraries_do_not_exist._1"), null);
                }
                ++i;
            }
            this.fInCallback = true;
            this.fPathViewer.setEntries(entries);
            this.fInCallback = false;
        }
        this.fPathViewer.setEnabled(!useDefault);
        if (this.getEntries().length == 0 && !this.isDefaultSystemLibrary()) {
            status = new Status(4, JDIDebugUIPlugin.getUniqueIdentifier(), 150, JREMessages.getString("VMLibraryBlock.Libraries_cannot_be_empty._1"), null);
        } else if (status == null) {
            status = new StatusInfo();
        }
        this.fDialog.setSystemLibraryStatus((IStatus)status);
        this.fDialog.updateStatusLine();
    }

    public void performApply(IVMInstall vm) {
        boolean def = this.fDefaultButton.getSelection();
        if (def) {
            vm.setLibraryLocations(null);
        } else {
            IRuntimeClasspathEntry[] entries = this.fPathViewer.getEntries();
            LibraryLocation[] libs = new LibraryLocation[entries.length];
            int i = 0;
            while (i < entries.length) {
                IPath root;
                IPath lib = entries[i].getPath();
                IPath src = entries[i].getSourceAttachmentPath();
                if (src == null) {
                    src = Path.ROOT;
                }
                if ((root = entries[i].getSourceAttachmentRootPath()) == null) {
                    root = Path.EMPTY;
                }
                libs[i] = new LibraryLocation(lib, src, root);
                ++i;
            }
            vm.setLibraryLocations(libs);
        }
    }

    public IRuntimeClasspathEntry[] getEntries() {
        return this.fPathViewer.getEntries();
    }

    private void setVMInstall(IVMInstall vm) {
        this.fVmInstall = vm;
    }

    protected IVMInstall getVMInstall() {
        return this.fVmInstall;
    }

    public boolean isDefaultSystemLibrary() {
        return this.fDefaultButton.getSelection();
    }

    private void setVMInstallType(IVMInstallType type) {
        this.fVmInstallType = type;
    }

    protected IVMInstallType getVMInstallType() {
        return this.fVmInstallType;
    }

    public void entriesChanged(IClasspathViewer viewer) {
        if (!this.fInCallback) {
            this.fInCallback = true;
            this.update();
            this.fInCallback = false;
        }
    }
}

