/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.launchConfigurations;

import java.text.MessageFormat;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.SWTUtil;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchConfigurationManager;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchConfigurationPresentationManager;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchConfigurationTabGroupExtension;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchConfigurationsMessages;
import org.eclipse.debug.internal.ui.launchConfigurations.PerspectiveTabGroup;
import org.eclipse.debug.internal.ui.launchConfigurations.PerspectivesTab;
import org.eclipse.debug.ui.ILaunchConfigurationDialog;
import org.eclipse.debug.ui.ILaunchConfigurationTab;
import org.eclipse.debug.ui.ILaunchConfigurationTabGroup;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;

public class LaunchConfigurationTabGroupViewer
extends Viewer {
    private ILaunchConfigurationDialog fDialog;
    private Object fInput;
    private ILaunchConfiguration fOriginal;
    private ILaunchConfigurationWorkingCopy fWorkingCopy;
    private Composite fViewerControl;
    private Composite fVisibleArea;
    private Label fNameLabel;
    private Text fNameWidget;
    private Composite fTabComposite;
    private TabFolder fTabFolder;
    private ILaunchConfigurationTabGroup fTabGroup;
    private ILaunchConfigurationType fTabType;
    private int fCurrentTabIndex = -1;
    private Button fApplyButton;
    private Button fRevertButton;
    private boolean fDisposingTabs = false;
    private boolean fInitializingTabs = false;
    private boolean fRedraw = true;
    private String fDescription = null;

    public LaunchConfigurationTabGroupViewer(Composite parent, ILaunchConfigurationDialog dialog) {
        this.fDialog = dialog;
        this.createControl(parent);
    }

    public void dispose() {
        this.disposeTabGroup();
    }

    protected void disposeTabGroup() {
        if (this.getTabGroup() != null) {
            this.getTabGroup().dispose();
            this.setTabGroup(null);
            this.setTabType(null);
        }
    }

    private void createControl(Composite parent) {
        Font font = parent.getFont();
        this.fViewerControl = new Composite(parent, 0);
        GridLayout outerCompLayout = new GridLayout();
        outerCompLayout.numColumns = 1;
        outerCompLayout.marginHeight = 0;
        outerCompLayout.marginWidth = 0;
        this.fViewerControl.setLayout((Layout)outerCompLayout);
        GridData gd = new GridData(1808);
        this.fViewerControl.setLayoutData((Object)gd);
        Composite container = new Composite(this.fViewerControl, 0);
        outerCompLayout = new GridLayout();
        outerCompLayout.numColumns = 2;
        outerCompLayout.marginHeight = 0;
        outerCompLayout.marginWidth = 5;
        container.setLayout((Layout)outerCompLayout);
        gd = new GridData(1808);
        container.setLayoutData((Object)gd);
        this.setVisibleArea(container);
        this.fNameLabel = new Label(container, 16640);
        this.fNameLabel.setText(LaunchConfigurationsMessages.getString("LaunchConfigurationDialog.&Name__16"));
        gd = new GridData(1);
        this.fNameLabel.setLayoutData((Object)gd);
        this.fNameLabel.setFont(font);
        Text nameText = new Text(container, 2052);
        gd = new GridData(768);
        nameText.setLayoutData((Object)gd);
        nameText.setFont(font);
        this.setNameWidget(nameText);
        this.getNameWidget().addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                LaunchConfigurationTabGroupViewer.this.handleNameModified();
            }
        });
        Label spacer = new Label(container, 0);
        gd = new GridData();
        gd.horizontalSpan = 2;
        spacer.setLayoutData((Object)gd);
        this.fTabComposite = new Composite(container, 0);
        GridLayout outerTabCompositeLayout = new GridLayout();
        outerTabCompositeLayout.marginHeight = 0;
        outerTabCompositeLayout.marginWidth = 0;
        this.fTabComposite.setLayout((Layout)outerTabCompositeLayout);
        gd = new GridData(1808);
        gd.horizontalSpan = 2;
        this.fTabComposite.setLayoutData((Object)gd);
        this.createTabFolder(this.fTabComposite);
        Composite buttonComp = new Composite(container, 0);
        GridLayout buttonCompLayout = new GridLayout();
        buttonCompLayout.numColumns = 2;
        buttonComp.setLayout((Layout)buttonCompLayout);
        gd = new GridData(128);
        gd.horizontalSpan = 2;
        buttonComp.setLayoutData((Object)gd);
        this.setApplyButton(new Button(buttonComp, 8));
        this.getApplyButton().setText(LaunchConfigurationsMessages.getString("LaunchConfigurationDialog.&Apply_17"));
        gd = new GridData(128);
        this.getApplyButton().setLayoutData((Object)gd);
        this.getApplyButton().setFont(font);
        SWTUtil.setButtonDimensionHint(this.getApplyButton());
        this.getApplyButton().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                LaunchConfigurationTabGroupViewer.this.handleApplyPressed();
            }
        });
        this.setRevertButton(new Button(buttonComp, 8));
        this.getRevertButton().setText(LaunchConfigurationsMessages.getString("LaunchConfigurationDialog.Revert_2"));
        gd = new GridData(128);
        this.getRevertButton().setLayoutData((Object)gd);
        this.getRevertButton().setFont(font);
        SWTUtil.setButtonDimensionHint(this.getRevertButton());
        this.getRevertButton().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                LaunchConfigurationTabGroupViewer.this.handleRevertPressed();
            }
        });
    }

    private void createTabFolder(Composite parent) {
        Point size = null;
        if (this.fTabFolder != null) {
            size = this.fTabFolder.getSize();
            this.fTabFolder.dispose();
        }
        this.fTabFolder = new TabFolder(parent, 0);
        GridData gd = new GridData(1808);
        this.fTabFolder.setLayoutData((Object)gd);
        this.fTabFolder.setFont(parent.getFont());
        if (size != null) {
            this.fTabFolder.setSize(size);
        }
        this.getTabFolder().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (!LaunchConfigurationTabGroupViewer.this.isInitializingTabs()) {
                    LaunchConfigurationTabGroupViewer.this.handleTabSelected();
                }
            }
        });
    }

    private void setApplyButton(Button button) {
        this.fApplyButton = button;
    }

    protected Button getApplyButton() {
        return this.fApplyButton;
    }

    private void setRevertButton(Button button) {
        this.fRevertButton = button;
    }

    protected Button getRevertButton() {
        return this.fRevertButton;
    }

    protected TabFolder getTabFolder() {
        return this.fTabFolder;
    }

    private Text getNameWidget() {
        return this.fNameWidget;
    }

    private void setNameWidget(Text nameText) {
        this.fNameWidget = nameText;
    }

    public void setName(String name) {
        if (this.getWorkingCopy() != null) {
            if (name == null) {
                name = "";
            }
            this.getNameWidget().setText(name.trim());
            this.refreshStatus();
        }
    }

    public Control getControl() {
        return this.fViewerControl;
    }

    protected Shell getShell() {
        return this.getControl().getShell();
    }

    public Object getInput() {
        return this.fInput;
    }

    public ISelection getSelection() {
        if (this.getActiveTab() == null) {
            return new StructuredSelection();
        }
        return new StructuredSelection((Object)this.getActiveTab());
    }

    public void refresh() {
        if (this.isInitializingTabs()) {
            return;
        }
        ILaunchConfigurationTab[] tabs = this.getTabs();
        if (!this.isInitializingTabs() && tabs != null) {
            this.getActiveTab().performApply(this.getWorkingCopy());
            this.updateButtons();
            TabFolder folder = this.getTabFolder();
            int i = 0;
            while (i < tabs.length) {
                ILaunchConfigurationTab tab = tabs[i];
                tab.isValid((ILaunchConfiguration)this.getWorkingCopy());
                boolean error = tab.getErrorMessage() != null;
                TabItem item = folder.getItem(i);
                this.setTabIcon(item, error, tab);
                ++i;
            }
        }
    }

    private void updateButtons() {
        boolean dirty = this.isDirty();
        this.getApplyButton().setEnabled(dirty && this.canSave());
        this.getRevertButton().setEnabled(dirty);
    }

    private void setTabIcon(TabItem tabItem, boolean error, ILaunchConfigurationTab tab) {
        Image image = null;
        image = error ? DebugUIPlugin.getDefault().getLaunchConfigurationManager().getErrorTabImage(tab) : tab.getImage();
        tabItem.setImage(image);
    }

    public void setInput(Object input) {
        if (input == null) {
            if (this.fInput == null) {
                return;
            }
            this.inputChanged(input);
        } else if (!input.equals(this.fInput)) {
            this.inputChanged(input);
        }
    }

    protected void inputChanged(Object input) {
        this.fInput = input;
        Runnable r = new Runnable(){

            public void run() {
                try {
                    if (LaunchConfigurationTabGroupViewer.this.fInput instanceof ILaunchConfiguration) {
                        ILaunchConfiguration configuration = (ILaunchConfiguration)LaunchConfigurationTabGroupViewer.this.fInput;
                        LaunchConfigurationTabGroupViewer.this.setOriginal(configuration);
                        LaunchConfigurationTabGroupViewer.this.setWorkingCopy(configuration.getWorkingCopy());
                        LaunchConfigurationTabGroupViewer.this.displayInstanceTabs();
                    } else if (LaunchConfigurationTabGroupViewer.this.fInput instanceof ILaunchConfigurationType) {
                        ILaunchConfiguration configuration = LaunchConfigurationManager.getSharedTypeConfig((ILaunchConfigurationType)LaunchConfigurationTabGroupViewer.this.fInput);
                        LaunchConfigurationTabGroupViewer.this.setOriginal(configuration);
                        LaunchConfigurationTabGroupViewer.this.setWorkingCopy(configuration.getWorkingCopy());
                        LaunchConfigurationTabGroupViewer.this.displaySharedTabs();
                    } else {
                        LaunchConfigurationTabGroupViewer.this.setNoInput();
                    }
                    LaunchConfigurationTabGroupViewer.this.setRedraw(true);
                }
                catch (CoreException ce) {
                    LaunchConfigurationTabGroupViewer.this.errorDialog(ce);
                    LaunchConfigurationTabGroupViewer.this.setNoInput();
                    LaunchConfigurationTabGroupViewer.this.setRedraw(true);
                }
            }
        };
        BusyIndicator.showWhile((Display)this.getShell().getDisplay(), (Runnable)r);
    }

    private void setNoInput() {
        this.setOriginal(null);
        this.setWorkingCopy(null);
        this.getVisibleArea().setVisible(false);
        this.disposeExistingTabs();
    }

    private void setRedraw(boolean b) {
        if (this.fRedraw != b) {
            this.fRedraw = b;
            this.getVisibleArea().setRedraw(this.fRedraw);
        }
    }

    protected void displayInstanceTabs() {
        this.setInitializingTabs(true);
        ILaunchConfigurationType type = null;
        try {
            type = this.getWorkingCopy().getType();
            this.showInstanceTabsFor(type);
        }
        catch (CoreException e) {
            this.errorDialog(e);
            this.setInitializingTabs(false);
            return;
        }
        this.fNameLabel.setVisible(true);
        this.fNameWidget.setVisible(true);
        this.getNameWidget().setText(this.getWorkingCopy().getName());
        ILaunchConfigurationTabGroup tabGroup = this.getTabGroup();
        if (tabGroup == null) {
            Status status = new Status(4, DebugUIPlugin.getUniqueIdentifier(), 0, MessageFormat.format(LaunchConfigurationsMessages.getString("LaunchConfigurationTabGroupViewer.No_tabs_defined_for_launch_configuration_type_{0}_1"), type.getName()), null);
            CoreException e = new CoreException((IStatus)status);
            this.errorDialog(e);
            this.setInitializingTabs(false);
            return;
        }
        tabGroup.initializeFrom((ILaunchConfiguration)this.getWorkingCopy());
        this.getNameWidget().setText(this.getWorkingCopy().getName());
        this.fCurrentTabIndex = this.getTabFolder().getSelectionIndex();
        this.setInitializingTabs(false);
        if (!this.getVisibleArea().isVisible()) {
            this.getVisibleArea().setVisible(true);
        }
        this.refreshStatus();
    }

    protected void displaySharedTabs() {
        this.setInitializingTabs(true);
        ILaunchConfigurationType type = null;
        try {
            type = this.getWorkingCopy().getType();
            this.showSharedTabsFor(type);
        }
        catch (CoreException e) {
            this.errorDialog(e);
            this.setInitializingTabs(false);
            return;
        }
        this.fNameLabel.setVisible(false);
        this.fNameWidget.setVisible(false);
        this.getNameWidget().setText(this.getWorkingCopy().getName());
        ILaunchConfigurationTabGroup tabGroup = this.getTabGroup();
        if (tabGroup == null) {
            Status status = new Status(4, DebugUIPlugin.getUniqueIdentifier(), 0, MessageFormat.format(LaunchConfigurationsMessages.getString("LaunchConfigurationTabGroupViewer.No_tabs_defined_for_launch_configuration_type_{0}_1"), type.getName()), null);
            CoreException e = new CoreException((IStatus)status);
            this.errorDialog(e);
            this.setInitializingTabs(false);
            return;
        }
        tabGroup.initializeFrom((ILaunchConfiguration)this.getWorkingCopy());
        this.getNameWidget().setText(this.getWorkingCopy().getName());
        this.fCurrentTabIndex = this.getTabFolder().getSelectionIndex();
        this.setInitializingTabs(false);
        if (!this.getVisibleArea().isVisible()) {
            this.getVisibleArea().setVisible(true);
        }
        this.fDescription = this.getDescription(null);
        this.refreshStatus();
    }

    private void showInstanceTabsFor(ILaunchConfigurationType configType) {
        if (this.getTabType() != null && this.getTabType().equals(configType) && !(this.getTabGroup() instanceof PerspectiveTabGroup)) {
            return;
        }
        ILaunchConfigurationTabGroup group = null;
        try {
            group = this.createGroup(configType);
        }
        catch (CoreException ce) {
            DebugUIPlugin.errorDialog(this.getShell(), LaunchConfigurationsMessages.getString("LaunchConfigurationDialog.Error_19"), LaunchConfigurationsMessages.getString("LaunchConfigurationDialog.Exception_occurred_creating_launch_configuration_tabs_27"), ce);
            return;
        }
        this.showTabsFor(group);
        this.setTabGroup(group);
        this.setTabType(configType);
        this.fDescription = this.getDescription(configType);
    }

    private String getDescription(ILaunchConfigurationType configType) {
        String description = null;
        if (configType != null) {
            String mode = this.fDialog.getMode();
            LaunchConfigurationPresentationManager manager = LaunchConfigurationPresentationManager.getDefault();
            LaunchConfigurationTabGroupExtension extension = manager.getExtension(configType.getAttribute("id"), mode);
            description = extension.getDescription(mode);
        }
        if (description == null) {
            description = "";
        }
        return description;
    }

    private void showSharedTabsFor(ILaunchConfigurationType configType) {
        if (this.getTabType() != null && this.getTabType().equals(configType) && this.getTabGroup() instanceof PerspectiveTabGroup) {
            return;
        }
        PerspectiveTabGroup group = new PerspectiveTabGroup(configType);
        group.createTabs(this.getLaunchConfigurationDialog(), this.getLaunchConfigurationDialog().getMode());
        ILaunchConfigurationTab[] tabs = group.getTabs();
        int i = 0;
        while (i < tabs.length) {
            tabs[i].setLaunchConfigurationDialog(this.getLaunchConfigurationDialog());
            ++i;
        }
        this.showTabsFor(group);
        this.setTabType(configType);
        this.setTabGroup(group);
    }

    private void showTabsFor(ILaunchConfigurationTabGroup tabGroup) {
        this.setRedraw(false);
        this.disposeExistingTabs();
        this.setTabGroup(tabGroup);
        ILaunchConfigurationTab[] tabs = tabGroup.getTabs();
        int i = 0;
        while (i < tabs.length) {
            TabItem tab = new TabItem(this.getTabFolder(), 0);
            String name = tabs[i].getName();
            if (name == null) {
                name = LaunchConfigurationsMessages.getString("LaunchConfigurationDialog.unspecified_28");
            }
            tab.setText(name);
            Image image = tabs[i].getImage();
            tab.setImage(image);
            tabs[i].createControl((Composite)tab.getParent());
            Control control = tabs[i].getControl();
            if (control != null) {
                tab.setControl(control);
            }
            ++i;
        }
    }

    protected ILaunchConfigurationTabGroup createGroup(final ILaunchConfigurationType configType) throws CoreException {
        final Object[] finalArray = new Object[2];
        Runnable runnable = new Runnable(){

            public void run() {
                ILaunchConfigurationTabGroup tabGroup = null;
                try {
                    tabGroup = LaunchConfigurationPresentationManager.getDefault().getTabGroup(configType, LaunchConfigurationTabGroupViewer.this.getLaunchConfigurationDialog().getMode());
                    finalArray[0] = tabGroup;
                }
                catch (CoreException ce) {
                    finalArray[1] = ce;
                    return;
                }
                tabGroup.createTabs(LaunchConfigurationTabGroupViewer.this.getLaunchConfigurationDialog(), LaunchConfigurationTabGroupViewer.this.getLaunchConfigurationDialog().getMode());
                ILaunchConfigurationTab[] tabs = tabGroup.getTabs();
                int i = 0;
                while (i < tabs.length) {
                    tabs[i].setLaunchConfigurationDialog(LaunchConfigurationTabGroupViewer.this.getLaunchConfigurationDialog());
                    ++i;
                }
            }
        };
        BusyIndicator.showWhile((Display)this.getControl().getDisplay(), (Runnable)runnable);
        if (finalArray[1] != null) {
            throw (CoreException)((Object)finalArray[1]);
        }
        return (ILaunchConfigurationTabGroup)finalArray[0];
    }

    public void setSelection(ISelection selection, boolean reveal) {
        IStructuredSelection structuredSelection;
        Object object;
        if (this.getWorkingCopy() != null && selection instanceof IStructuredSelection && (object = (structuredSelection = (IStructuredSelection)selection).getFirstElement()) instanceof ILaunchConfigurationTab) {
            ILaunchConfigurationTab[] tabs = this.getTabs();
            int i = 0;
            if (i < tabs.length) {
                ILaunchConfigurationTab tab = tabs[i];
                if (tab.equals(object)) {
                    this.fCurrentTabIndex = i;
                    this.getTabFolder().setSelection(i);
                }
                return;
            }
        }
    }

    public ILaunchConfigurationTab[] getTabs() {
        if (this.getTabGroup() != null) {
            return this.getTabGroup().getTabs();
        }
        return null;
    }

    public ILaunchConfigurationTab getActiveTab() {
        int pageIndex;
        TabFolder folder = this.getTabFolder();
        ILaunchConfigurationTab[] tabs = this.getTabs();
        if (folder != null && tabs != null && (pageIndex = folder.getSelectionIndex()) >= 0) {
            return tabs[pageIndex];
        }
        return null;
    }

    public boolean isDirty() {
        ILaunchConfigurationWorkingCopy workingCopy = this.getWorkingCopy();
        if (workingCopy == null) {
            return false;
        }
        if (workingCopy.getOriginal() == null) {
            return true;
        }
        ILaunchConfiguration original = this.getOriginal();
        return !original.contentsEqual((ILaunchConfiguration)workingCopy);
    }

    protected void refreshStatus() {
        if (!this.isInitializingTabs()) {
            this.getLaunchConfigurationDialog().updateButtons();
            this.getLaunchConfigurationDialog().updateMessage();
        }
    }

    protected ILaunchConfigurationDialog getLaunchConfigurationDialog() {
        return this.fDialog;
    }

    private void setOriginal(ILaunchConfiguration configuration) {
        this.fOriginal = configuration;
    }

    protected ILaunchConfiguration getOriginal() {
        return this.fOriginal;
    }

    private void setWorkingCopy(ILaunchConfigurationWorkingCopy workingCopy) {
        this.fWorkingCopy = workingCopy;
    }

    protected ILaunchConfigurationWorkingCopy getWorkingCopy() {
        return this.fWorkingCopy;
    }

    public boolean canSave() {
        if (this.isInitializingTabs()) {
            return false;
        }
        try {
            this.verifyName();
        }
        catch (CoreException coreException) {
            return false;
        }
        ILaunchConfigurationTab[] tabs = this.getTabs();
        if (tabs == null) {
            return false;
        }
        int i = 0;
        while (i < tabs.length) {
            if (!tabs[i].canSave()) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean canLaunch() {
        if (this.isInitializingTabs()) {
            return false;
        }
        if (this.getActiveTab() instanceof PerspectivesTab) {
            return false;
        }
        if (this.getWorkingCopy() == null) {
            return false;
        }
        try {
            this.verifyName();
        }
        catch (CoreException coreException) {
            return false;
        }
        ILaunchConfigurationTab[] tabs = this.getTabs();
        if (tabs == null) {
            return false;
        }
        int i = 0;
        while (i < tabs.length) {
            if (!tabs[i].isValid((ILaunchConfiguration)this.getWorkingCopy())) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public String getErrorMesssage() {
        if (this.isInitializingTabs()) {
            return null;
        }
        if (this.getWorkingCopy() == null) {
            return null;
        }
        try {
            this.verifyName();
        }
        catch (CoreException ce) {
            return ce.getStatus().getMessage();
        }
        String message = null;
        ILaunchConfigurationTab activeTab = this.getActiveTab();
        if (activeTab == null) {
            return null;
        }
        message = activeTab.getErrorMessage();
        if (message != null) {
            return message;
        }
        ILaunchConfigurationTab[] allTabs = this.getTabs();
        int i = 0;
        while (i < allTabs.length) {
            ILaunchConfigurationTab tab = allTabs[i];
            if (tab != activeTab && (message = tab.getErrorMessage()) != null) {
                StringBuffer temp = new StringBuffer();
                temp.append('[');
                temp.append(this.removeAmpersandsFrom(tab.getName()));
                temp.append("]: ");
                temp.append(message);
                return temp.toString();
            }
            ++i;
        }
        return null;
    }

    private String removeAmpersandsFrom(String string) {
        String newString = new String(string);
        int index = newString.indexOf(38);
        while (index != -1) {
            newString = String.valueOf(string.substring(0, index)) + newString.substring(index + 1, newString.length());
            index = newString.indexOf(38);
        }
        return newString;
    }

    public String getMessage() {
        String tabMessage;
        if (this.isInitializingTabs()) {
            return null;
        }
        String message = this.fDescription;
        ILaunchConfigurationTab tab = this.getActiveTab();
        if (tab != null && (tabMessage = tab.getMessage()) != null) {
            message = tabMessage;
        }
        return message;
    }

    protected void verifyName() throws CoreException {
        if (this.fNameWidget.isVisible()) {
            String currentName = this.getNameWidget().getText().trim();
            if (currentName.length() < 1) {
                throw new CoreException((IStatus)new Status(4, DebugUIPlugin.getUniqueIdentifier(), 0, LaunchConfigurationsMessages.getString("LaunchConfigurationDialog.Name_required_for_launch_configuration_11"), null));
            }
            IStatus status = ResourcesPlugin.getWorkspace().validateName(currentName, 1);
            if (status.getCode() != 0) {
                throw new CoreException((IStatus)new Status(4, DebugUIPlugin.getUniqueIdentifier(), 0, status.getMessage(), null));
            }
            if (!this.getOriginal().getName().equals(currentName) && this.getLaunchManager().isExistingLaunchConfigurationName(currentName)) {
                throw new CoreException((IStatus)new Status(4, DebugUIPlugin.getUniqueIdentifier(), 0, LaunchConfigurationsMessages.getString("LaunchConfigurationDialog.Launch_configuration_already_exists_with_this_name_12"), null));
            }
        }
    }

    private void setDisposingTabs(boolean disposing) {
        this.fDisposingTabs = disposing;
    }

    private boolean isDisposingTabs() {
        return this.fDisposingTabs;
    }

    private void setInitializingTabs(boolean initializing) {
        this.fInitializingTabs = initializing;
    }

    private boolean isInitializingTabs() {
        return this.fInitializingTabs;
    }

    private void disposeExistingTabs() {
        this.setDisposingTabs(true);
        TabItem[] oldTabs = this.getTabFolder().getItems();
        int i = 0;
        while (i < oldTabs.length) {
            oldTabs[i].dispose();
            ++i;
        }
        this.createTabFolder(this.fTabComposite);
        this.disposeTabGroup();
        this.setDisposingTabs(false);
    }

    private ILaunchManager getLaunchManager() {
        return DebugPlugin.getDefault().getLaunchManager();
    }

    private ILaunchConfigurationType getTabType() {
        return this.fTabType;
    }

    private void setTabType(ILaunchConfigurationType tabType) {
        this.fTabType = tabType;
    }

    private void setTabGroup(ILaunchConfigurationTabGroup group) {
        this.fTabGroup = group;
    }

    public ILaunchConfigurationTabGroup getTabGroup() {
        return this.fTabGroup;
    }

    protected void handleTabSelected() {
        if (this.isDisposingTabs()) {
            return;
        }
        ILaunchConfigurationTab[] tabs = this.getTabs();
        if (this.fCurrentTabIndex == this.getTabFolder().getSelectionIndex() || tabs == null || tabs.length == 0 || this.fCurrentTabIndex > tabs.length - 1) {
            return;
        }
        if (this.fCurrentTabIndex != -1) {
            ILaunchConfigurationTab tab = tabs[this.fCurrentTabIndex];
            ILaunchConfigurationWorkingCopy wc = this.getWorkingCopy();
            if (wc != null) {
                tab.deactivated(wc);
                this.getActiveTab().activated(wc);
            }
        }
        this.fCurrentTabIndex = this.getTabFolder().getSelectionIndex();
        SelectionChangedEvent event = new SelectionChangedEvent((ISelectionProvider)this, this.getSelection());
        this.fireSelectionChanged(event);
    }

    protected void handleNameModified() {
        this.getWorkingCopy().rename(this.getNameWidget().getText().trim());
        this.refreshStatus();
    }

    protected void handleApplyPressed() {
        try {
            Text widget = this.getNameWidget();
            String name = widget.getText();
            String trimmed = name.trim();
            this.setInitializingTabs(true);
            if (!name.equals(trimmed)) {
                widget.setText(trimmed);
            }
            this.getWorkingCopy().rename(trimmed);
            this.getTabGroup().performApply(this.getWorkingCopy());
            this.setInitializingTabs(false);
            if (this.isDirty()) {
                this.getWorkingCopy().doSave();
            }
            this.updateButtons();
        }
        catch (CoreException e) {
            DebugUIPlugin.errorDialog(this.getShell(), LaunchConfigurationsMessages.getString("LaunchConfigurationDialog.Launch_Configuration_Error_46"), LaunchConfigurationsMessages.getString("LaunchConfigurationDialog.Exception_occurred_while_saving_launch_configuration_47"), e);
            return;
        }
    }

    protected void handleRevertPressed() {
        if (this.getActiveTab() instanceof PerspectivesTab) {
            this.inputChanged(this.getTabType());
        } else {
            this.inputChanged(this.getOriginal());
        }
    }

    protected void errorDialog(CoreException exception) {
        ErrorDialog.openError((Shell)this.getShell(), null, null, (IStatus)exception.getStatus());
    }

    protected void setVisibleArea(Composite control) {
        this.fVisibleArea = control;
    }

    protected Composite getVisibleArea() {
        return this.fVisibleArea;
    }

    public void setActiveTab(ILaunchConfigurationTab tab) {
        ILaunchConfigurationTab[] tabs = this.getTabs();
        int i = 0;
        while (i < tabs.length) {
            ILaunchConfigurationTab configurationTab = tabs[i];
            if (configurationTab.equals(tab)) {
                this.setActiveTab(i);
                return;
            }
            ++i;
        }
    }

    public void setActiveTab(int index) {
        ILaunchConfigurationTab[] tabs = this.getTabs();
        if (index >= 0 && index < tabs.length) {
            this.getTabFolder().setSelection(index);
            this.handleTabSelected();
        }
    }
}

