/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ant.internal.ui.launchConfigurations;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.ant.internal.ui.editor.model.AntElementNode;
import org.eclipse.ant.internal.ui.editor.model.AntProjectNode;
import org.eclipse.ant.internal.ui.editor.model.AntTargetNode;
import org.eclipse.ant.internal.ui.launchConfigurations.AntJRETab;
import org.eclipse.ant.internal.ui.launchConfigurations.AntLaunchConfigurationMessages;
import org.eclipse.ant.internal.ui.model.AntUIPlugin;
import org.eclipse.ant.internal.ui.model.AntUtil;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.ui.CommonTab;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.IDebugModelPresentation;
import org.eclipse.debug.ui.ILaunchShortcut;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.ui.editors.text.ILocationProvider;
import org.eclipse.ui.externaltools.internal.launchConfigurations.ExternalToolsUtil;

public class AntLaunchShortcut
implements ILaunchShortcut {
    private boolean fShowDialog = false;
    private static final int MAX_TARGET_APPEND_LENGTH = 30;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public void launch(ISelection selection, String mode) {
        IStructuredSelection structuredSelection;
        Object object;
        if (selection instanceof IStructuredSelection && (object = (structuredSelection = (IStructuredSelection)selection).getFirstElement()) instanceof IAdaptable) {
            IResource resource;
            IAdaptable iAdaptable = (IAdaptable)object;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.core.resources.IResource");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((resource = (IResource)iAdaptable.getAdapter((Class)clazz)) != null) {
                this.launch(resource, mode);
                return;
            }
            if (object instanceof AntElementNode) {
                this.launch((AntElementNode)object);
                return;
            }
        }
        this.antFileNotFound();
    }

    public void launch(AntElementNode node) {
        String selectedTarget = null;
        if (node instanceof AntTargetNode) {
            AntTargetNode targetNode = (AntTargetNode)node;
            selectedTarget = targetNode.isDefaultTarget() ? "" : targetNode.getTarget().getName();
        } else if (node instanceof AntProjectNode) {
            selectedTarget = "";
        }
        if (selectedTarget == null) {
            return;
        }
        IFile file = node.getBuildFileResource();
        if (file != null) {
            this.launch(file, "run", selectedTarget);
            return;
        }
        IPath filePath = this.getExternalBuildFilePath();
        if (filePath != null) {
            this.launch(filePath, "run", selectedTarget);
            return;
        }
        this.antFileNotFound();
    }

    private IPath getExternalBuildFilePath() {
        IWorkbenchPage page = AntUIPlugin.getActiveWorkbenchWindow().getActivePage();
        IEditorInput editorInput = page.getActiveEditor().getEditorInput();
        IPath filePath = null;
        if (editorInput instanceof ILocationProvider) {
            filePath = ((ILocationProvider)editorInput).getPath((Object)editorInput);
        }
        return filePath;
    }

    private void antFileNotFound() {
        AntLaunchShortcut.reportError(AntLaunchConfigurationMessages.getString("AntLaunchShortcut.Unable"), null);
    }

    protected void launch(IResource resource, String mode) {
        if (!"xml".equalsIgnoreCase(resource.getFileExtension())) {
            if (resource.getType() == 1) {
                resource = resource.getParent();
            }
            resource = this.findBuildFile((IContainer)resource);
        }
        if (resource != null) {
            this.launch((IFile)resource, mode, null);
        } else {
            this.antFileNotFound();
        }
    }

    public void launch(IFile file, String mode, String targetAttribute) {
        ILaunchConfiguration configuration;
        block15: {
            configuration = null;
            if (this.verifyMode(mode)) {
                List configurations = AntLaunchShortcut.findExistingLaunchConfigurations(file);
                if (configurations.isEmpty()) {
                    configuration = AntLaunchShortcut.createDefaultLaunchConfiguration(file);
                } else if (configurations.size() == 1) {
                    configuration = (ILaunchConfiguration)configurations.get(0);
                } else {
                    configuration = AntLaunchShortcut.chooseConfig(configurations);
                    if (configuration == null) {
                        return;
                    }
                }
            }
            if (configuration == null) {
                this.antFileNotFound();
            }
            try {
                if (targetAttribute == null || targetAttribute.equals(configuration.getAttribute("org.eclipse.ui.externaltools.ATTR_ANT_TARGETS", ""))) break block15;
                String projectName = null;
                try {
                    projectName = configuration.getAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, null);
                }
                catch (CoreException coreException) {}
                String newName = AntLaunchShortcut.getNewLaunchConfigurationName(file.getFullPath(), projectName, targetAttribute);
                configuration = configuration.copy(newName);
                ((ILaunchConfigurationWorkingCopy)configuration).setAttribute("org.eclipse.ui.externaltools.ATTR_ANT_TARGETS", targetAttribute);
                if (this.fShowDialog) {
                    configuration = ((ILaunchConfigurationWorkingCopy)configuration).doSave();
                }
            }
            catch (CoreException exception) {
                AntLaunchShortcut.reportError(MessageFormat.format(AntLaunchConfigurationMessages.getString("AntLaunchShortcut.Exception_launching"), file.getName()), exception);
                return;
            }
        }
        if (this.fShowDialog) {
            if (!DebugUITools.saveBeforeLaunch()) {
                return;
            }
            Status status = new Status(1, "org.eclipse.ant.ui", 1000, "", null);
            DebugUITools.openLaunchConfigurationDialog((Shell)AntUIPlugin.getActiveWorkbenchWindow().getShell(), (ILaunchConfiguration)configuration, (String)"org.eclipse.ui.externaltools.launchGroup", (IStatus)status);
        } else {
            DebugUITools.launch((ILaunchConfiguration)configuration, (String)mode);
        }
    }

    public static String getNewLaunchConfigurationName(IPath filePath, String projectName, String targetAttribute) {
        StringBuffer buffer = new StringBuffer();
        if (projectName != null) {
            buffer.append(projectName);
            buffer.append(' ');
            buffer.append(filePath.lastSegment());
        } else {
            buffer.append(filePath.toOSString());
        }
        if (targetAttribute != null) {
            buffer.append(" [");
            if (targetAttribute.length() > 33) {
                buffer.append(targetAttribute.substring(0, 30));
                buffer.append("...");
            } else {
                buffer.append(targetAttribute);
            }
            buffer.append(']');
        }
        String name = DebugPlugin.getDefault().getLaunchManager().generateUniqueLaunchConfigurationNameFrom(buffer.toString());
        return name.toString();
    }

    public void launch(IPath filePath, String mode, String targetAttribute) {
        ILaunchConfiguration configuration;
        block15: {
            configuration = null;
            if (this.verifyMode(mode)) {
                List configurations = AntLaunchShortcut.findExistingLaunchConfigurations(filePath);
                if (configurations.isEmpty()) {
                    configuration = AntLaunchShortcut.createDefaultLaunchConfiguration(filePath, null);
                } else if (configurations.size() == 1) {
                    configuration = (ILaunchConfiguration)configurations.get(0);
                } else {
                    configuration = AntLaunchShortcut.chooseConfig(configurations);
                    if (configuration == null) {
                        return;
                    }
                }
            }
            if (configuration == null) {
                this.antFileNotFound();
            }
            try {
                if (targetAttribute == null || targetAttribute.equals(configuration.getAttribute("org.eclipse.ui.externaltools.ATTR_ANT_TARGETS", ""))) break block15;
                String projectName = null;
                try {
                    projectName = configuration.getAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, null);
                }
                catch (CoreException coreException) {}
                String newName = AntLaunchShortcut.getNewLaunchConfigurationName(filePath, projectName, targetAttribute);
                configuration = configuration.copy(newName);
                ((ILaunchConfigurationWorkingCopy)configuration).setAttribute("org.eclipse.ui.externaltools.ATTR_ANT_TARGETS", targetAttribute);
                if (this.fShowDialog) {
                    configuration = ((ILaunchConfigurationWorkingCopy)configuration).doSave();
                }
            }
            catch (CoreException exception) {
                AntLaunchShortcut.reportError(MessageFormat.format(AntLaunchConfigurationMessages.getString("AntLaunchShortcut.Exception_launching"), filePath.toFile().getName()), exception);
                return;
            }
        }
        if (this.fShowDialog) {
            if (!DebugUITools.saveBeforeLaunch()) {
                return;
            }
            Status status = new Status(1, "org.eclipse.ant.ui", 1000, "", null);
            DebugUITools.openLaunchConfigurationDialog((Shell)AntUIPlugin.getActiveWorkbenchWindow().getShell(), (ILaunchConfiguration)configuration, (String)"org.eclipse.ui.externaltools.launchGroup", (IStatus)status);
        } else {
            DebugUITools.launch((ILaunchConfiguration)configuration, (String)mode);
        }
    }

    private IFile findBuildFile(IContainer parent) {
        String[] names = this.getBuildFileNames();
        if (names == null) {
            return null;
        }
        IResource file = null;
        while (file == null || file.getType() != 1) {
            int i = 0;
            while (i < names.length) {
                String string = names[i];
                file = parent.findMember(string);
                if (file != null && file.getType() == 1) break;
                ++i;
            }
            parent = parent.getParent();
            if (parent != null) continue;
            return null;
        }
        return (IFile)file;
    }

    private String[] getBuildFileNames() {
        IPreferenceStore prefs = AntUIPlugin.getDefault().getPreferenceStore();
        String buildFileNames = prefs.getString("ant.findBuildFileNames");
        if (buildFileNames.length() == 0) {
            return null;
        }
        return AntUtil.parseString(buildFileNames, ",");
    }

    public static ILaunchConfiguration createDefaultLaunchConfiguration(IFile file) {
        return AntLaunchShortcut.createDefaultLaunchConfiguration(file.getFullPath(), file.getProject());
    }

    public static ILaunchConfiguration createDefaultLaunchConfiguration(IPath filePath, IProject project) {
        ILaunchManager manager = DebugPlugin.getDefault().getLaunchManager();
        ILaunchConfigurationType type = manager.getLaunchConfigurationType("org.eclipse.ant.AntLaunchConfigurationType");
        String projectName = project != null ? project.getName() : null;
        String name = AntLaunchShortcut.getNewLaunchConfigurationName(filePath, projectName, null);
        try {
            ILaunchConfigurationWorkingCopy workingCopy = type.newInstance(null, name);
            if (project != null) {
                workingCopy.setAttribute("org.eclipse.ui.externaltools.ATTR_LOCATION", VariablesPlugin.getDefault().getStringVariableManager().generateVariableExpression("workspace_loc", filePath.toString()));
            } else {
                workingCopy.setAttribute("org.eclipse.ui.externaltools.ATTR_LOCATION", filePath.toString());
            }
            workingCopy.setAttribute(IJavaLaunchConfigurationConstants.ATTR_CLASSPATH_PROVIDER, "org.eclipse.ant.ui.AntClasspathProvider");
            CommonTab tab = new CommonTab();
            tab.setDefaults(workingCopy);
            tab.dispose();
            if (project != null) {
                workingCopy.setAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, project.getName());
            }
            AntJRETab jreTab = new AntJRETab();
            jreTab.setDefaults(workingCopy);
            jreTab.dispose();
            return workingCopy.doSave();
        }
        catch (CoreException e) {
            AntLaunchShortcut.reportError(MessageFormat.format(AntLaunchConfigurationMessages.getString("AntLaunchShortcut.2"), filePath.toString()), e);
            return null;
        }
    }

    public static List findExistingLaunchConfigurations(IFile file) {
        IPath filePath = file.getLocation();
        return AntLaunchShortcut.findExistingLaunchConfigurations(filePath);
    }

    public static List findExistingLaunchConfigurations(IPath filePath) {
        ILaunchManager manager = DebugPlugin.getDefault().getLaunchManager();
        ILaunchConfigurationType type = manager.getLaunchConfigurationType("org.eclipse.ant.AntLaunchConfigurationType");
        ArrayList<ILaunchConfiguration> validConfigs = new ArrayList<ILaunchConfiguration>();
        if (type != null) {
            ILaunchConfiguration[] configs = null;
            try {
                configs = manager.getLaunchConfigurations(type);
            }
            catch (CoreException e) {
                AntLaunchShortcut.reportError(AntLaunchConfigurationMessages.getString("AntLaunchShortcut.3"), e);
            }
            if (configs != null && configs.length > 0) {
                if (filePath == null) {
                    AntLaunchShortcut.reportError(AntLaunchConfigurationMessages.getString("AntLaunchShortcut.0"), null);
                } else {
                    int i = 0;
                    while (i < configs.length) {
                        ILaunchConfiguration configuration = configs[i];
                        try {
                            IPath location = ExternalToolsUtil.getLocation((ILaunchConfiguration)configuration);
                            if (filePath.equals((Object)location)) {
                                validConfigs.add(configuration);
                            }
                        }
                        catch (CoreException coreException) {}
                        ++i;
                    }
                }
            }
        }
        return validConfigs;
    }

    public static ILaunchConfiguration chooseConfig(List configs) {
        if (configs.isEmpty()) {
            return null;
        }
        IDebugModelPresentation labelProvider = DebugUITools.newDebugModelPresentation();
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(Display.getDefault().getActiveShell(), (ILabelProvider)labelProvider);
        dialog.setElements((Object[])configs.toArray(new ILaunchConfiguration[configs.size()]));
        dialog.setTitle(AntLaunchConfigurationMessages.getString("AntLaunchShortcut.4"));
        dialog.setMessage(AntLaunchConfigurationMessages.getString("AntLaunchShortcut.5"));
        dialog.setMultipleSelection(false);
        int result = dialog.open();
        labelProvider.dispose();
        if (result == 0) {
            return (ILaunchConfiguration)dialog.getFirstResult();
        }
        return null;
    }

    protected boolean verifyMode(String mode) {
        if (!mode.equals("run")) {
            AntLaunchShortcut.reportError(AntLaunchConfigurationMessages.getString("AntLaunchShortcut.6"), null);
            return false;
        }
        return true;
    }

    public void launch(IEditorPart editor, String mode) {
        IPath filePath;
        IFile file;
        IEditorInput input = editor.getEditorInput();
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.core.resources.IFile");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((file = (IFile)input.getAdapter((Class)clazz)) != null) {
            this.launch((IResource)file, mode);
            return;
        }
        if (input instanceof ILocationProvider && "xml".equals((filePath = ((ILocationProvider)input).getPath((Object)input)).getFileExtension())) {
            this.launch(filePath, mode, null);
            return;
        }
        this.antFileNotFound();
    }

    protected static void reportError(String message, Throwable throwable) {
        Object status = null;
        status = throwable instanceof CoreException ? ((CoreException)throwable).getStatus() : new Status(4, "org.eclipse.ant.ui", 0, message, throwable);
        ErrorDialog.openError((Shell)AntUIPlugin.getActiveWorkbenchWindow().getShell(), (String)AntLaunchConfigurationMessages.getString("AntLaunchShortcut.Error_7"), (String)AntLaunchConfigurationMessages.getString("AntLaunchShortcut.Build_Failed_2"), (IStatus)status);
    }

    public void setShowDialog(boolean showDialog) {
        this.fShowDialog = showDialog;
    }
}

