/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.ssh;

import com.jcraft.jsch.Channel;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.tools.ant.taskdefs.optional.ssh.AbstractSshMessage;

public class ScpFromMessage
extends AbstractSshMessage {
    private final byte LINE_FEED = (byte)10;
    private final int BUFFER_SIZE = 1024;
    private String remoteFile;
    private File localFile;
    private boolean isRecursive = false;

    public ScpFromMessage(boolean verbose, Session session, String aRemoteFile, File aLocalFile, boolean recursive) {
        super(verbose, session);
        this.remoteFile = aRemoteFile;
        this.localFile = aLocalFile;
        this.isRecursive = recursive;
    }

    public ScpFromMessage(Session session, String aRemoteFile, File aLocalFile, boolean recursive) {
        this(false, session, aRemoteFile, aLocalFile, recursive);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void execute() throws IOException, JSchException {
        block4: {
            String command = "scp -f ";
            if (this.isRecursive) {
                command = command + "-r ";
            }
            command = command + this.remoteFile;
            Channel channel = this.openExecChannel(command);
            try {
                OutputStream out = channel.getOutputStream();
                InputStream in = channel.getInputStream();
                channel.connect();
                this.sendAck(out);
                this.startRemoteCpProtocol(in, out, this.localFile);
                Object var6_5 = null;
                if (channel == null) break block4;
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                if (channel != null) {
                    channel.disconnect();
                }
                throw throwable;
            }
            channel.disconnect();
        }
        this.log("done\n");
    }

    private void startRemoteCpProtocol(InputStream in, OutputStream out, File localFile) throws IOException {
        String serverResponse;
        File startFile = localFile;
        while (true) {
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            while (true) {
                int read;
                if ((read = in.read()) < 0) {
                    return;
                }
                if ((byte)read == 10) break;
                stream.write(read);
            }
            serverResponse = stream.toString("UTF-8");
            if (serverResponse.charAt(0) == 'C') {
                this.parseAndFetchFile(serverResponse, startFile, out, in);
                continue;
            }
            if (serverResponse.charAt(0) == 'D') {
                startFile = this.parseAndCreateDirectory(serverResponse, startFile);
                this.sendAck(out);
                continue;
            }
            if (serverResponse.charAt(0) == 'E') {
                startFile = startFile.getParentFile();
                this.sendAck(out);
                continue;
            }
            if (serverResponse.charAt(0) == '\u0001' || serverResponse.charAt(0) == '\u0002') break;
        }
        throw new IOException(serverResponse.substring(1));
    }

    private File parseAndCreateDirectory(String serverResponse, File localFile) {
        int start = serverResponse.indexOf(" ");
        start = serverResponse.indexOf(" ", start + 1);
        String directoryName = serverResponse.substring(start + 1);
        if (localFile.isDirectory()) {
            File dir = new File(localFile, directoryName);
            dir.mkdir();
            this.log("Creating: " + dir);
            return dir;
        }
        return null;
    }

    private void parseAndFetchFile(String serverResponse, File localFile, OutputStream out, InputStream in) throws IOException {
        int start = 0;
        int end = serverResponse.indexOf(" ", start + 1);
        String command = serverResponse.substring(start, end);
        start = end + 1;
        end = serverResponse.indexOf(" ", start + 1);
        int filesize = Integer.parseInt(serverResponse.substring(start, end));
        String filename = serverResponse.substring(end + 1);
        this.log("Receiving: " + filename + " : " + filesize);
        File transferFile = localFile.isDirectory() ? new File(localFile, filename) : localFile;
        this.fetchFile(transferFile, filesize, out, in);
        this.waitForAck(in);
        this.sendAck(out);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fetchFile(File localFile, int filesize, OutputStream out, InputStream in) throws IOException {
        byte[] buf = new byte[1024];
        this.sendAck(out);
        FileOutputStream fos = new FileOutputStream(localFile);
        int totalLength = 0;
        long startTime = System.currentTimeMillis();
        boolean trackProgress = this.getVerbose() && filesize > 102400;
        int initFilesize = filesize;
        int percentTransmitted = 0;
        try {
            while (true) {
                int length;
                if ((length = in.read(buf, 0, buf.length < filesize ? buf.length : filesize)) < 0) {
                    throw new EOFException("Unexpected end of stream.");
                }
                fos.write(buf, 0, length);
                totalLength += length;
                if ((filesize -= length) == 0) break;
                if (!trackProgress) continue;
                percentTransmitted = this.trackProgress(initFilesize, totalLength, percentTransmitted);
            }
            Object var15_13 = null;
        }
        catch (Throwable throwable) {
            Object var15_14 = null;
            long endTime = System.currentTimeMillis();
            this.logStats(startTime, endTime, totalLength);
            fos.flush();
            fos.close();
            throw throwable;
        }
        long endTime = System.currentTimeMillis();
        this.logStats(startTime, endTime, totalLength);
        fos.flush();
        fos.close();
    }
}

