/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.dependencies;

import org.eclipse.core.internal.dependencies.Assert;
import org.eclipse.core.internal.dependencies.Dependency;
import org.eclipse.core.internal.dependencies.IMatchRule;

public class Element {
    private static final String UNRESOLVABLE_PREREQUISITE = "<UNRESOLVABLE PREREQUISITE>";
    private Object id;
    private Object versionId;
    private Dependency[] dependencies;
    private boolean singleton;
    private Object userObject;

    public Element(Object id, Object versionId, Dependency[] dependencies, boolean singleton, Object userObject) {
        Assert.isNotNull(id);
        Assert.isNotNull(versionId);
        Assert.isNotNull(dependencies);
        this.id = id;
        this.versionId = versionId;
        this.dependencies = dependencies;
        this.singleton = singleton;
        this.userObject = userObject;
    }

    public Object getId() {
        return this.id;
    }

    public Object getVersionId() {
        return this.versionId;
    }

    public Dependency[] getDependencies() {
        return this.dependencies;
    }

    public Dependency getDependency(Object id) {
        int i = 0;
        while (i < this.dependencies.length) {
            if (this.dependencies[i].getRequiredObjectId().equals(id)) {
                return this.dependencies[i];
            }
            ++i;
        }
        return null;
    }

    public boolean isSingleton() {
        return this.singleton;
    }

    public Object getUserObject() {
        return this.userObject;
    }

    public String toString() {
        return this.id + "_" + this.versionId;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Element)) {
            return false;
        }
        Element other = (Element)obj;
        return other.userObject != null && other.userObject.equals(this.userObject) || this.id.equals(other.id) && this.versionId.equals(other.versionId) && other.userObject == null && this.userObject == null;
    }

    public int hashCode() {
        return this.id.hashCode() << 16 | this.versionId.hashCode() & 0xFFFF;
    }

    public void removeFromCycle() {
        this.dependencies = new Dependency[]{new Dependency(UNRESOLVABLE_PREREQUISITE, new UnsatisfiableRule(), false, null)};
    }

    private static final class UnsatisfiableRule
    implements IMatchRule {
        UnsatisfiableRule() {
        }

        public boolean isSatisfied(Object required, Object available) {
            return false;
        }

        public String toString() {
            return "unsatisfiable";
        }
    }
}

