/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui.wizards;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.internal.ccvs.core.ICVSFolder;
import org.eclipse.team.internal.ccvs.core.ICVSRepositoryLocation;
import org.eclipse.team.internal.ccvs.core.connection.CVSRepositoryLocation;
import org.eclipse.team.internal.ccvs.core.resources.CVSWorkspaceRoot;
import org.eclipse.team.internal.ccvs.core.syncinfo.FolderSyncInfo;
import org.eclipse.team.internal.ccvs.ui.CVSUIPlugin;
import org.eclipse.team.internal.ccvs.ui.Policy;
import org.eclipse.team.internal.ccvs.ui.wizards.CVSWizardPage;
import org.eclipse.ui.help.WorkbenchHelp;

public class ConfigurationWizardAutoconnectPage
extends CVSWizardPage {
    private boolean validate = true;
    private FolderSyncInfo info;
    ICVSRepositoryLocation location;

    public ConfigurationWizardAutoconnectPage(String pageName, String title, ImageDescriptor titleImage) {
        super(pageName, title, titleImage);
    }

    public void createControl(Composite parent) {
        Composite composite = this.createComposite(parent, 2);
        this.setControl((Control)composite);
        WorkbenchHelp.setHelp((Control)composite, (String)"org.eclipse.team.cvs.ui.sharing_autoconnect_page_context");
        Label description = new Label(composite, 64);
        GridData data = new GridData();
        data.horizontalSpan = 2;
        data.widthHint = 350;
        description.setLayoutData((Object)data);
        description.setText(Policy.bind("ConfigurationWizardAutoconnectPage.description"));
        if (this.location == null) {
            return;
        }
        CVSWizardPage.createLabel(composite, "");
        CVSWizardPage.createLabel(composite, "");
        CVSWizardPage.createLabel(composite, Policy.bind("ConfigurationWizardAutoconnectPage.user"));
        CVSWizardPage.createLabel(composite, this.location.getUsername());
        CVSWizardPage.createLabel(composite, Policy.bind("ConfigurationWizardAutoconnectPage.host"));
        CVSWizardPage.createLabel(composite, this.location.getHost());
        CVSWizardPage.createLabel(composite, Policy.bind("ConfigurationWizardAutoconnectPage.port"));
        int port = this.location.getPort();
        if (port == 0) {
            CVSWizardPage.createLabel(composite, Policy.bind("ConfigurationWizardAutoconnectPage.default"));
        } else {
            CVSWizardPage.createLabel(composite, "" + port);
        }
        CVSWizardPage.createLabel(composite, Policy.bind("ConfigurationWizardAutoconnectPage.connectionType"));
        CVSWizardPage.createLabel(composite, this.location.getMethod().getName());
        CVSWizardPage.createLabel(composite, Policy.bind("ConfigurationWizardAutoconnectPage.repositoryPath"));
        CVSWizardPage.createLabel(composite, this.location.getRootDirectory());
        CVSWizardPage.createLabel(composite, Policy.bind("ConfigurationWizardAutoconnectPage.module"));
        CVSWizardPage.createLabel(composite, this.info.getRepository());
        CVSWizardPage.createLabel(composite, "");
        CVSWizardPage.createLabel(composite, "");
        final Button check = new Button(composite, 32);
        data = new GridData();
        data.horizontalSpan = 2;
        check.setText(Policy.bind("ConfigurationWizardAutoconnectPage.validate"));
        check.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                ConfigurationWizardAutoconnectPage.this.validate = check.getSelection();
            }
        });
        check.setSelection(true);
        Dialog.applyDialogFont((Control)parent);
    }

    public FolderSyncInfo getFolderSyncInfo() {
        return this.info;
    }

    public boolean getValidate() {
        return this.validate;
    }

    public void setProject(IProject project) {
        try {
            ICVSFolder folder = (ICVSFolder)CVSWorkspaceRoot.getCVSResourceFor((IResource)project);
            this.info = folder.getFolderSyncInfo();
            if (this.info == null) {
                CVSUIPlugin.openError(null, Policy.bind("ConfigurationWizardAutoconnectPage.noSyncInfo"), Policy.bind("ConfigurationWizardAutoconnectPage.noCVSDirectory"), null);
                return;
            }
            this.location = CVSRepositoryLocation.fromString((String)this.info.getRoot());
        }
        catch (TeamException e) {
            CVSUIPlugin.openError(null, null, null, e);
        }
    }

    public FolderSyncInfo getSharing() {
        return this.info;
    }

    public ICVSRepositoryLocation getLocation() {
        return this.location;
    }
}

