/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui.actions;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.compare.CompareEditorInput;
import org.eclipse.compare.CompareUI;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.ICVSRemoteFile;
import org.eclipse.team.internal.ccvs.core.ICVSResource;
import org.eclipse.team.internal.ccvs.core.ILogEntry;
import org.eclipse.team.internal.ccvs.core.resources.CVSWorkspaceRoot;
import org.eclipse.team.internal.ccvs.ui.CVSCompareRevisionsInput;
import org.eclipse.team.internal.ccvs.ui.CVSUIPlugin;
import org.eclipse.team.internal.ccvs.ui.Policy;
import org.eclipse.team.internal.ccvs.ui.actions.WorkspaceAction;
import org.eclipse.team.ui.ISaveableWorkbenchPart;
import org.eclipse.team.ui.SaveablePartDialog;

public class CompareWithRevisionAction
extends WorkspaceAction {
    protected ICVSRemoteFile getSelectedRemoteFile() {
        IResource[] resources = this.getSelectedResources();
        if (resources.length != 1) {
            return null;
        }
        if (!(resources[0] instanceof IFile)) {
            return null;
        }
        IFile file = (IFile)resources[0];
        try {
            return (ICVSRemoteFile)CVSWorkspaceRoot.getRemoteResourceFor((IResource)file);
        }
        catch (TeamException e) {
            this.handle((Exception)((Object)e), null, null);
            return null;
        }
    }

    public void execute(IAction action) throws InvocationTargetException, InterruptedException {
        final ICVSRemoteFile[] file = new ICVSRemoteFile[1];
        final ILogEntry[][] entries = new ILogEntry[1][];
        this.run(new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException {
                file[0] = CompareWithRevisionAction.this.getSelectedRemoteFile();
            }
        }, false, 2);
        if (file[0] == null) {
            MessageDialog.openWarning((Shell)this.getShell(), (String)Policy.bind("CompareWithRevisionAction.noRevisions"), (String)Policy.bind("CompareWithRevisionAction.noRevisionsLong"));
            return;
        }
        this.run(new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException {
                try {
                    monitor.beginTask(Policy.bind("CompareWithRevisionAction.fetching"), 100);
                    entries[0] = file[0].getLogEntries(Policy.subMonitorFor(monitor, 100));
                    monitor.done();
                }
                catch (TeamException e) {
                    throw new InvocationTargetException(e);
                }
            }
        }, true, 1);
        if (entries[0] == null) {
            return;
        }
        this.run(new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InterruptedException, InvocationTargetException {
                CVSCompareRevisionsInput input = new CVSCompareRevisionsInput((IFile)CompareWithRevisionAction.this.getSelectedResources()[0], entries[0]);
                if (CVSUIPlugin.getPlugin().getPreferenceStore().getBoolean("pref_show_compare_revision_in_dialog")) {
                    input.run((IProgressMonitor)new NullProgressMonitor());
                    SaveablePartDialog cd = CompareWithRevisionAction.this.createCompareDialog(CompareWithRevisionAction.this.getShell(), input);
                    cd.setBlockOnOpen(true);
                    cd.open();
                } else {
                    CompareUI.openCompareEditor((CompareEditorInput)input);
                }
            }
        }, false, 2);
    }

    protected SaveablePartDialog createCompareDialog(Shell shell, CVSCompareRevisionsInput input) {
        return new SaveablePartDialog(shell, (ISaveableWorkbenchPart)input);
    }

    protected String getActionTitle() {
        return Policy.bind("CompareWithRevisionAction.4");
    }

    protected String getErrorTitle() {
        return Policy.bind("CompareWithRevisionAction.compare");
    }

    protected boolean isEnabledForCVSResource(ICVSResource cvsResource) throws CVSException {
        return !cvsResource.isFolder() && super.isEnabledForCVSResource(cvsResource);
    }

    protected boolean isEnabledForMultipleResources() {
        return false;
    }

    protected boolean isEnabledForAddedResources() {
        return false;
    }
}

