/*
 * Decompiled with CFR 0.152.
 */
package javax.management.openmbean;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.TabularData;

public class TabularType
extends OpenType
implements Serializable {
    private static final long serialVersionUID = 6554071860220659261L;
    private CompositeType rowType = null;
    private List indexNames = null;
    private transient int m_hashcode = 0;
    private transient String m_classDescription = null;
    static /* synthetic */ Class class$javax$management$openmbean$TabularData;

    public TabularType(String typeName, String description, CompositeType rowType, String[] indexNames) throws OpenDataException {
        super((class$javax$management$openmbean$TabularData == null ? (class$javax$management$openmbean$TabularData = TabularType.class$("javax.management.openmbean.TabularData")) : class$javax$management$openmbean$TabularData).getName(), typeName, description);
        this.validate(rowType, indexNames);
        this.rowType = rowType;
        ArrayList<String> temp = new ArrayList<String>();
        int i = 0;
        while (i < indexNames.length) {
            temp.add(indexNames[i]);
            ++i;
        }
        this.indexNames = Collections.unmodifiableList(temp);
    }

    private void validate(CompositeType rowType, String[] indexNames) throws OpenDataException {
        if (rowType == null) {
            throw new IllegalArgumentException("The CompositeType passed in cannot be null");
        }
        if (indexNames == null || indexNames.length == 0) {
            throw new IllegalArgumentException("The String[] indexNames cannot be null or empty");
        }
        int i = 0;
        while (i < indexNames.length) {
            String item = indexNames[i];
            if (item == null || item.length() == 0) {
                throw new IllegalArgumentException("An Item in the indexNames[] cannot be null or of zero length");
            }
            if (!rowType.containsKey(item)) {
                throw new OpenDataException("Element value: " + indexNames[i] + " at index: " + i + " is not a valid item name for RowType");
            }
            ++i;
        }
    }

    public CompositeType getRowType() {
        return this.rowType;
    }

    public List getIndexNames() {
        return this.indexNames;
    }

    public boolean isValue(Object object) {
        if (!(object instanceof TabularData)) {
            return false;
        }
        TabularData tabularData = (TabularData)object;
        return this.equals(tabularData.getTabularType());
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof TabularType)) {
            return false;
        }
        TabularType tabularType = (TabularType)object;
        return this.rowType.equals(tabularType.rowType) && this.indexNames.equals(tabularType.indexNames) && this.getTypeName().equals(tabularType.getTypeName());
    }

    public int hashCode() {
        if (this.m_hashcode == 0) {
            int result = 17;
            result = 37 * result + this.getTypeName().hashCode();
            result = 37 * result + this.rowType.hashCode();
            Iterator i = this.indexNames.iterator();
            while (i.hasNext()) {
                result = 37 * result + i.next().hashCode();
            }
            this.m_hashcode = result;
        }
        return this.m_hashcode;
    }

    public String toString() {
        if (this.m_classDescription == null) {
            StringBuffer classString = new StringBuffer();
            classString.append("TabularType name: ").append(this.getTypeName()).append(" rowType: ").append(this.rowType.toString()).append("indexNames: (");
            Iterator i = this.indexNames.iterator();
            while (i.hasNext()) {
                classString.append(i.next().toString()).append(", ");
            }
            classString.delete(classString.length() - 2, classString.length());
            classString.append(")");
            this.m_classDescription = classString.toString();
        }
        return this.m_classDescription;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

