/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.compare.internal;

import java.util.HashMap;
import java.util.Iterator;
import java.util.ResourceBundle;
import org.eclipse.compare.internal.MergeViewerAction;
import org.eclipse.compare.internal.Utilities;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextListener;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.TextEvent;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;

public class MergeSourceViewer
extends SourceViewer
implements ISelectionChangedListener,
ITextListener,
IMenuListener {
    public static final String UNDO_ID = "undo";
    public static final String REDO_ID = "redo";
    public static final String CUT_ID = "cut";
    public static final String COPY_ID = "copy";
    public static final String PASTE_ID = "paste";
    public static final String DELETE_ID = "delete";
    public static final String SELECT_ALL_ID = "selectAll";
    public static final String SAVE_ID = "save";
    private ResourceBundle fResourceBundle;
    private Position fRegion;
    private boolean fEnabled = true;
    private HashMap fActions = new HashMap();
    private boolean fAddSaveAction = true;

    public MergeSourceViewer(Composite parent, ResourceBundle bundle) {
        super(parent, null, 768);
        this.fResourceBundle = bundle;
        MenuManager menu = new MenuManager();
        menu.setRemoveAllWhenShown(true);
        menu.addMenuListener((IMenuListener)this);
        StyledText te = this.getTextWidget();
        te.setMenu(menu.createContextMenu((Control)te));
    }

    public void hideSaveAction() {
        this.fAddSaveAction = false;
    }

    public void setFont(Font font) {
        StyledText te = this.getTextWidget();
        if (te != null) {
            te.setFont(font);
        }
    }

    public void setBackgroundColor(Color color) {
        StyledText te = this.getTextWidget();
        if (te != null) {
            te.setBackground(color);
        }
    }

    public void setEnabled(boolean enabled) {
        if (enabled != this.fEnabled) {
            this.fEnabled = enabled;
            StyledText c = this.getTextWidget();
            if (c != null) {
                c.setEnabled(enabled);
                Display d = c.getDisplay();
                c.setBackground(enabled ? d.getSystemColor(25) : null);
            }
        }
    }

    public boolean getEnabled() {
        return this.fEnabled;
    }

    public void setRegion(Position region) {
        this.fRegion = region;
    }

    public Position getRegion() {
        return this.fRegion;
    }

    public boolean isControlOkToUse() {
        StyledText t = this.getTextWidget();
        return t != null && !t.isDisposed();
    }

    public void setSelection(Position position) {
        if (position != null) {
            this.setSelectedRange(position.getOffset(), position.getLength());
        }
    }

    public void setLineBackground(Position position, Color c) {
        StyledText t = this.getTextWidget();
        if (t != null && !t.isDisposed()) {
            Point region = new Point(0, 0);
            this.getLineRange(position, region);
            region.x -= this.getDocumentRegionOffset();
            try {
                t.setLineBackground(region.x, region.y, c);
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
    }

    public void resetLineBackground() {
        StyledText t = this.getTextWidget();
        if (t != null && !t.isDisposed()) {
            int lines = this.getLineCount();
            t.setLineBackground(0, lines, null);
        }
    }

    public int getLineCount() {
        IRegion region = this.getVisibleRegion();
        int length = region.getLength();
        if (length == 0) {
            return 0;
        }
        IDocument doc = this.getDocument();
        int startLine = 0;
        int endLine = 0;
        int start = region.getOffset();
        try {
            startLine = doc.getLineOfOffset(start);
        }
        catch (BadLocationException badLocationException) {}
        try {
            endLine = doc.getLineOfOffset(start + length);
        }
        catch (BadLocationException badLocationException) {}
        return endLine - startLine + 1;
    }

    public int getViewportLines() {
        StyledText te = this.getTextWidget();
        Rectangle clArea = te.getClientArea();
        if (!clArea.isEmpty()) {
            return clArea.height / te.getLineHeight();
        }
        return 0;
    }

    public int getViewportHeight() {
        StyledText te = this.getTextWidget();
        Rectangle clArea = te.getClientArea();
        if (!clArea.isEmpty()) {
            return clArea.height;
        }
        return 0;
    }

    public int getDocumentRegionOffset() {
        int start = this.getVisibleRegion().getOffset();
        IDocument doc = this.getDocument();
        if (doc != null) {
            try {
                return doc.getLineOfOffset(start);
            }
            catch (BadLocationException badLocationException) {}
        }
        return 0;
    }

    public int getVerticalScrollOffset() {
        StyledText st = this.getTextWidget();
        int lineHeight = st.getLineHeight();
        return this.getTopInset() - (this.getDocumentRegionOffset() * lineHeight + st.getTopPixel());
    }

    public Point getLineRange(Position p, Point region) {
        IDocument doc = this.getDocument();
        if (p == null || doc == null) {
            region.x = 0;
            region.y = 0;
            return region;
        }
        int start = p.getOffset();
        int length = p.getLength();
        int startLine = 0;
        try {
            startLine = doc.getLineOfOffset(start);
        }
        catch (BadLocationException badLocationException) {}
        int lineCount = 0;
        if (length != 0) {
            int endLine = 0;
            try {
                endLine = doc.getLineOfOffset(start + length - 1);
            }
            catch (BadLocationException badLocationException) {}
            lineCount = endLine - startLine + 1;
        }
        region.x = startLine;
        region.y = lineCount;
        return region;
    }

    public void vscroll(int line) {
        int srcExtentSize;
        int srcViewSize = this.getLineCount();
        if (srcViewSize > (srcExtentSize = this.getViewportLines())) {
            int cp;
            if (line < 0) {
                line = 0;
            }
            if ((cp = this.getTopIndex()) != line) {
                this.setTopIndex(line + this.getDocumentRegionOffset());
            }
        }
    }

    public void addAction(String actionId, MergeViewerAction action) {
        this.fActions.put(actionId, action);
    }

    public MergeViewerAction getAction(String actionId) {
        MergeViewerAction action = (MergeViewerAction)((Object)this.fActions.get(actionId));
        if (action == null) {
            action = this.createAction(actionId);
            if (action == null) {
                return null;
            }
            if (action.isContentDependent()) {
                this.addTextListener(this);
            }
            if (action.isSelectionDependent()) {
                this.addSelectionChangedListener(this);
            }
            Utilities.initAction((IAction)action, this.fResourceBundle, "action." + actionId + ".");
            this.fActions.put(actionId, action);
        }
        if (action.isEditableDependent() && !this.isEditable()) {
            return null;
        }
        return action;
    }

    protected MergeViewerAction createAction(String actionId) {
        if (UNDO_ID.equals(actionId)) {
            return new TextOperationAction(1, true, false, true);
        }
        if (REDO_ID.equals(actionId)) {
            return new TextOperationAction(2, true, false, true);
        }
        if (CUT_ID.equals(actionId)) {
            return new TextOperationAction(3, true, true, false);
        }
        if (COPY_ID.equals(actionId)) {
            return new TextOperationAction(4, false, true, false);
        }
        if (PASTE_ID.equals(actionId)) {
            return new TextOperationAction(5, true, false, false);
        }
        if (DELETE_ID.equals(actionId)) {
            return new TextOperationAction(6, true, false, false);
        }
        if (SELECT_ALL_ID.equals(actionId)) {
            return new TextOperationAction(7, false, false, false);
        }
        return null;
    }

    public void selectionChanged(SelectionChangedEvent event) {
        Iterator e = this.fActions.values().iterator();
        while (e.hasNext()) {
            MergeViewerAction action = (MergeViewerAction)((Object)e.next());
            if (!action.isSelectionDependent()) continue;
            action.update();
        }
    }

    public void textChanged(TextEvent event) {
        Iterator e = this.fActions.values().iterator();
        while (e.hasNext()) {
            MergeViewerAction action = (MergeViewerAction)((Object)e.next());
            if (!action.isContentDependent()) continue;
            action.update();
        }
    }

    public void menuAboutToShow(IMenuManager menu) {
        menu.add((IContributionItem)new Separator(UNDO_ID));
        this.addMenu(menu, UNDO_ID);
        this.addMenu(menu, REDO_ID);
        menu.add((IContributionItem)new Separator("ccp"));
        this.addMenu(menu, CUT_ID);
        this.addMenu(menu, COPY_ID);
        this.addMenu(menu, PASTE_ID);
        this.addMenu(menu, DELETE_ID);
        this.addMenu(menu, SELECT_ALL_ID);
        menu.add((IContributionItem)new Separator("edit"));
        menu.add((IContributionItem)new Separator("find"));
        menu.add((IContributionItem)new Separator(SAVE_ID));
        if (this.fAddSaveAction) {
            this.addMenu(menu, SAVE_ID);
        }
        menu.add((IContributionItem)new Separator("rest"));
    }

    private void addMenu(IMenuManager menu, String actionId) {
        MergeViewerAction action = this.getAction(actionId);
        if (action != null) {
            menu.add((IAction)action);
        }
    }

    protected void handleDispose() {
        this.removeTextListener(this);
        this.removeSelectionChangedListener(this);
        super.handleDispose();
    }

    class TextOperationAction
    extends MergeViewerAction {
        private int fOperationCode;

        TextOperationAction(int operationCode, boolean mutable, boolean selection, boolean content) {
            super(mutable, selection, content);
            this.fOperationCode = operationCode;
            this.update();
        }

        public void run() {
            if (this.isEnabled()) {
                MergeSourceViewer.this.doOperation(this.fOperationCode);
            }
        }

        public boolean isEnabled() {
            return this.fOperationCode != -1 && MergeSourceViewer.this.canDoOperation(this.fOperationCode);
        }

        public void update() {
            this.setEnabled(this.isEnabled());
        }
    }
}

