/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui.synchronize.actions;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.team.internal.ui.Policy;
import org.eclipse.team.internal.ui.Utils;
import org.eclipse.team.ui.synchronize.ISynchronizeParticipant;
import org.eclipse.ui.PlatformUI;

public class PinParticipantAction
extends Action
implements IPropertyChangeListener {
    private ISynchronizeParticipant participant;

    public PinParticipantAction() {
        Utils.initAction((IAction)this, "action.pinParticipant.", Policy.getBundle());
    }

    public void setParticipant(ISynchronizeParticipant participant) {
        if (this.participant != null) {
            this.participant.removePropertyChangeListener(this);
        }
        this.participant = participant;
        this.setEnabled(participant != null);
        if (participant != null) {
            participant.addPropertyChangeListener(this);
        }
        this.updateState();
    }

    private void updateState() {
        this.setChecked(this.participant != null && this.participant.isPinned());
    }

    public void run() {
        if (this.participant != null) {
            try {
                PlatformUI.getWorkbench().getProgressService().busyCursorWhile(new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        PinParticipantAction.this.participant.setPinned(!PinParticipantAction.this.participant.isPinned());
                        PinParticipantAction.this.updateState();
                    }
                });
            }
            catch (InvocationTargetException e) {
                Utils.handle(e);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (event.getSource() == this.participant) {
            this.updateState();
        }
    }

    public void dispose() {
        if (this.participant != null) {
            this.participant.removePropertyChangeListener(this);
        }
    }
}

