/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui.preferences;

import java.text.Collator;
import java.text.DateFormat;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.RadioGroupFieldEditor;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.team.internal.ui.IPreferenceIds;
import org.eclipse.team.internal.ui.Policy;
import org.eclipse.team.internal.ui.TeamUIPlugin;
import org.eclipse.team.internal.ui.preferences.ComboFieldEditor;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IPerspectiveRegistry;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;

public class SyncViewerPreferencePage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage,
IPreferenceIds {
    private BooleanFieldEditor compressFolders = null;
    private BooleanFieldEditor showSyncInLabels = null;
    private BooleanFieldEditor useDefaultPerspective = null;
    private RadioGroupFieldEditor synchronizePerspectiveSwitch = null;

    public SyncViewerPreferencePage() {
        super(1);
        this.setTitle(Policy.bind("SyncViewerPreferencePage.6"));
        this.setDescription(Policy.bind("SyncViewerPreferencePage.7"));
        this.setPreferenceStore(TeamUIPlugin.getPlugin().getPreferenceStore());
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
    }

    public void createFieldEditors() {
        this.compressFolders = new BooleanFieldEditor("org.eclipse.team.ui.compress_folders", Policy.bind("SyncViewerPreferencePage.9"), 0, this.getFieldEditorParent());
        this.addField((FieldEditor)this.compressFolders);
        this.showSyncInLabels = new BooleanFieldEditor("org.eclipse.team.ui.view_syncinfo_in_label", Policy.bind("SyncViewerPreferencePage.19"), 0, this.getFieldEditorParent());
        this.addField((FieldEditor)this.showSyncInLabels);
        this.synchronizePerspectiveSwitch = new RadioGroupFieldEditor("org.eclipse.team.ui.sychronizing_default_perspective_to_show", Policy.bind("SyncViewerPreferencePage.13"), 3, (String[][])new String[][]{{Policy.bind("SyncViewerPreferencePage.14"), "always"}, {Policy.bind("SyncViewerPreferencePage.42"), "never"}, {Policy.bind("SyncViewerPreferencePage.16"), "prompt"}}, this.getFieldEditorParent(), true);
        this.addField((FieldEditor)this.synchronizePerspectiveSwitch);
        Group perspectiveGroup = this.createGroup(this.getFieldEditorParent(), Policy.bind("SyncViewerPreferencePage.15"));
        this.createLabel((Composite)perspectiveGroup, Policy.bind("SynchronizationViewPreference.defaultPerspectiveDescription"), 1);
        SyncViewerPreferencePage.handleDeletedPerspectives();
        String[][] perspectiveNamesAndIds = this.getPerspectiveNamesAndIds();
        ComboFieldEditor comboEditor = new ComboFieldEditor("org.eclipse.team.ui.syncview_default_perspective", Policy.bind("SynchronizationViewPreference.defaultPerspectiveLabel"), perspectiveNamesAndIds, (Composite)perspectiveGroup);
        this.addField(comboEditor);
        Dialog.applyDialogFont((Control)this.getFieldEditorParent());
        this.updateLayout((Composite)perspectiveGroup);
        this.getFieldEditorParent().layout(true);
    }

    private Label createLabel(Composite parent, String title, int spacer) {
        Label l = new Label(parent, 64);
        l.setFont(parent.getFont());
        GridData data = new GridData();
        data.horizontalSpan = 2;
        if (spacer != 0) {
            data.verticalSpan = spacer;
        }
        data.horizontalAlignment = 4;
        l.setLayoutData((Object)data);
        if (title != null) {
            l.setText(title);
        }
        return l;
    }

    private Group createGroup(Composite parent, String title) {
        Group display = new Group(parent, 0);
        this.updateLayout((Composite)display);
        GridData data = new GridData();
        data.horizontalSpan = 2;
        data.horizontalAlignment = 4;
        display.setLayoutData((Object)data);
        display.setText(title);
        return display;
    }

    private void updateLayout(Composite composite) {
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginWidth = 5;
        layout.marginHeight = 5;
        layout.horizontalSpacing = 5;
        layout.verticalSpacing = 5;
        composite.setLayout((Layout)layout);
    }

    private void updateLastRunTime(Label label) {
        String text;
        long mills = 0L;
        if (mills == 0L) {
            String never = Policy.bind("SyncViewPreferencePage.lastRefreshRunNever");
            text = Policy.bind("SyncViewPreferencePage.lastRefreshRun", never);
        } else {
            Date lastTimeRun = new Date(mills);
            String sLastTimeRun = DateFormat.getDateTimeInstance(3, 3).format(lastTimeRun);
            text = Policy.bind("SyncViewPreferencePage.lastRefreshRun", sLastTimeRun);
        }
        label.setText(text);
    }

    public void init(IWorkbench workbench) {
    }

    public void propertyChange(PropertyChangeEvent event) {
        super.propertyChange(event);
    }

    public boolean performOk() {
        TeamUIPlugin.getPlugin().savePluginPreferences();
        return super.performOk();
    }

    protected void initialize() {
        super.initialize();
        this.updateEnablements();
    }

    protected void updateEnablements() {
    }

    private String[][] getPerspectiveNamesAndIds() {
        IPerspectiveRegistry registry = PlatformUI.getWorkbench().getPerspectiveRegistry();
        IPerspectiveDescriptor[] perspectiveDescriptors = registry.getPerspectives();
        Arrays.sort(perspectiveDescriptors, new PerspectiveDescriptorComparator());
        String[][] table = new String[perspectiveDescriptors.length + 1][2];
        table[0][0] = Policy.bind("SynchronizationViewPreference.defaultPerspectiveNone");
        table[0][1] = "org.eclipse.team.ui.sync_view_perspective_none";
        int i = 0;
        while (i < perspectiveDescriptors.length) {
            table[i + 1][0] = perspectiveDescriptors[i].getLabel();
            table[i + 1][1] = perspectiveDescriptors[i].getId();
            ++i;
        }
        return table;
    }

    private static void handleDeletedPerspectives() {
        IPreferenceStore store = TeamUIPlugin.getPlugin().getPreferenceStore();
        String id = store.getString("org.eclipse.team.ui.syncview_default_perspective");
        if (PlatformUI.getWorkbench().getPerspectiveRegistry().findPerspectiveWithId(id) == null) {
            store.putValue("org.eclipse.team.ui.syncview_default_perspective", "org.eclipse.team.ui.sync_view_perspective_none");
        }
    }

    private static class PerspectiveDescriptorComparator
    implements Comparator {
        PerspectiveDescriptorComparator() {
        }

        public int compare(Object o1, Object o2) {
            if (o1 instanceof IPerspectiveDescriptor && o2 instanceof IPerspectiveDescriptor) {
                String id1 = ((IPerspectiveDescriptor)o1).getLabel();
                String id2 = ((IPerspectiveDescriptor)o2).getLabel();
                return Collator.getInstance().compare(id1, id2);
            }
            return 0;
        }
    }
}

